/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.common.effect.MMEffects;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.FishBreedGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.BottomDwellerWaterCreature;
import net.voidarkana.marvelous_menagerie.common.entity.base.BreedableWaterAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import org.jetbrains.annotations.Nullable;

public class Hallucigenia
extends BottomDwellerWaterCreature
implements Bucketable {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flopAnimationState = new AnimationState();
    private static final Predicate<LivingEntity> SCARY_MOB = p_289442_ -> {
        if (p_289442_ instanceof Player && ((Player)p_289442_).m_7500_()) {
            return false;
        }
        return p_289442_.m_6095_() == EntityType.f_147039_ || p_289442_.m_6336_() != MobType.f_21644_;
    };
    static final TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(SCARY_MOB);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Hallucigenia.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Hallucigenia(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.switchNavigator(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80){

            @Nullable
            protected Vec3 m_7037_() {
                return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)1);
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, this.fintasticFoodIngredients(), false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, this.foodIngredients(), false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
    }

    @Override
    public Ingredient foodIngredients() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_});
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            for (Mob mob : this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(0.3), p_149013_ -> targetingConditions.m_26885_((LivingEntity)this, (LivingEntity)p_149013_))) {
                if (!mob.m_6084_() || !this.m_6779_((LivingEntity)mob)) continue;
                this.touch(mob);
            }
        }
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        super.m_8119_();
    }

    private void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
    }

    @Override
    @Nullable
    public SoundEvent getFlopSound() {
        return null;
    }

    private void touch(Mob pMob) {
        if (pMob.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f)) {
            if (this.m_217043_().m_188503_(100) > 75) {
                this.m_5496_(SoundEvents.f_12384_, 1.0f, 1.0f);
                this.m_19998_((ItemLike)MMItems.HALLUCIGENIC_SLIME.get());
            }
            pMob.m_147207_(new MobEffectInstance(MobEffects.f_19604_, 120, 3), (Entity)this);
            pMob.m_147207_(new MobEffectInstance((MobEffect)MMEffects.HALLUCINATING.get(), 120, 0), (Entity)this);
            pMob.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60, 0), (Entity)this);
            this.m_5496_(SoundEvents.f_12295_, 1.0f, 1.0f);
        }
    }

    public void m_6123_(Player pEntity) {
        if (pEntity instanceof ServerPlayer && pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f)) {
            if (!this.m_20067_()) {
                ((ServerPlayer)pEntity).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132162_, 0.0f));
            }
            if (this.m_217043_().m_188503_(100) > 75) {
                this.m_5496_(SoundEvents.f_12384_, 1.0f, 1.0f);
                this.m_19998_((ItemLike)MMItems.HALLUCIGENIC_SLIME.get());
            }
            pEntity.m_147207_(new MobEffectInstance(MobEffects.f_19604_, 120, 3), (Entity)this);
            pEntity.m_147207_(new MobEffectInstance((MobEffect)MMEffects.HALLUCINATING.get(), 120, 0), (Entity)this);
            pEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60, 0), (Entity)this);
        }
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_12435_, 0.005f, 1.25f);
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    public void m_6872_(ItemStack bucket) {
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.HALLUCIGENIA_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.TRIGGERED) {
            this.m_27497_(true);
        }
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_("Age", 3)) {
            this.m_27497_(true);
            if (dataTag.m_128441_("Age")) {
                this.setAge(dataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(dataTag.m_128471_("CanGrow"));
        }
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        return (BreedableWaterAnimal)((EntityType)MMEntities.HALLUCIGENIA.get()).m_20615_((Level)pLevel);
    }

    public boolean m_6785_(double p_213397_1_) {
        return !this.m_8077_() && !this.m_27487_();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11761_;
    }
}

