/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.client.events.MMEventBusClientEvents;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.AnimatedAttackGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.BabyPanicGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.FishBreedGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.FishFollowParentGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.WaterMountLookControl;
import net.voidarkana.marvelous_menagerie.common.entity.base.AbstractBasicFish;
import net.voidarkana.marvelous_menagerie.common.entity.base.BreedableWaterAnimal;
import net.voidarkana.marvelous_menagerie.common.entity.base.IAnimatedAttacker;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import net.voidarkana.marvelous_menagerie.util.MMTags;

public class Ophthalmosaurus
extends AbstractBasicFish
implements OwnableEntity,
NeutralMob,
IAnimatedAttacker {
    static final TargetingConditions SWIM_WITH_PLAYER_TARGETING = TargetingConditions.m_148353_().m_26883_(15.0).m_148355_();
    public final AnimationState leftAttackAnimationState = new AnimationState();
    public final AnimationState rightAttackAnimationState = new AnimationState();
    public final AnimationState eatAnimationState = new AnimationState();
    public int attackAnimationTimeout;
    public int eatAnimationTimeout;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)10, (int)29);
    @org.jetbrains.annotations.Nullable
    private UUID persistentAngerTarget;
    public Vec3 movement;
    private static final EntityDataAccessor<Boolean> IS_SADDLED = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_ARMOR = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> EATING_TIME = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OUT_OF_WATER_RIDING_TICKS = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> IS_TAMED = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BASE_VARIANT = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PATTERN_VARIANT = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Ophthalmosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Ophthalmosaurus(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.01f, true);
        this.f_21365_ = new WaterMountLookControl((Mob)this, 10);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        Ophthalmosaurus otherParent = (Ophthalmosaurus)pOtherParent;
        Ophthalmosaurus baby = (Ophthalmosaurus)((EntityType)MMEntities.OPHTHALMO.get()).m_20615_((Level)pLevel);
        if (this.m_217043_().m_188503_(10) == 0) {
            baby.setBaseColor(this.f_19796_.m_216339_(0, 3));
            baby.setPattern(this.f_19796_.m_216339_(0, 4));
        } else {
            baby.setBaseColor(this.f_19796_.m_188499_() ? this.getBaseColor() : otherParent.getBaseColor());
            baby.setPattern(this.f_19796_.m_188499_() ? this.getPattern() : otherParent.getPattern());
        }
        return baby;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.BABY_OPHTHALMO_BUCKET.get());
    }

    @Override
    public Ingredient foodIngredients() {
        return Ingredient.m_204132_(MMTags.Items.OPHTHALMO_FOOD);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new FishFollowParentGoal(this, 1.25));
        this.f_21346_.m_25352_(1, (Goal)new BabyPanicGoal((PathfinderMob)this, 1.25).setAlertOthers(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new AnimatedAttackGoal((PathfinderMob)this, 1.25, true, 6, 4));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, (double)1.15f, this.foodIngredients(), false));
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.15f));
        this.f_21345_.m_25352_(3, (Goal)new OphthalmoSwimWithPlayerGoal(this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new OphthalmoJumpGoal(this, 3));
        if (!this.m_217005_()) {
            this.f_21346_.m_25352_(3, (Goal)new OphthalmoOwnerHurtByTargetGoal(this));
            this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        }
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 1.2).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SADDLED, (Object)false);
        this.f_19804_.m_135372_(HAS_ARMOR, (Object)false);
        this.f_19804_.m_135372_(EATING_TIME, (Object)0);
        this.f_19804_.m_135372_(OUT_OF_WATER_RIDING_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_TAMED, (Object)false);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(BASE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(PATTERN_VARIANT, (Object)0);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Tame", this.isTamed());
        pCompound.m_128379_("IsSaddled", this.getIsSaddled());
        pCompound.m_128379_("HasArmor", this.getHasArmor());
        if (this.m_21805_() != null) {
            pCompound.m_128362_("Owner", this.m_21805_());
        }
        this.m_21678_(pCompound);
        pCompound.m_128405_("BaseColor", this.getBaseColor());
        pCompound.m_128405_("Pattern", this.getPattern());
        pCompound.m_128379_("IsAttacking", this.isAttacking());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        UUID uuid;
        super.m_7378_(pCompound);
        this.setTamed(pCompound.m_128471_("Tame"));
        this.setIsSaddled(pCompound.m_128471_("IsSaddled"));
        this.setHasArmor(pCompound.m_128471_("HasArmor"));
        if (pCompound.m_128403_("Owner")) {
            uuid = pCompound.m_128342_("Owner");
        } else {
            String s = pCompound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
        this.m_147285_(this.m_9236_(), pCompound);
        this.setBaseColor(pCompound.m_128451_("BaseColor"));
        this.setPattern(pCompound.m_128451_("Pattern"));
        this.setAttacking(pCompound.m_128471_("IsAttacking"));
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    @Override
    public void setAttacking(boolean pFromBucket) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)pFromBucket);
    }

    @Override
    public int attackAnimationTimeout() {
        return this.attackAnimationTimeout;
    }

    @Override
    public void setAttackAnimationTimeout(int attackAnimationTimeout) {
        this.attackAnimationTimeout = attackAnimationTimeout;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.getIsSaddled()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
        if (this.getHasArmor()) {
            this.m_19983_(this.m_6844_(EquipmentSlot.CHEST));
        }
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @org.jetbrains.annotations.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@org.jetbrains.annotations.Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (prev && this.m_6162_()) {
            return false;
        }
        return (!this.isOwnedBy(entity) || !this.m_7307_((Entity)entity)) && prev;
    }

    @org.jetbrains.annotations.Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@org.jetbrains.annotations.Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(pUuid));
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.m_269323_();
    }

    public void setTamed(boolean pTamed) {
        this.f_19804_.m_135381_(IS_TAMED, (Object)pTamed);
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(IS_TAMED);
    }

    public void setBaseColor(int color) {
        this.f_19804_.m_135381_(BASE_VARIANT, (Object)color);
    }

    public int getBaseColor() {
        return (Integer)this.f_19804_.m_135370_(BASE_VARIANT);
    }

    public void setPattern(int pattern) {
        this.f_19804_.m_135381_(PATTERN_VARIANT, (Object)pattern);
    }

    public int getPattern() {
        return (Integer)this.f_19804_.m_135370_(PATTERN_VARIANT);
    }

    public void tame(Player pPlayer) {
        this.setTamed(true);
        this.setOwnerUUID(pPlayer.m_20148_());
        this.m_9236_().m_7605_((Entity)this, (byte)7);
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.isTamed()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return entityIn.m_7306_((Entity)this);
    }

    public boolean wantsToAttack(LivingEntity pTarget, LivingEntity pOwner) {
        if (!(pTarget instanceof Creeper) && !(pTarget instanceof Ghast) && pTarget.m_20069_()) {
            if (pTarget instanceof Wolf) {
                Wolf wolf = (Wolf)pTarget;
                return !wolf.m_21824_() || wolf.m_269323_() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).m_7099_((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).m_30614_()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).m_21824_();
        }
        return false;
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn) && this.getAttackSound() != null) {
            this.m_5496_(this.getAttackSound(), 0.1f, 1.0f);
            return true;
        }
        return false;
    }

    public int getEatingTime() {
        return (Integer)this.f_19804_.m_135370_(EATING_TIME);
    }

    public void setEatingTime(int eat) {
        this.f_19804_.m_135381_(EATING_TIME, (Object)eat);
    }

    public int getOutOfWaterRidingTicks() {
        return (Integer)this.f_19804_.m_135370_(OUT_OF_WATER_RIDING_TICKS);
    }

    public void setOutOfWaterRidingTicks(int ticks) {
        this.f_19804_.m_135381_(OUT_OF_WATER_RIDING_TICKS, (Object)ticks);
    }

    public void setIsSaddled(boolean pSaddled) {
        this.f_19804_.m_135381_(IS_SADDLED, (Object)pSaddled);
    }

    public boolean getIsSaddled() {
        return (Boolean)this.f_19804_.m_135370_(IS_SADDLED);
    }

    public boolean isSaddleable() {
        return this.m_6084_() && this.isTamed();
    }

    public boolean canWearArmor() {
        return this.isTamed();
    }

    public boolean isArmor(ItemStack pStack) {
        return pStack.m_150930_((Item)MMItems.OPHTHALMO_ARMOR.get());
    }

    public void setHasArmor(boolean pHasArmor) {
        this.f_19804_.m_135381_(HAS_ARMOR, (Object)(pHasArmor && this.isWearingArmor() ? 1 : 0));
    }

    public boolean getHasArmor() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ARMOR);
    }

    public boolean isWearingArmor() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public void equipArmor(Player pPlayer, ItemStack pArmor) {
        if (this.isArmor(pArmor)) {
            this.setArmor(pArmor);
            this.setHasArmor(this.isWearingArmor());
        }
    }

    private void setArmor(ItemStack pArmor) {
        this.m_8061_(EquipmentSlot.CHEST, pArmor.m_255036_(1));
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    protected void doPlayerRide(Player pPlayer) {
        if (!this.m_9236_().f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
    }

    public boolean m_275843_() {
        return false;
    }

    public int m_6062_() {
        return 2500;
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public boolean isFood(ItemStack pStack) {
        return pStack.m_204117_(MMTags.Items.OPHTHALMO_FOOD) || this.fintasticFoodIngredients().test(pStack);
    }

    public boolean isHealingFood(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item.m_41472_() && pStack.getFoodProperties((LivingEntity)this).m_38746_();
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity = pSource.m_7639_();
        if (this.getHasArmor() && entity != null && !pSource.m_276093_(DamageTypes.f_268515_) && !pSource.m_276093_(DamageTypes.f_268493_) && !pSource.m_276093_(DamageTypes.f_268724_)) {
            this.damageItem(this.m_6844_(EquipmentSlot.CHEST));
            for (int j = 0; j < 5; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            return super.m_6469_(pSource, 0.0f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 10;
            if (this.f_19796_.m_188499_()) {
                this.leftAttackAnimationState.m_216977_(this.f_19797_);
            } else {
                this.rightAttackAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            --this.attackAnimationTimeout;
        }
        if (this.getEatingTime() > 0 && this.eatAnimationTimeout <= 0) {
            this.eatAnimationTimeout = 29;
            this.eatAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.eatAnimationTimeout;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_21525_()) {
            if (this.m_20160_()) {
                this.movement = new Vec3(this.m_20185_() - this.f_19854_, this.m_20186_() - this.f_19855_, this.m_20189_() - this.f_19856_);
            }
            if (this.m_20160_() && this.m_6688_() != null && this.m_9236_().f_46443_) {
                float added = (float)this.m_20182_().m_7098_() * (float)this.movement.m_7098_();
                float xTilt = Mth.m_14036_((float)added, (float)-25.0f, (float)20.0f);
                this.m_146926_(-Mth.m_14179_((float)this.m_146909_(), (float)xTilt, (float)xTilt));
            }
            if (this.m_9236_().f_46443_ && this.m_20069_() && this.m_20184_().m_82556_() > 0.03) {
                Vec3 vec3 = this.m_20252_(0.0f);
                float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
            if (this.getEatingTime() > 0) {
                switch (this.getEatingTime()) {
                    case 5: 
                    case 10: 
                    case 15: {
                        this.m_216990_(SoundEvents.f_11912_);
                    }
                }
                int prevEat = this.getEatingTime();
                this.setEatingTime(prevEat - 1);
            }
            if (this.m_20160_()) {
                if (this.m_20069_()) {
                    if (this.getOutOfWaterRidingTicks() > 0) {
                        this.setOutOfWaterRidingTicks(0);
                    }
                } else {
                    int prev = this.getOutOfWaterRidingTicks();
                    this.setOutOfWaterRidingTicks(prev + 1);
                }
            } else if (this.getOutOfWaterRidingTicks() > 0) {
                this.setOutOfWaterRidingTicks(0);
            }
        }
    }

    protected void m_274498_(Player pPlayer, Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        this.m_19915_(pPlayer.m_146908_(), this.m_146909_());
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.m_9236_().f_46443_ && (!this.m_20069_() && this.m_20096_() && this.m_20160_() || this.m_20160_() && this.m_6162_())) {
            this.m_20153_();
        }
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        double d0 = this.m_20186_() + this.m_6048_() + pPassenger.m_6049_();
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        pCallback.m_20372_(pPassenger, this.m_20185_() - (double)(0.3f * ySin), d0 + 0.005, this.m_20189_() + (double)(0.3f * yCos));
    }

    @Override
    public void m_7023_(Vec3 vec3d) {
        LivingEntity livingEntity;
        float speed = this.m_6113_();
        if (this.m_6109_() && this.m_6688_() != null && (livingEntity = this.m_6688_()) instanceof Player) {
            Player rider = (Player)livingEntity;
            speed = (float)this.m_21133_(Attributes.f_22279_);
            double moveX = vec3d.f_82479_;
            double moveY = vec3d.f_82480_;
            double moveZ = rider.f_20902_;
            this.f_20885_ = rider.f_20885_;
            if (this.m_9236_().f_46443_) {
                this.m_21563_().m_24964_(this.m_20182_().m_82520_(0.0, 2.0, 0.0));
            }
            if (this.m_6109_()) {
                if (this.m_20069_()) {
                    moveX = rider.f_20900_ * 3.0f;
                    moveZ = moveZ > 0.0 ? moveZ : 0.0;
                    moveZ *= 15.0;
                } else {
                    moveZ *= 0.75;
                }
                if (this.getOutOfWaterRidingTicks() > 0 && this.getOutOfWaterRidingTicks() < 5 || this.m_20069_()) {
                    if (this.m_20069_()) {
                        moveY = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_() ? 60.0 : (MMEventBusClientEvents.descendKey.m_90857_() ? -30.0 : 0.0);
                    } else {
                        double d = moveY = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_() ? (double)0.05f : 0.0;
                    }
                }
                if (moveZ < 1.0) {
                    moveY /= 2.0;
                }
                if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
                    if (this.getOutOfWaterRidingTicks() > 0 && this.getOutOfWaterRidingTicks() < 5 || this.m_20069_()) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.08, 0.0));
                    }
                } else if (MMEventBusClientEvents.descendKey.m_90857_() && this.m_20069_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
                }
                vec3d = new Vec3(moveX, moveY, moveZ);
                this.m_7910_(speed);
            } else if (rider instanceof Player) {
                this.m_267651_(true);
                this.m_20256_(Vec3.f_82478_);
                return;
            }
        }
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3d);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(vec3d);
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.m_20160_() && this.m_20069_() && !this.m_6162_()) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (!itemstack.m_41619_()) {
                InteractionResult interactionresult = itemstack.m_41647_(pPlayer, (LivingEntity)this, pHand);
                if (interactionresult.m_19077_()) {
                    return interactionresult;
                }
                if (itemstack.m_150930_(Items.f_42574_) && this.isTamed()) {
                    if (this.getHasArmor()) {
                        this.m_216990_((SoundEvent)MMSounds.PET_ARMOR_UNEQUIP.get());
                        this.m_19983_(this.m_6844_(EquipmentSlot.CHEST));
                        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
                        this.setHasArmor(false);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.getIsSaddled()) {
                        this.m_216990_(SoundEvents.f_12344_);
                        this.m_19998_((ItemLike)Items.f_42450_);
                        this.setIsSaddled(false);
                        return InteractionResult.SUCCESS;
                    }
                }
                if (itemstack.m_150930_((Item)MMItems.GOLDEN_SACA.get()) && !this.isTamed() && this.getEatingTime() == 0) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.setEatingTime(20);
                    this.tame(pPlayer);
                    if (pPlayer instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)pPlayer;
                        LootContext lootcontext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)this);
                        CriteriaTriggers.f_10590_.m_66234_(player, triggerInstance -> triggerInstance.m_68852_(lootcontext));
                    }
                    this.m_216990_(SoundEvents.f_11803_);
                    for (int j = 0; j < 5; ++j) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_150930_(Items.f_42450_) && this.isSaddleable() && !this.getIsSaddled()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.setIsSaddled(true);
                    this.m_216990_(SoundEvents.f_12034_);
                    return InteractionResult.SUCCESS;
                }
                if (this.canWearArmor() && this.isArmor(itemstack) && !this.isWearingArmor()) {
                    this.equipArmor(pPlayer, itemstack);
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_216990_((SoundEvent)MMSounds.PET_ARMOR_EQUIP.get());
                    return InteractionResult.SUCCESS;
                }
                if (this.isTamed()) {
                    if (this.isHealingFood(itemstack) && this.m_21223_() < this.m_21233_()) {
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        for (int j = 0; j < 5; ++j) {
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                        }
                        this.setEatingTime(20);
                        return InteractionResult.SUCCESS;
                    }
                    if (itemstack.m_150930_((Item)MMItems.CARIS_SCUTE.get()) && this.getHasArmor()) {
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        ItemStack armor = this.m_6844_(EquipmentSlot.CHEST);
                        int prevDamage = armor.m_41773_();
                        int durabilityLeft = armor.m_41776_() - armor.m_41773_();
                        if (durabilityLeft < armor.m_41776_()) {
                            if (armor.m_41776_() > durabilityLeft + 50) {
                                this.repairItem(this.m_6844_(EquipmentSlot.CHEST), 50);
                            } else {
                                this.repairItem(this.m_6844_(EquipmentSlot.CHEST), prevDamage);
                            }
                            for (int j = 0; j < 5; ++j) {
                                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                            }
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
            if (this.isTamed() && this.getIsSaddled()) {
                this.doPlayerRide(pPlayer);
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(pPlayer, pHand);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private void repairItem(ItemStack stack, int repair) {
        if (stack != null) {
            this.m_6844_(EquipmentSlot.CHEST).m_220157_(-repair, this.m_217043_(), null);
            this.m_5496_((SoundEvent)MMSounds.PET_ARMOR_REPAIR.get(), 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 0.8f);
        }
    }

    private void damageItem(ItemStack stack) {
        stack.m_220157_(1, this.m_217043_(), null);
        if (stack.m_41773_() >= stack.m_41776_()) {
            this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            this.m_216990_((SoundEvent)MMSounds.PET_ARMOR_BREAK.get());
            this.setHasArmor(false);
        } else if ((double)stack.m_41773_() == (double)stack.m_41776_() * 0.5 || (double)stack.m_41773_() == (double)stack.m_41776_() * 0.75 || (double)stack.m_41773_() == (double)stack.m_41776_() * 0.25) {
            this.m_5496_((SoundEvent)MMSounds.PET_ARMOR_CRACK.get(), 1.25f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
        }
        this.m_5496_((SoundEvent)MMSounds.PET_ARMOR_DAMAGE.get(), 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
    }

    public boolean isArmorHalfwayDamaged() {
        if (this.getHasArmor()) {
            ItemStack armor = this.m_6844_(EquipmentSlot.CHEST);
            return (double)armor.m_41773_() >= (double)armor.m_41776_() * 0.5 && (double)armor.m_41773_() < (double)armor.m_41776_() * 0.75;
        }
        return false;
    }

    public boolean isArmorQuarterDamaged() {
        if (this.getHasArmor()) {
            ItemStack armor = this.m_6844_(EquipmentSlot.CHEST);
            return (double)armor.m_41773_() >= (double)armor.m_41776_() * 0.75;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_20160_() && !this.m_21674_((LivingEntity)pPlayer);
    }

    @Override
    public SoundEvent getFlopSound() {
        return (SoundEvent)MMSounds.CREATURE_FLOPS.get();
    }

    @Override
    protected SoundEvent m_5501_() {
        return (SoundEvent)MMSounds.CREATURE_SWIM.get();
    }

    private SoundEvent getAttackSound() {
        return SoundEvents.f_12228_;
    }

    @Override
    protected SoundEvent m_7515_() {
        return this.m_20069_() ? (SoundEvent)MMSounds.OPHTHALMO_IDLE.get() : (SoundEvent)MMSounds.DOLPHIN_BLOWHOLE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)MMSounds.OPHTHALMO_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.OPHTHALMO_DEATH.get();
    }

    @Override
    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity m_6688_() {
        Entity passenger;
        Iterator var1 = this.m_20197_().iterator();
        do {
            if (var1.hasNext()) continue;
            return null;
        } while (!((passenger = (Entity)var1.next()) instanceof Player));
        return this.getIsSaddled() ? (Player)passenger : null;
    }

    protected boolean m_8091_() {
        return true;
    }

    @Override
    public boolean m_6785_(double p_213397_1_) {
        return !this.m_8077_() && !this.isTamed() && !this.m_27487_();
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        compoundnbt.m_128405_("BaseColor", this.getBaseColor());
        compoundnbt.m_128405_("Pattern", this.getPattern());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        super.m_142278_(pTag);
        this.setBaseColor(pTag.m_128451_("BaseColor"));
        this.setPattern(pTag.m_128451_("Pattern"));
        this.setCanGrowUp(pTag.m_128471_("CanGrow"));
        if (pTag.m_128441_("Age")) {
            this.setAge(pTag.m_128451_("Age"));
        } else {
            this.setAge(-24000);
        }
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @org.jetbrains.annotations.Nullable SpawnGroupData spawnDataIn, @org.jetbrains.annotations.Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_("Age", 3)) {
            if (dataTag.m_128441_("Age")) {
                this.setAge(dataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(dataTag.m_128471_("CanGrowUp"));
            this.setBaseColor(dataTag.m_128451_("BaseColor"));
            this.setPattern(dataTag.m_128451_("Pattern"));
            this.setCanGrowUp(dataTag.m_128471_("CanGrowUp"));
            this.m_27497_(true);
        } else {
            if (reason == MobSpawnType.BUCKET && dataTag == null) {
                this.setAge(-24000);
            }
            this.setBaseColor(this.f_19796_.m_216339_(0, 3));
            this.setPattern(this.f_19796_.m_216339_(0, 4));
        }
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public String getColorName(int color) {
        return switch (color) {
            case 1 -> "black";
            case 2 -> "green";
            default -> "blue";
        };
    }

    public String getPatternName(int color) {
        return switch (color) {
            case 2 -> "spots";
            case 3 -> "streak";
            default -> "stripes";
        };
    }

    @Override
    public boolean canBeBucketed() {
        return this.m_6162_();
    }

    static class OphthalmoSwimWithPlayerGoal
    extends Goal {
        private final Ophthalmosaurus dolphin;
        private final double speedModifier;
        @Nullable
        private Player player;

        OphthalmoSwimWithPlayerGoal(Ophthalmosaurus pDolphin, double pSpeedModifier) {
            this.dolphin = pDolphin;
            this.speedModifier = pSpeedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.player = this.dolphin.m_9236_().m_45946_(SWIM_WITH_PLAYER_TARGETING, (LivingEntity)this.dolphin);
            if (this.player == null || !this.dolphin.isTamed()) {
                return false;
            }
            if (this.player == this.dolphin.m_269323_()) {
                return this.player.m_6069_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.player != null && this.player.m_6069_() && this.dolphin.m_20280_((Entity)this.player) < 256.0;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            this.player = null;
            this.dolphin.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.dolphin.m_21563_().m_24960_((Entity)this.player, (float)(this.dolphin.m_8085_() + 20), (float)this.dolphin.m_8132_());
            if (this.dolphin.m_20280_((Entity)this.player) < 6.25) {
                this.dolphin.m_21573_().m_26573_();
            } else {
                this.dolphin.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
            }
        }
    }

    public class OphthalmoJumpGoal
    extends JumpGoal {
        private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
        private final Ophthalmosaurus dolphin;
        private final int interval;
        private boolean breached;

        public OphthalmoJumpGoal(Ophthalmosaurus pDolphin, int pInterval) {
            this.dolphin = pDolphin;
            this.interval = OphthalmoJumpGoal.m_186073_((int)pInterval);
        }

        public boolean m_8036_() {
            if (this.dolphin.m_217043_().m_188503_(this.interval) != 0) {
                return false;
            }
            Direction direction = this.dolphin.m_6374_();
            int i = direction.m_122429_();
            int j = direction.m_122431_();
            BlockPos blockpos = this.dolphin.m_20183_();
            for (int k : STEPS_TO_CHECK) {
                if (this.waterIsClear(blockpos, i, j, k) && this.surfaceIsClear(blockpos, i, j, k)) continue;
                return false;
            }
            return true;
        }

        private boolean waterIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
            BlockPos blockpos = pPos.m_7918_(pDx * pScale, 0, pDz * pScale);
            return this.dolphin.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !this.dolphin.m_9236_().m_8055_(blockpos).m_280555_();
        }

        private boolean surfaceIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
            return this.dolphin.m_9236_().m_8055_(pPos.m_7918_(pDx * pScale, 1, pDz * pScale)).m_60795_() && this.dolphin.m_9236_().m_8055_(pPos.m_7918_(pDx * pScale, 2, pDz * pScale)).m_60795_();
        }

        public boolean m_8045_() {
            double d0 = this.dolphin.m_20184_().f_82480_;
            return !(d0 * d0 < (double)0.03f && this.dolphin.m_146909_() != 0.0f && Math.abs(this.dolphin.m_146909_()) < 10.0f && this.dolphin.m_20069_() || this.dolphin.m_20096_());
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            Direction direction = this.dolphin.m_6374_();
            this.dolphin.m_20256_(this.dolphin.m_20184_().m_82520_((double)direction.m_122429_() * 0.6, 0.7, (double)direction.m_122431_() * 0.6));
            this.dolphin.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.dolphin.m_146926_(0.0f);
        }

        public void m_8037_() {
            boolean flag = this.breached;
            if (!flag) {
                FluidState fluidstate = this.dolphin.m_9236_().m_6425_(this.dolphin.m_20183_());
                this.breached = fluidstate.m_205070_(FluidTags.f_13131_);
            }
            if (this.breached && !flag) {
                this.dolphin.m_5496_(SoundEvents.f_11805_, 1.0f, 1.0f);
            }
            Vec3 vec3 = this.dolphin.m_20184_();
            if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && this.dolphin.m_146909_() != 0.0f) {
                this.dolphin.m_146926_(Mth.m_14189_((float)0.2f, (float)this.dolphin.m_146909_(), (float)0.0f));
            } else if (vec3.m_82553_() > (double)1.0E-5f) {
                double d0 = vec3.m_165924_();
                double d1 = Math.atan2(-vec3.f_82480_, d0) * 57.2957763671875;
                this.dolphin.m_146926_((float)d1);
            }
        }
    }

    public class OphthalmoOwnerHurtByTargetGoal
    extends TargetGoal {
        private final Ophthalmosaurus tameAnimal;
        private LivingEntity ownerLastHurtBy;
        private int timestamp;

        public OphthalmoOwnerHurtByTargetGoal(Ophthalmosaurus pTameAnimal) {
            super((Mob)pTameAnimal, false);
            this.tameAnimal = pTameAnimal;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.tameAnimal.isTamed() && !this.tameAnimal.m_20160_()) {
                LivingEntity livingentity = this.tameAnimal.m_269323_();
                if (livingentity == null) {
                    return false;
                }
                this.ownerLastHurtBy = livingentity.m_21188_();
                int i = livingentity.m_21213_();
                return i != this.timestamp && this.m_26150_(this.ownerLastHurtBy, TargetingConditions.f_26872_) && this.tameAnimal.wantsToAttack(this.ownerLastHurtBy, livingentity);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurtBy);
            LivingEntity livingentity = this.tameAnimal.m_269323_();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21213_();
            }
            super.m_8056_();
        }
    }
}

