/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralPlantBlock;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.base.AbstractBasicFish;
import net.voidarkana.marvelous_menagerie.common.entity.base.BreedableWaterAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import net.voidarkana.marvelous_menagerie.data.manager.PikaiaCoralManager;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import org.jetbrains.annotations.Nullable;

public class Pikaia
extends AbstractBasicFish {
    private static final EntityDataAccessor<Boolean> CAN_POLLINATE = SynchedEntityData.m_135353_(Pikaia.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_POLLINATING = SynchedEntityData.m_135353_(Pikaia.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Pikaia(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new ReviveCoralGoal(this));
    }

    @Override
    public Ingredient foodIngredients() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_});
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, (double)0.8f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_POLLINATING, (Object)false);
        this.f_19804_.m_135372_(CAN_POLLINATE, (Object)true);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("CanPollinate", this.canPollinate());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setCanPollinate(pCompound.m_128471_("CanPollinate"));
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        Pikaia baby = (Pikaia)((EntityType)MMEntities.PIKAIA.get()).m_20615_((Level)pLevel);
        baby.m_27497_(true);
        return baby;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.PIKAIA_BUCKET.get());
    }

    public boolean isPikachu() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && s.toLowerCase().contains("pikachu");
    }

    public boolean canPollinate() {
        return (Boolean)this.f_19804_.m_135370_(CAN_POLLINATE);
    }

    public void setCanPollinate(boolean fromBook) {
        this.f_19804_.m_135381_(CAN_POLLINATE, (Object)fromBook);
    }

    public boolean isPollinating() {
        return (Boolean)this.f_19804_.m_135370_(IS_POLLINATING);
    }

    public void setPollinating(boolean fromBook) {
        this.f_19804_.m_135381_(IS_POLLINATING, (Object)fromBook);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_150930_(Items.f_42576_) && this.canPollinate()) {
            this.usePlayerItem(pPlayer, pHand, itemStack);
            this.m_5496_(SoundEvents.f_11803_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
            this.setCanPollinate(false);
            for (int j = 0; j < 5; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 0.25, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_(Items.f_41910_) && !this.canPollinate()) {
            this.usePlayerItem(pPlayer, pHand, itemStack);
            this.m_5496_(SoundEvents.f_11803_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
            this.setCanPollinate(true);
            for (int j = 0; j < 5; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.25, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    @Override
    protected void usePlayerItem(Player pPlayer, InteractionHand pHand, ItemStack pStack) {
        if (!pPlayer.m_150110_().f_35937_) {
            pStack.m_41774_(1);
        }
    }

    class ReviveCoralGoal
    extends MoveToBlockGoal {
        private final Pikaia pikaiia;
        private int eatAnimationTick;

        public void m_8056_() {
            this.eatAnimationTick = 10;
            this.pikaiia.m_9236_().m_7605_((Entity)this.pikaiia, (byte)10);
        }

        public ReviveCoralGoal(Pikaia pikaia) {
            super((PathfinderMob)pikaia, 1.0, 16, 10);
            this.pikaiia = pikaia;
        }

        public boolean m_8036_() {
            if (!this.pikaiia.canPollinate()) {
                return false;
            }
            return super.m_8036_();
        }

        public double m_8052_() {
            return 1.5;
        }

        public void m_8037_() {
            super.m_8037_();
            this.pikaiia.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.pikaiia.m_8132_());
            if (this.m_25625_()) {
                if (!this.pikaiia.isPollinating()) {
                    this.pikaiia.setPollinating(true);
                }
                if (this.pikaiia.m_21573_().m_26570_() != null) {
                    this.pikaiia.m_21573_().m_26573_();
                }
                Level level = this.pikaiia.m_9236_();
                BlockPos blockpos = this.f_25602_;
                BlockState blockstate = level.m_8055_(blockpos);
                HashMap posBlockStateMap = Maps.newHashMap();
                if (blockstate.m_204336_(MMTags.Blocks.PIKAIA_REVIVING_TARGET) && !this.pikaiia.m_9236_().f_46443_) {
                    for (PikaiaCoralManager.PikaiaCoralData data : PikaiaCoralManager.DATA) {
                        Block input = data.input();
                        Block output = data.output();
                        if (blockstate == null || !blockstate.m_60713_(input)) continue;
                        if (blockstate.m_60734_() instanceof BaseCoralPlantTypeBlock) {
                            posBlockStateMap.put(blockpos, (BlockState)output.m_49966_().m_263224_((Property)BaseCoralPlantBlock.f_49158_, (Comparable)Boolean.valueOf(true)));
                            continue;
                        }
                        posBlockStateMap.put(blockpos, output.m_49966_());
                    }
                    for (BlockPos position : posBlockStateMap.keySet()) {
                        this.pikaiia.m_9236_().m_46796_(2005, position, 0);
                        BlockState output = (BlockState)posBlockStateMap.get(blockpos);
                        this.pikaiia.m_9236_().m_7731_(blockpos, output, 2);
                    }
                }
                this.f_25600_ = 1000;
                --this.eatAnimationTick;
            } else if (this.eatAnimationTick == 0) {
                this.pikaiia.setPollinating(false);
            }
        }

        public void m_8041_() {
            this.f_25600_ = 1000;
            this.eatAnimationTick = 0;
            this.pikaiia.setPollinating(false);
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockState blockstate = pLevel.m_8055_(pPos);
            return blockstate.m_204336_(MMTags.Blocks.PIKAIA_REVIVING_TARGET) && blockstate.m_60734_() instanceof BaseCoralPlantTypeBlock == blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        }
    }
}

