/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.base.AbstractBasicFish;
import net.voidarkana.marvelous_menagerie.common.entity.base.BreedableWaterAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import org.jetbrains.annotations.Nullable;

public class Sacabambaspis
extends AbstractBasicFish {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Sacabambaspis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Sacabambaspis(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public Ingredient foodIngredients() {
        return Ingredient.m_204132_((TagKey)ItemTags.f_13156_);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getVariant());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setVariant(pCompound.m_128451_("Variant"));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        super.m_6872_(bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128405_("Variant", this.getVariant());
        compoundnbt.m_128379_("CanGrowUp", this.getCanGrowUp().booleanValue());
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        super.m_142278_(pTag);
        this.setVariant(pTag.m_128451_("Variant"));
        this.setCanGrowUp(pTag.m_128471_("CanGrow"));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.TRIGGERED || reason == MobSpawnType.BREEDING) {
            this.m_27497_(true);
        }
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_("Variant", 3)) {
            if (dataTag.m_128441_("Age")) {
                this.setAge(dataTag.m_128451_("Age"));
            }
            this.m_27497_(dataTag.m_128471_("CanGrowUp"));
            this.setVariant(dataTag.m_128451_("Variant"));
            this.m_27497_(true);
        } else {
            int chance = this.m_217043_().m_188503_(100);
            int variant = chance > 94 ? 2 : this.m_217043_().m_188503_(2);
            this.setVariant(variant);
        }
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public String getVariantName(int variantNumber) {
        return switch (variantNumber) {
            case 1 -> "_blue";
            case 2 -> "_golden";
            default -> "";
        };
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        Sacabambaspis baby = (Sacabambaspis)((EntityType)MMEntities.SACABAMBASPIS.get()).m_20615_((Level)pLevel);
        Sacabambaspis otherSaca = (Sacabambaspis)pOtherParent;
        int chance = this.m_217043_().m_188503_(100);
        int variant = chance > 94 ? 2 : (this.m_217043_().m_188499_() ? this.getVariant() : otherSaca.getVariant());
        baby.setVariant(variant);
        baby.m_27497_(true);
        return baby;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.SACA_BUCKET.get());
    }
}

