/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.animal.DawnHorse;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;
import org.jetbrains.annotations.Nullable;

public class SkeletonDawnHorse
extends DawnHorse {
    public static final Predicate<Entity> BABY_ZOMBIE = entity -> entity.m_6084_() && entity instanceof Zombie && ((Zombie)entity).m_6162_() && !entity.m_20159_();

    public SkeletonDawnHorse(EntityType<? extends MarvelousAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_5625_(float pVolume) {
        if (this.m_20096_()) {
            super.m_5625_(0.3f);
        } else {
            super.m_5625_(Math.min(0.1f, pVolume * 25.0f));
        }
    }

    public boolean m_35506_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected float m_6108_() {
        return 0.96f;
    }

    public boolean m_275843_() {
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12426_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return SoundEvents.f_12427_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12425_;
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)MMEntities.SKELETON_DAWN_HORSE.get()).m_20615_((Level)p_146743_);
    }

    protected SoundEvent m_5501_() {
        if (this.m_20096_()) {
            if (!this.m_20160_()) {
                return SoundEvents.f_12380_;
            }
            ++this.gallopSoundCounter;
            if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                return SoundEvents.f_12430_;
            }
            if (this.gallopSoundCounter <= 5) {
                return SoundEvents.f_12380_;
            }
        }
        return SoundEvents.f_12428_;
    }

    @Override
    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.NATURAL) {
            List list = pLevel.m_6443_(Zombie.class, this.m_20191_().m_82377_(5.0, 3.0, 5.0), BABY_ZOMBIE);
            if (!list.isEmpty()) {
                Zombie zombie = (Zombie)list.get(0);
                zombie.m_20329_((Entity)this);
            } else {
                Zombie baby = (Zombie)EntityType.f_20501_.m_20615_(this.m_9236_());
                if (baby != null) {
                    baby.m_6863_(true);
                    baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                    baby.m_6518_(pLevel, pDifficulty, MobSpawnType.JOCKEY, null, null);
                    baby.m_20329_((Entity)this);
                    pLevel.m_7967_((Entity)baby);
                }
            }
        }
        return pSpawnData;
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.m_45517_(LightLayer.SKY, pPos) > pRandom.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = pLevel.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && pLevel.m_45517_(LightLayer.BLOCK, pPos) > i) {
            return false;
        }
        int j = pLevel.m_6018_().m_46470_() ? pLevel.m_46849_(pPos, 10) : pLevel.m_46803_(pPos);
        return j <= dimensiontype.m_223569_().m_214085_(pRandom);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends SkeletonDawnHorse> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && SkeletonDawnHorse.isDarkEnoughToSpawn(pLevel, pPos, pRandom) && SkeletonDawnHorse.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        super.m_19956_(pPassenger, pCallback);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        pCallback.m_20372_(pPassenger, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.5) + pPassenger.m_6049_() - 0.1, this.m_20189_() - (double)(0.1f * f1));
        if (pPassenger instanceof LivingEntity) {
            ((LivingEntity)pPassenger).f_20883_ = this.f_20883_;
        }
    }
}

