/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.effect.MMEffects;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.FishBreedGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.FishFollowParentGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.AbstractBasicFish;
import net.voidarkana.marvelous_menagerie.common.entity.base.BreedableWaterAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import org.jetbrains.annotations.Nullable;

public class StellerSeaCow
extends AbstractBasicFish {
    static final TargetingConditions SWIM_WITH_PLAYER_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    private static final EntityDataAccessor<Boolean> IS_BREACHING = SynchedEntityData.m_135353_(StellerSeaCow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public StellerSeaCow(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 5);
        this.f_21342_ = new StellerSwimmingController(this, 85, 10, 0.02f, 0.01f, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22279_, (double)0.8f);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, this.foodIngredients(), false));
        this.f_21345_.m_25352_(1, (Goal)new FishBreedGoal(this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new FishFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new SeaCowSwimWithPlayerGoal(this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomShallowSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(5, (Goal)new SeaCowBreachGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f, 0.02f, true));
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        this.m_6210_();
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        if (this.m_6162_()) {
            return super.m_6972_(pPose).m_20390_(0.5f, 0.75f);
        }
        return super.m_6972_(pPose);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BREACHING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("isBreaching", this.isBreaching());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsBreaching(pCompound.m_128471_("isBreaching"));
    }

    public boolean isBreaching() {
        return (Boolean)this.f_19804_.m_135370_(IS_BREACHING);
    }

    public void setIsBreaching(boolean isBreaching) {
        this.f_19804_.m_135381_(IS_BREACHING, (Object)isBreaching);
    }

    @Override
    public boolean isFood(ItemStack pStack) {
        return this.foodIngredients().test(pStack);
    }

    @Override
    public Ingredient foodIngredients() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41910_, Items.f_42576_, Items.f_42515_});
    }

    @Override
    public boolean canBeBucketed() {
        return this.m_6162_();
    }

    @Override
    public boolean canFlop() {
        return this.m_6162_();
    }

    @Override
    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.BUCKET && dataTag == null) {
            this.setAge(-24000);
        }
        this.m_146926_(0.0f);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        return (BreedableWaterAnimal)((EntityType)MMEntities.STELLER_SEA_COW.get()).m_20615_((Level)pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > 3.0 || this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType) && height > 3.0)) {
            this.findAirPosition();
            this.m_19920_(0.02f, new Vec3((double)this.f_20900_, (double)this.f_20901_, (double)this.f_20902_));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            pPlayer.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)pPlayer, (ItemStack)((Item)MMItems.STELLER_MILK.get()).m_7968_());
            pPlayer.m_21008_(pHand, itemstack1);
            if (!this.m_27487_()) {
                this.m_27497_(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.STELLER_BUCKET.get());
    }

    @Override
    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_() && !this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !this.isBreaching()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
        }
        super.m_7023_(pTravelVector);
    }

    private void findAirPosition() {
        Iterable iterable = BlockPos.m_121976_((int)Mth.m_14107_((double)(this.m_20185_() - 1.0)), (int)this.m_146904_(), (int)Mth.m_14107_((double)(this.m_20189_() - 1.0)), (int)Mth.m_14107_((double)(this.m_20185_() + 1.0)), (int)Mth.m_14107_((double)(this.m_20186_() + 8.0)), (int)Mth.m_14107_((double)(this.m_20189_() + 1.0)));
        BlockPos blockpos = null;
        for (BlockPos blockpos1 : iterable) {
            if (!this.givesAir((LevelReader)this.m_9236_(), blockpos1)) continue;
            blockpos = blockpos1;
            break;
        }
        if (blockpos == null) {
            blockpos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + 8.0), (double)this.m_20189_());
        }
        this.m_21573_().m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 0.8);
    }

    private boolean givesAir(LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        return pLevel.m_6425_(pPos).m_76178_() && blockstate.m_60647_((BlockGetter)pLevel, pPos, PathComputationType.LAND);
    }

    @Override
    protected SoundEvent m_5501_() {
        return (SoundEvent)MMSounds.CREATURE_SWIM.get();
    }

    public boolean m_5829_() {
        return !this.m_204029_(FluidTags.f_13131_) && !this.m_20096_() && !this.m_6162_() && this.isBreaching();
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.m_204029_(FluidTags.f_13131_)) {
            return (SoundEvent)MMSounds.STELLER_IDLE.get();
        }
        return (SoundEvent)MMSounds.DOLPHIN_BLOWHOLE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        if (this.m_204029_(FluidTags.f_13131_)) {
            return (SoundEvent)MMSounds.STELLER_HURT.get();
        }
        return (SoundEvent)MMSounds.STELLER_LAND_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.STELLER_DEATH.get();
    }

    public static class StellerSwimmingController
    extends MoveControl {
        private static final float FULL_SPEED_TURN_THRESHOLD = 10.0f;
        private static final float STOP_TURN_THRESHOLD = 60.0f;
        private final int maxTurnX;
        private final int maxTurnY;
        private final float inWaterSpeedModifier;
        private final float outsideWaterSpeedModifier;
        private final boolean applyGravity;
        private final StellerSeaCow StellerSeaCow;

        public StellerSwimmingController(StellerSeaCow StellerSeaCowIn, int pMaxTurnX, int pMaxTurnY, float pInWaterSpeedModifier, float pOutsideWaterSpeedModifier, boolean pApplyGravity) {
            super((Mob)StellerSeaCowIn);
            this.StellerSeaCow = StellerSeaCowIn;
            this.maxTurnX = pMaxTurnX;
            this.maxTurnY = pMaxTurnY;
            this.inWaterSpeedModifier = pInWaterSpeedModifier;
            this.outsideWaterSpeedModifier = pOutsideWaterSpeedModifier;
            this.applyGravity = pApplyGravity;
        }

        public void m_8126_() {
            if (this.applyGravity && this.StellerSeaCow.m_20069_() && this.StellerSeaCow.m_204036_(FluidTags.f_13131_) > (double)0.1f) {
                this.StellerSeaCow.m_20256_(this.StellerSeaCow.m_20184_().m_82520_(0.0, 0.005, 0.0));
            } else if (this.StellerSeaCow.m_20069_() && this.StellerSeaCow.m_21573_().m_26571_()) {
                this.StellerSeaCow.m_20256_(this.StellerSeaCow.m_20184_().m_82520_(0.0, -0.005, 0.0));
            } else if (this.StellerSeaCow.m_20069_() && this.StellerSeaCow.m_204036_(FluidTags.f_13131_) > 3.0) {
                this.StellerSeaCow.m_20256_(this.StellerSeaCow.m_20184_().m_82520_(0.0, 0.5, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.StellerSeaCow.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.StellerSeaCow.m_20185_();
                double d3 = d0 * d0 + (d1 = this.f_24976_ - this.StellerSeaCow.m_20186_()) * d1 + (d2 = this.f_24977_ - this.StellerSeaCow.m_20189_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.StellerSeaCow.m_21564_(0.0f);
                } else {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.StellerSeaCow.m_146922_(this.m_24991_(this.StellerSeaCow.m_146908_(), f, this.maxTurnY));
                    this.StellerSeaCow.f_20883_ = this.StellerSeaCow.m_146908_();
                    this.StellerSeaCow.f_20885_ = this.StellerSeaCow.m_146908_();
                    float f1 = (float)(this.f_24978_ * this.StellerSeaCow.m_21133_(Attributes.f_22279_));
                    if (this.StellerSeaCow.m_20069_()) {
                        this.StellerSeaCow.m_7910_(f1 * this.inWaterSpeedModifier);
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                            float f3 = -((float)(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                            f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)(-this.maxTurnX), (float)this.maxTurnX);
                            this.StellerSeaCow.m_146926_(this.m_24991_(this.StellerSeaCow.m_146909_(), f3, 5.0f));
                        }
                        float f6 = Mth.m_14089_((float)(this.StellerSeaCow.m_146909_() * ((float)Math.PI / 180)));
                        float f4 = Mth.m_14031_((float)(this.StellerSeaCow.m_146909_() * ((float)Math.PI / 180)));
                        this.StellerSeaCow.f_20902_ = f6 * f1;
                        this.StellerSeaCow.f_20901_ = -f4 * f1;
                    } else {
                        float f5 = Math.abs(Mth.m_14177_((float)(this.StellerSeaCow.m_146908_() - f)));
                        float f2 = StellerSwimmingController.getTurningSpeedFactor(f5);
                        this.StellerSeaCow.m_7910_(f1 * this.outsideWaterSpeedModifier * f2);
                    }
                }
            } else {
                this.StellerSeaCow.m_7910_(0.0f);
                this.StellerSeaCow.m_21570_(0.0f);
                this.StellerSeaCow.m_21567_(0.0f);
                this.StellerSeaCow.m_21564_(0.0f);
            }
        }

        private static float getTurningSpeedFactor(float p_249853_) {
            return 1.0f - Mth.m_14036_((float)((p_249853_ - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
        }
    }

    static class SeaCowSwimWithPlayerGoal
    extends Goal {
        private final StellerSeaCow dolphin;
        private final double speedModifier;
        @javax.annotation.Nullable
        private Player player;

        SeaCowSwimWithPlayerGoal(StellerSeaCow pDolphin, double pSpeedModifier) {
            this.dolphin = pDolphin;
            this.speedModifier = pSpeedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.player = this.dolphin.m_9236_().m_45946_(SWIM_WITH_PLAYER_TARGETING, (LivingEntity)this.dolphin);
            if (this.player == null) {
                return false;
            }
            return this.player.m_6069_() && this.dolphin.m_5448_() != this.player && this.player.m_204036_(FluidTags.f_13131_) < 5.0;
        }

        public boolean m_8045_() {
            return this.player != null && this.player.m_6069_() && this.dolphin.m_20280_((Entity)this.player) < 256.0 && this.player.m_204036_(FluidTags.f_13131_) < 5.0;
        }

        public void m_8056_() {
            this.player.m_147207_(new MobEffectInstance((MobEffect)MMEffects.SEA_COW_SERENITY.get(), 50), (Entity)this.dolphin);
        }

        public void m_8041_() {
            this.player = null;
            this.dolphin.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.dolphin.m_21563_().m_24960_((Entity)this.player, (float)(this.dolphin.m_8085_() + 20), (float)this.dolphin.m_8132_());
            if (this.dolphin.m_20280_((Entity)this.player) < 8.25) {
                this.dolphin.m_21573_().m_26573_();
            } else {
                this.dolphin.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
            }
            if (this.player.m_6069_() && this.player.m_9236_().f_46441_.m_188503_(6) == 0) {
                this.player.m_147207_(new MobEffectInstance((MobEffect)MMEffects.SEA_COW_SERENITY.get(), 50), (Entity)this.dolphin);
            }
        }
    }

    public static class RandomShallowSwimmingGoal
    extends RandomStrollGoal {
        public RandomShallowSwimmingGoal(PathfinderMob mob, double speedMod, int interval) {
            super(mob, speedMod, interval);
        }

        @javax.annotation.Nullable
        protected Vec3 m_7037_() {
            return BehaviorUtils.m_147444_((PathfinderMob)this.f_25725_, (int)7, (int)1);
        }
    }

    public static class SeaCowBreachGoal
    extends Goal {
        private final StellerSeaCow mob;
        int ticksBreaching;

        public SeaCowBreachGoal(StellerSeaCow pMob) {
            this.mob = pMob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_20069_() && this.mob.m_217043_().m_188503_(5000) == 0 && !this.mob.m_6162_();
        }

        public boolean m_8045_() {
            return this.mob.m_20069_() && this.mob.m_21188_() == null && !this.mob.m_203117_() && !this.mob.m_6060_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            this.mob.findAirPosition();
            this.ticksBreaching = 0;
        }

        public void m_8037_() {
            this.mob.findAirPosition();
            this.mob.m_19920_(0.02f, new Vec3((double)this.mob.f_20900_, (double)this.mob.f_20901_, (double)this.mob.f_20902_));
            this.mob.m_6478_(MoverType.SELF, this.mob.m_20184_());
            if (this.mob.m_204036_(FluidTags.f_13131_) <= 0.5) {
                if (this.ticksBreaching >= 60) {
                    this.mob.f_21345_.m_25386_().forEach(WrappedGoal::m_8056_);
                    this.m_8041_();
                } else {
                    this.mob.m_21573_().m_26573_();
                    this.mob.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                    if (!this.mob.isBreaching()) {
                        this.mob.setIsBreaching(true);
                    }
                }
                ++this.ticksBreaching;
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.setIsBreaching(false);
        }
    }
}

