/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.AnimatedAttackGoal;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Leptictidium;
import net.voidarkana.marvelous_menagerie.common.entity.base.IAnimatedAttacker;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import org.jetbrains.annotations.Nullable;

public class Thylacine
extends MarvelousAnimal
implements IAnimatedAttacker {
    public final AnimationState howlAnimationState = new AnimationState();
    public final AnimationState yawnAnimationState = new AnimationState();
    public final AnimationState attackAnimationState1 = new AnimationState();
    public final AnimationState attackAnimationState2 = new AnimationState();
    public int attackAnimationTimeout;
    public int howlAnimationTimeout;
    public int yawnAnimationTimeout;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42697_, Items.f_42648_, Items.f_42698_});
    public Player playerWhoFedIt;
    private static final EntityDataAccessor<Integer> HOWLING_TIME = SynchedEntityData.m_135353_(Thylacine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HOWLING = SynchedEntityData.m_135353_(Thylacine.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> YAWNING_TIME = SynchedEntityData.m_135353_(Thylacine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> YAWNING = SynchedEntityData.m_135353_(Thylacine.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_HANDKERCHIEF = SynchedEntityData.m_135353_(Thylacine.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> HANDKERCHIEF_COLOR = SynchedEntityData.m_135353_(Thylacine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> WOOL_ITEM = SynchedEntityData.m_135353_(Thylacine.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Thylacine.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int prevHowlTime;
    public int prevYawnTime;
    public int howlTickDuration = 80;

    public Thylacine(EntityType<? extends MarvelousAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AnimatedAttackGoal((PathfinderMob)this, 1.25, true, 7, 3));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Leptictidium.class, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        super.m_8099_();
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOWLING_TIME, (Object)0);
        this.f_19804_.m_135372_(HOWLING, (Object)false);
        this.f_19804_.m_135372_(YAWNING_TIME, (Object)0);
        this.f_19804_.m_135372_(YAWNING, (Object)false);
        this.f_19804_.m_135372_(HAS_HANDKERCHIEF, (Object)false);
        this.f_19804_.m_135372_(HANDKERCHIEF_COLOR, (Object)0);
        this.m_20088_().m_135372_(WOOL_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("howlingTime", this.getHowlingTime());
        compound.m_128379_("isHowling", this.getIsHowling());
        compound.m_128405_("yawningTime", this.getYawningTime());
        compound.m_128379_("isYawning", this.getIsYawning());
        compound.m_128379_("hasHandkerchief", this.getHasHandkerchief());
        if (!this.getWoolItem().m_41619_()) {
            compound.m_128365_("woolItem", (Tag)this.getWoolItem().m_41739_(new CompoundTag()));
        }
        compound.m_128379_("IsAttacking", this.isAttacking());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHowlingTime(compound.m_128451_("howlingTime"));
        this.setIsHowling(compound.m_128471_("isHowling"));
        this.setYawningTime(compound.m_128451_("yawningTime"));
        this.setIsYawning(compound.m_128471_("isYawning"));
        this.setIsYawning(compound.m_128471_("hasHandkerchief"));
        this.setHandkerchiefColor(compound.m_128451_("handkerchiefColor"));
        CompoundTag compoundtag = compound.m_128469_("woolItem");
        if (compoundtag != null && !compoundtag.m_128456_()) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
            this.setWoolItem(itemstack);
        }
        this.setAttacking(compound.m_128471_("IsAttacking"));
    }

    public ItemStack getWoolItem() {
        return (ItemStack)this.m_20088_().m_135370_(WOOL_ITEM);
    }

    public void setWoolItem(ItemStack pStack) {
        if (!pStack.m_41619_()) {
            pStack = pStack.m_255036_(1);
        }
        this.m_20088_().m_135381_(WOOL_ITEM, (Object)pStack);
    }

    public int getHandkerchiefColor() {
        return (Integer)this.f_19804_.m_135370_(HANDKERCHIEF_COLOR);
    }

    public void setHandkerchiefColor(int color) {
        this.f_19804_.m_135381_(HANDKERCHIEF_COLOR, (Object)color);
    }

    public boolean getHasHandkerchief() {
        return (Boolean)this.f_19804_.m_135370_(HAS_HANDKERCHIEF);
    }

    public boolean hasHandkerchief() {
        return this.getHasHandkerchief();
    }

    public void setHasHandkerchief(boolean hasHandkerchief) {
        this.f_19804_.m_135381_(HAS_HANDKERCHIEF, (Object)hasHandkerchief);
    }

    public int getHowlingTime() {
        return (Integer)this.f_19804_.m_135370_(HOWLING_TIME);
    }

    public void setHowlingTime(int howlingTicksTime) {
        this.f_19804_.m_135381_(HOWLING_TIME, (Object)howlingTicksTime);
    }

    public boolean getIsHowling() {
        return (Boolean)this.f_19804_.m_135370_(HOWLING);
    }

    public void setIsHowling(boolean howling) {
        this.f_19804_.m_135381_(HOWLING, (Object)howling);
    }

    public int getYawningTime() {
        return (Integer)this.f_19804_.m_135370_(YAWNING_TIME);
    }

    public void setYawningTime(int yawningTicksTime) {
        this.f_19804_.m_135381_(YAWNING_TIME, (Object)yawningTicksTime);
    }

    public boolean getIsYawning() {
        return (Boolean)this.f_19804_.m_135370_(YAWNING);
    }

    public void setIsYawning(boolean yawning) {
        this.f_19804_.m_135381_(YAWNING, (Object)yawning);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.getIsHowling() || this.getIsYawning()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            pTravelVector = Vec3.f_82478_;
            super.m_7023_(pTravelVector);
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public boolean isMetro() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && s.toLowerCase().contains("metropolitan");
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasHandkerchief()) {
            this.m_19983_(this.getWoolItem());
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult type = super.m_6071_(player, hand);
        if ((itemstack.m_150930_(Items.f_42581_) || itemstack.m_150930_(Items.f_42697_) || itemstack.m_150930_(Items.f_42582_) || itemstack.m_150930_(Items.f_42698_)) && !this.getIsHowling() && this.m_20096_() && !this.getIsYawning()) {
            this.m_142075_(player, hand, itemstack);
            this.setHowlingTime(80);
            this.playerWhoFedIt = player;
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_204117_(ItemTags.f_215867_) || itemstack.m_204117_(MMTags.Items.DYE_DEPOT_WOOL_ITEM)) {
            if (this.hasHandkerchief()) {
                this.m_19983_(this.getWoolItem());
            } else {
                this.setHasHandkerchief(true);
            }
            if (itemstack.m_150930_(Items.f_42197_)) {
                this.setHandkerchiefColor(1);
            } else if (itemstack.m_150930_(Items.f_42131_)) {
                this.setHandkerchiefColor(2);
            } else if (itemstack.m_150930_(Items.f_42134_)) {
                this.setHandkerchiefColor(3);
            } else if (itemstack.m_150930_(Items.f_42135_)) {
                this.setHandkerchiefColor(4);
            } else if (itemstack.m_150930_(Items.f_42143_)) {
                this.setHandkerchiefColor(5);
            } else if (itemstack.m_150930_(Items.f_42139_)) {
                this.setHandkerchiefColor(6);
            } else if (itemstack.m_150930_(Items.f_42133_)) {
                this.setHandkerchiefColor(7);
            } else if (itemstack.m_150930_(Items.f_42141_)) {
                this.setHandkerchiefColor(8);
            } else if (itemstack.m_150930_(Items.f_42140_)) {
                this.setHandkerchiefColor(9);
            } else if (itemstack.m_150930_(Items.f_42132_)) {
                this.setHandkerchiefColor(10);
            } else if (itemstack.m_150930_(Items.f_42136_)) {
                this.setHandkerchiefColor(11);
            } else if (itemstack.m_150930_(Items.f_42142_)) {
                this.setHandkerchiefColor(12);
            } else if (itemstack.m_150930_(Items.f_42198_)) {
                this.setHandkerchiefColor(13);
            } else if (itemstack.m_150930_(Items.f_42137_)) {
                this.setHandkerchiefColor(14);
            } else if (itemstack.m_150930_(Items.f_42138_)) {
                this.setHandkerchiefColor(15);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_AMBER_WOOL_ITEM)) {
                this.setHandkerchiefColor(16);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_AQUA_WOOL_ITEM)) {
                this.setHandkerchiefColor(17);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_BEIGE_WOOL_ITEM)) {
                this.setHandkerchiefColor(18);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_CORAL_WOOL_ITEM)) {
                this.setHandkerchiefColor(19);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_FOREST_WOOL_ITEM)) {
                this.setHandkerchiefColor(20);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_GINGER_WOOL_ITEM)) {
                this.setHandkerchiefColor(21);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_INDIGO_WOOL_ITEM)) {
                this.setHandkerchiefColor(22);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_MAROON_WOOL_ITEM)) {
                this.setHandkerchiefColor(23);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_MINT_WOOL_ITEM)) {
                this.setHandkerchiefColor(24);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_NAVY_WOOL_ITEM)) {
                this.setHandkerchiefColor(25);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_OLIVE_WOOL_ITEM)) {
                this.setHandkerchiefColor(26);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_ROSE_WOOL_ITEM)) {
                this.setHandkerchiefColor(27);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_SLATE_WOOL_ITEM)) {
                this.setHandkerchiefColor(28);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_TAN_WOOL_ITEM)) {
                this.setHandkerchiefColor(29);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_TEAL_WOOL_ITEM)) {
                this.setHandkerchiefColor(30);
            } else if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_VERDANT_WOOL_ITEM)) {
                this.setHandkerchiefColor(31);
            } else {
                this.setHandkerchiefColor(32);
            }
            this.m_5496_(SoundEvents.f_12100_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.setWoolItem(itemstack);
            this.m_142075_(player, hand, itemstack);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_(Items.f_42574_) && this.hasHandkerchief()) {
            this.setHasHandkerchief(false);
            this.m_19983_(this.getWoolItem());
            this.setWoolItem(ItemStack.f_41583_);
            this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    private void alertThreats() {
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(24.0, 12.0, 24.0));
        for (LivingEntity target : list) {
            if (target instanceof Thylacine || !target.m_6095_().m_204039_(MMTags.EntityTypes.THYLA_ALERT_TARGET) && !(target instanceof Monster) && !(target instanceof NeutralMob) || target.m_7307_((Entity)this.playerWhoFedIt)) continue;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60));
        }
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 10;
            if (this.m_217043_().m_188499_()) {
                this.attackAnimationState2.m_216977_(this.f_19797_);
            } else {
                this.attackAnimationState1.m_216977_(this.f_19797_);
            }
        } else {
            --this.attackAnimationTimeout;
        }
        if (this.getIsHowling() && this.howlAnimationTimeout <= 0) {
            this.howlAnimationTimeout = 80;
            this.howlAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.howlAnimationTimeout;
        }
        if (this.getIsYawning() && this.yawnAnimationTimeout <= 0) {
            this.yawnAnimationTimeout = 60;
            this.yawnAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.yawnAnimationTimeout;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getHowlingTime() > 0) {
            if (this.getIsHowling()) {
                this.m_21573_().m_26573_();
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            } else {
                this.setIsHowling(true);
            }
            if (this.getHowlingTime() == 65 && !this.m_9236_().f_46443_) {
                this.m_216990_((SoundEvent)MMSounds.THYLACINE_ALERT.get());
            }
            if (this.getHowlingTime() == 21 && !this.m_9236_().f_46443_) {
                this.m_216990_(SoundEvents.f_11700_);
            }
            if (this.getHowlingTime() == 1 && !this.m_9236_().f_46443_) {
                this.alertThreats();
            }
            this.prevHowlTime = this.getHowlingTime();
            this.setHowlingTime(this.prevHowlTime - 1);
        } else if (this.getIsHowling()) {
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8056_);
            this.setIsHowling(false);
        }
        if (this.m_217043_().m_188503_(5000) == 0 && !this.getIsYawning() && this.m_20096_() && !this.getIsHowling()) {
            this.setYawningTime(60);
        }
        if (this.getYawningTime() > 0) {
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            if (this.getIsYawning()) {
                this.m_21573_().m_26573_();
            } else {
                this.m_216990_((SoundEvent)MMSounds.THYLACINE_YAWN.get());
                this.setIsYawning(true);
            }
            this.prevYawnTime = this.getYawningTime();
            this.setYawningTime(this.prevYawnTime - 1);
        } else if (this.getIsYawning()) {
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8056_);
            this.setIsYawning(false);
        }
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            this.m_20124_(Pose.STANDING);
            this.m_6858_(d0 >= 1.25);
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)MMEntities.THYLACINE.get()).m_20615_((Level)pLevel);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MMSounds.THYLACINE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)MMSounds.THYLACINE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.THYLACINE_DEATH.get();
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    @Override
    public void setAttacking(boolean pFromBucket) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)pFromBucket);
    }

    @Override
    public int attackAnimationTimeout() {
        return this.attackAnimationTimeout;
    }

    @Override
    public void setAttackAnimationTimeout(int attackAnimationTimeout) {
        this.attackAnimationTimeout = attackAnimationTimeout;
    }
}

