/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.FishBreedGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.BottomDwellerWaterCreature;
import net.voidarkana.marvelous_menagerie.common.entity.base.BreedableWaterAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import org.jetbrains.annotations.Nullable;

public class Trilobite
extends BottomDwellerWaterCreature
implements Bucketable {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState spinIdleAnimationState = new AnimationState();
    private int idleSpinTimeout = 0;
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Trilobite.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT_MODEL = SynchedEntityData.m_135353_(Trilobite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT_BASE_COLOR = SynchedEntityData.m_135353_(Trilobite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT_SECOND_COLOR = SynchedEntityData.m_135353_(Trilobite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HIGHLIGHT_COLOR = SynchedEntityData.m_135353_(Trilobite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_HIGHLIGHT = SynchedEntityData.m_135353_(Trilobite.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LGBT_VARIANT = SynchedEntityData.m_135353_(Trilobite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Trilobite(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5){

            protected boolean m_202729_() {
                return super.m_202729_() && Trilobite.this.m_20072_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new MoveToWaterGoal(this, 0.5));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80){

            @Nullable
            protected Vec3 m_7037_() {
                return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)1);
            }

            public boolean m_8036_() {
                return Trilobite.this.m_20072_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, this.foodIngredients(), false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, this.fintasticFoodIngredients(), false));
    }

    @Override
    public Ingredient foodIngredients() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_});
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(VARIANT_MODEL, (Object)0);
        this.f_19804_.m_135372_(VARIANT_BASE_COLOR, (Object)0);
        this.f_19804_.m_135372_(VARIANT_SECOND_COLOR, (Object)0);
        this.f_19804_.m_135372_(HIGHLIGHT_COLOR, (Object)0);
        this.f_19804_.m_135372_(LGBT_VARIANT, (Object)0);
        this.f_19804_.m_135372_(HAS_HIGHLIGHT, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
        pCompound.m_128405_("Model", this.getVariantModel());
        pCompound.m_128405_("BaseColor", this.getVariantBaseColor());
        pCompound.m_128405_("SecondColor", this.getVariantSecondColor());
        pCompound.m_128405_("HighlightColor", this.getHighlightColor());
        pCompound.m_128379_("HasHighlight", this.getHasHighlight());
        pCompound.m_128405_("LGBTVariant", this.getLGBTVariant());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
        this.setVariantModel(pCompound.m_128451_("Model"));
        this.setVariantBaseColor(pCompound.m_128451_("BaseColor"));
        this.setVariantSecondColor(pCompound.m_128451_("SecondColor"));
        this.setHighlightColor(pCompound.m_128451_("HighlightColor"));
        this.setHasHighlight(pCompound.m_128471_("HasHighlight"));
        this.setLGBTVariant(pCompound.m_128451_("LGBTVariant"));
    }

    public void setLGBTVariant(int variant) {
        this.f_19804_.m_135381_(LGBT_VARIANT, (Object)variant);
    }

    public int getLGBTVariant() {
        return (Integer)this.f_19804_.m_135370_(LGBT_VARIANT);
    }

    public void setVariantModel(int variant) {
        this.f_19804_.m_135381_(VARIANT_MODEL, (Object)variant);
    }

    public int getVariantModel() {
        return (Integer)this.f_19804_.m_135370_(VARIANT_MODEL);
    }

    public void setVariantBaseColor(int variant) {
        this.f_19804_.m_135381_(VARIANT_BASE_COLOR, (Object)variant);
    }

    public int getVariantBaseColor() {
        return (Integer)this.f_19804_.m_135370_(VARIANT_BASE_COLOR);
    }

    public void setVariantSecondColor(int variant) {
        this.f_19804_.m_135381_(VARIANT_SECOND_COLOR, (Object)variant);
    }

    public int getVariantSecondColor() {
        return (Integer)this.f_19804_.m_135370_(VARIANT_SECOND_COLOR);
    }

    public void setHighlightColor(int variant) {
        this.f_19804_.m_135381_(HIGHLIGHT_COLOR, (Object)variant);
    }

    public int getHighlightColor() {
        return (Integer)this.f_19804_.m_135370_(HIGHLIGHT_COLOR);
    }

    public void setHasHighlight(boolean variant) {
        this.f_19804_.m_135381_(HAS_HIGHLIGHT, (Object)variant);
    }

    public boolean getHasHighlight() {
        return (Boolean)this.f_19804_.m_135370_(HAS_HIGHLIGHT);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        this.m_6210_();
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        if (this.getVariantModel() == 6) {
            return super.m_6972_(pPose).m_20390_(1.5f, 1.75f);
        }
        if (this.getVariantModel() == 5) {
            return super.m_6972_(pPose).m_20390_(0.5f, 1.0f);
        }
        return super.m_6972_(pPose);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        super.m_8119_();
        if (this.m_20072_() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.m_20072_() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
    }

    private void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
        if (this.idleSpinTimeout <= 0 && this.m_21573_().m_26571_()) {
            this.idleSpinTimeout = this.f_19796_.m_188503_(40) + 80;
            this.spinIdleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleSpinTimeout;
        }
    }

    @Override
    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            this.m_20124_(Pose.STANDING);
            this.m_6858_(d0 >= 1.33);
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    @Override
    @Nullable
    public SoundEvent getFlopSound() {
        return null;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_12435_, 0.005f, 1.25f);
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    public void m_6872_(ItemStack bucket) {
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        compoundnbt.m_128405_("Model", this.getVariantModel());
        compoundnbt.m_128405_("BaseColor", this.getVariantBaseColor());
        compoundnbt.m_128405_("SecondColor", this.getVariantSecondColor());
        compoundnbt.m_128405_("HighlightColor", this.getHighlightColor());
        compoundnbt.m_128379_("HasHighlight", this.getHasHighlight());
        compoundnbt.m_128405_("LGBTVariant", this.getLGBTVariant());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        this.setVariantModel(pTag.m_128451_("Model"));
        this.setVariantBaseColor(pTag.m_128451_("BaseColor"));
        this.setVariantSecondColor(pTag.m_128451_("SecondColor"));
        this.setHighlightColor(pTag.m_128451_("HighlightColor"));
        this.setLGBTVariant(pTag.m_128451_("LGBTVariant"));
        this.setHasHighlight(pTag.m_128471_("HasHighlight"));
        if (pTag.m_128441_("Age")) {
            this.setAge(pTag.m_128451_("Age"));
        }
        this.setCanGrowUp(pTag.m_128471_("CanGrow"));
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.TRILO_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    @Override
    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_((Item)MMItems.MAGIC_ROLL.get()) && this.getLGBTVariant() == 0) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            SimpleParticleType particleoptions = ParticleTypes.f_123758_;
            if (this.f_19796_.m_188503_(10) == 0) {
                this.setLGBTVariant(this.f_19796_.m_216339_(1, 14));
            } else {
                particleoptions = ParticleTypes.f_123762_;
            }
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            this.m_5496_(SoundEvents.f_11788_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(pPlayer, pVec, pHand);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.TRIGGERED) {
            this.m_27497_(true);
        }
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_("Model", 3)) {
            System.out.println(dataTag.m_128451_("Age"));
            this.setVariantModel(dataTag.m_128451_("Model"));
            this.setVariantBaseColor(dataTag.m_128451_("BaseColor"));
            this.setVariantSecondColor(dataTag.m_128451_("SecondColor"));
            this.setLGBTVariant(dataTag.m_128451_("LGBTVariant"));
            this.m_27497_(true);
            this.setCanGrowUp(dataTag.m_128471_("CanGrow"));
            this.setAge(dataTag.m_128451_("Age"));
            this.setHighlightColor(dataTag.m_128451_("HighlightColor"));
            this.setHasHighlight(dataTag.m_128471_("HasHighlight"));
        } else {
            int variantModelChange = this.f_19796_.m_216339_(0, 7);
            int variantColorBaseChange = this.f_19796_.m_216339_(0, 25);
            int variantColorSecondChange = this.f_19796_.m_216339_(0, 25);
            int variantColorHighlight = this.f_19796_.m_216339_(0, 25);
            boolean hasHighlight = this.f_19796_.m_188503_(3) == 0;
            this.setVariantModel(variantModelChange);
            this.setVariantBaseColor(variantColorBaseChange);
            this.setVariantSecondColor(variantColorSecondChange);
            this.setHighlightColor(variantColorHighlight);
            this.setHasHighlight(hasHighlight);
            int LGBTVariant = this.f_19796_.m_216339_(1, 14);
            if (this.f_19796_.m_188503_(50) == 0) {
                this.setLGBTVariant(LGBTVariant);
            } else {
                this.setLGBTVariant(0);
            }
        }
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        Trilobite otherParent = (Trilobite)pOtherParent;
        Trilobite baby = (Trilobite)((EntityType)MMEntities.TRILOBITE.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            boolean hasHighlightColor;
            int secondColor;
            int mainColor;
            int lowerQuality = Math.min(this.getFeedQuality(), otherParent.getFeedQuality());
            int highlightColor = switch (lowerQuality) {
                case 1 -> {
                    if (this.f_19796_.m_188499_()) {
                        mainColor = this.f_19796_.m_188503_(25);
                        secondColor = this.f_19796_.m_188503_(25);
                        hasHighlightColor = this.f_19796_.m_188503_(3) == 0;
                        yield this.f_19796_.m_188503_(25);
                    }
                    mainColor = this.f_19796_.m_188499_() ? this.getVariantBaseColor() : otherParent.getVariantBaseColor();
                    secondColor = this.f_19796_.m_188499_() ? this.getVariantSecondColor() : otherParent.getVariantSecondColor();
                    hasHighlightColor = this.f_19796_.m_188499_() ? this.getHasHighlight() : otherParent.getHasHighlight();
                    yield this.f_19796_.m_188499_() ? this.getHighlightColor() : otherParent.getHighlightColor();
                }
                case 2 -> {
                    mainColor = this.f_19796_.m_188499_() ? this.getVariantBaseColor() : otherParent.getVariantBaseColor();
                    secondColor = this.f_19796_.m_188499_() ? this.getVariantSecondColor() : otherParent.getVariantSecondColor();
                    hasHighlightColor = this.f_19796_.m_188499_() ? this.getHasHighlight() : otherParent.getHasHighlight();
                    yield this.f_19796_.m_188499_() ? this.getHighlightColor() : otherParent.getHighlightColor();
                }
                case 3 -> {
                    boolean parent = this.f_19796_.m_188499_();
                    mainColor = parent ? this.getVariantBaseColor() : otherParent.getVariantBaseColor();
                    secondColor = parent ? this.getVariantSecondColor() : otherParent.getVariantSecondColor();
                    hasHighlightColor = parent ? this.getHasHighlight() : otherParent.getHasHighlight();
                    yield parent ? this.getHighlightColor() : otherParent.getHighlightColor();
                }
                default -> {
                    mainColor = this.f_19796_.m_188503_(25);
                    secondColor = this.f_19796_.m_188503_(25);
                    hasHighlightColor = this.f_19796_.m_188503_(3) == 0;
                    yield this.f_19796_.m_188503_(25);
                }
            };
            int LGBTVariant = this.f_19796_.m_216339_(1, 14);
            if (this.f_19796_.m_188503_(60) == 0) {
                baby.setLGBTVariant(LGBTVariant);
            } else {
                baby.setLGBTVariant(0);
            }
            baby.setVariantModel(this.getVariantModel());
            baby.setVariantBaseColor(mainColor);
            baby.setVariantSecondColor(secondColor);
            baby.setHasHighlight(hasHighlightColor);
            baby.setHighlightColor(highlightColor);
            baby.m_27497_(true);
        }
        return baby;
    }

    @Override
    public boolean canMate(BreedableWaterAnimal pOtherAnimal) {
        Trilobite mate = (Trilobite)pOtherAnimal;
        return this.getVariantModel() == mate.getVariantModel() && super.canMate(mate);
    }

    public boolean m_6785_(double p_213397_1_) {
        return !this.m_8077_() && !this.m_27487_();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)MMSounds.ARTHROPOD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.ARTHROPOD_DEATH.get();
    }

    public boolean isLGBTrilo() {
        return this.getLGBTVariant() > 0;
    }

    public static String getLGBTVariantName(int i) {
        return switch (i) {
            case 1 -> "ace";
            case 2 -> "agender";
            case 3 -> "aro";
            case 4 -> "aroace";
            case 5 -> "bi";
            case 6 -> "enby";
            case 7 -> "gay";
            case 8 -> "genderfluid";
            case 9 -> "genderqueer";
            case 10 -> "lesbian";
            case 11 -> "lgbt";
            case 12 -> "pan";
            case 13 -> "trans";
            default -> "";
        };
    }

    public int m_6062_() {
        return 4800;
    }

    public static String getModelName(int i) {
        return switch (i) {
            case 1 -> "trident";
            case 2 -> "moon";
            case 3 -> "spiky";
            case 4 -> "feisty";
            case 5 -> "itty";
            case 6 -> "fat";
            default -> "curly";
        };
    }

    public static String getSize(int i) {
        return switch (i) {
            case 0, 1, 2, 3, 4 -> "mid";
            case 5 -> "itty";
            default -> "fat";
        };
    }

    public static String getColorName(int i) {
        return switch (i) {
            case 1 -> "black";
            case 2 -> "blue";
            case 3 -> "carbon";
            case 4 -> "clay";
            case 5 -> "cocoa";
            case 6 -> "dirt";
            case 7 -> "fig";
            case 8 -> "gravel";
            case 9 -> "green";
            case 10 -> "lime";
            case 11 -> "marsh";
            case 12 -> "minsk";
            case 13 -> "mossy";
            case 14 -> "mud";
            case 15 -> "olive";
            case 16 -> "orange";
            case 17 -> "pink";
            case 18 -> "purple";
            case 19 -> "red";
            case 20 -> "rosy";
            case 21 -> "sand";
            case 22 -> "teal";
            case 23 -> "white";
            case 24 -> "yellow";
            default -> "brown";
        };
    }

    static class MoveToWaterGoal
    extends MoveToBlockGoal {
        private final Trilobite turtle;

        MoveToWaterGoal(Trilobite pTurtle, double pSpeedModifier) {
            super((PathfinderMob)pTurtle, pSpeedModifier, 24);
            this.turtle = pTurtle;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.turtle.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.turtle.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            return !this.turtle.m_20069_() && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_60713_(Blocks.f_49990_);
        }
    }
}

