/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.base;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import net.voidarkana.marvelous_menagerie.util.config.CommonConfig;
import org.jetbrains.annotations.Nullable;

public abstract class BreedableWaterAnimal
extends WaterAnimal {
    public float currentRoll = 0.0f;
    private static final EntityDataAccessor<Boolean> IS_INVENTORY = SynchedEntityData.m_135353_(BreedableWaterAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> OUT_OF_WATER_TICKS = SynchedEntityData.m_135353_(BreedableWaterAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(BreedableWaterAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int BABY_START_AGE = -24000;
    private static final int FORCED_AGE_PARTICLE_TICKS = 40;
    protected int age;
    protected int forcedAge;
    protected int forcedAgeTimer;
    int prevTicksOutOfWater;
    protected static final int PARENT_AGE_AFTER_BREEDING = 6000;
    private int inLove;
    @javax.annotation.Nullable
    private UUID loveCause;
    private static final EntityDataAccessor<Integer> FEED_TYPE = SynchedEntityData.m_135353_(BreedableWaterAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_GROW_UP = SynchedEntityData.m_135353_(BreedableWaterAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        AgeableFishGroupData ageablemob$ageablemobgroupdata;
        this.setFromInventory(false);
        if (pSpawnData == null) {
            pSpawnData = new AgeableFishGroupData(true);
        }
        if ((ageablemob$ageablemobgroupdata = (AgeableFishGroupData)pSpawnData).isShouldSpawnBaby() && ageablemob$ageablemobgroupdata.getGroupSize() > 0 && pLevel.m_213780_().m_188501_() <= ageablemob$ageablemobgroupdata.getBabySpawnChance()) {
            this.setAge(-24000);
        }
        ageablemob$ageablemobgroupdata.increaseGroupSizeByOne();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @javax.annotation.Nullable
    public abstract BreedableWaterAnimal getBreedOffspring(ServerLevel var1, BreedableWaterAnimal var2);

    public int getAge() {
        if (this.m_9236_().f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(DATA_BABY_ID) != false ? -1 : 1;
        }
        return this.age;
    }

    public void ageUp(int pAmount, boolean pForced) {
        int i = this.getAge();
        if ((i += pAmount * 20) > 0) {
            i = 0;
        }
        int j = i - i;
        this.setAge(i);
        if (pForced) {
            this.forcedAge += j;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int pAmount) {
        this.ageUp(pAmount, false);
    }

    public void setAge(int pAge) {
        int i = this.getAge();
        this.age = pAge;
        if (i < 0 && pAge >= 0 || i >= 0 && pAge < 0) {
            this.f_19804_.m_135381_(DATA_BABY_ID, (Object)(pAge < 0 ? 1 : 0));
            this.ageBoundaryReached();
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_BABY_ID.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public int getOutOfWaterTicks() {
        return (Integer)this.f_19804_.m_135370_(OUT_OF_WATER_TICKS);
    }

    public void setOutOfWaterTicks(int variant) {
        this.f_19804_.m_135381_(OUT_OF_WATER_TICKS, (Object)variant);
    }

    protected void ageBoundaryReached() {
        Boat boat;
        Entity entity;
        if (!this.m_6162_() && this.m_20159_() && (entity = this.m_20202_()) instanceof Boat && !(boat = (Boat)entity).m_271938_((Entity)this)) {
            this.m_8127_();
        }
    }

    public boolean m_6162_() {
        return this.getAge() < 0;
    }

    public void m_6863_(boolean pBaby) {
        this.setAge(pBaby ? -24000 : 0);
    }

    public static int getSpeedUpSecondsWhenFeeding(int pTicksUntilAdult) {
        return (int)((float)(pTicksUntilAdult / 20) * 0.1f);
    }

    protected void m_8024_() {
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        super.m_8024_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        this.inLove = 0;
        return super.m_6469_(pSource, pAmount);
    }

    public int m_213860_() {
        return 1 + this.m_9236_().f_46441_.m_188503_(3);
    }

    protected void usePlayerItem(Player pPlayer, InteractionHand pHand, ItemStack pStack) {
        if (!pPlayer.m_150110_().f_35937_) {
            pStack.m_41774_(1);
        }
    }

    public boolean canFallInLove() {
        return this.inLove <= 0;
    }

    public void setInLove(@javax.annotation.Nullable Player pPlayer) {
        this.inLove = 600;
        if (pPlayer != null) {
            this.loveCause = pPlayer.m_20148_();
        }
        this.m_9236_().m_7605_((Entity)this, (byte)18);
    }

    public void setInLoveTime(int pInLove) {
        this.inLove = pInLove;
    }

    public int getInLoveTime() {
        return this.inLove;
    }

    @javax.annotation.Nullable
    public ServerPlayer getLoveCause() {
        if (this.loveCause == null) {
            return null;
        }
        Player player = this.m_9236_().m_46003_(this.loveCause);
        return player instanceof ServerPlayer ? (ServerPlayer)player : null;
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetLove() {
        this.inLove = 0;
    }

    public boolean canMate(BreedableWaterAnimal pOtherAnimal) {
        if (pOtherAnimal == this) {
            return false;
        }
        if (((Object)((Object)pOtherAnimal)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && pOtherAnimal.isInLove();
    }

    public void spawnChildFromBreeding(ServerLevel pLevel, BreedableWaterAnimal pMate) {
        boolean cancelled;
        BreedableWaterAnimal ageablemob = this.getBreedOffspring(pLevel, pMate);
        BreedableWaterAnimal ageableMob2 = null;
        BreedableWaterAnimal ageableMob3 = null;
        BreedableWaterAnimal ageableMob4 = null;
        BreedableWaterAnimal ageableMob5 = null;
        int lowerQuality = Math.min(this.getFeedQuality(), pMate.getFeedQuality());
        BabyFishSpawnEvent event = new BabyFishSpawnEvent((Mob)this, (Mob)pMate, ageablemob);
        ageablemob = event.getChild();
        if (lowerQuality > 0 && this.f_19796_.m_188499_() || lowerQuality > 2) {
            ageableMob2 = this.getBreedOffspring(pLevel, pMate);
            BabyFishSpawnEvent event2 = new BabyFishSpawnEvent((Mob)this, (Mob)pMate, ageableMob2);
            ageableMob2 = event2.getChild();
            if (lowerQuality > 1 && this.f_19796_.m_188503_(4) == 0 || lowerQuality > 2 && this.f_19796_.m_188499_()) {
                ageableMob3 = this.getBreedOffspring(pLevel, pMate);
                BabyFishSpawnEvent event3 = new BabyFishSpawnEvent((Mob)this, (Mob)pMate, ageableMob3);
                ageableMob3 = event3.getChild();
                if (lowerQuality > 2 && this.f_19796_.m_188499_()) {
                    ageableMob4 = this.getBreedOffspring(pLevel, pMate);
                    BabyFishSpawnEvent event4 = new BabyFishSpawnEvent((Mob)this, (Mob)pMate, ageableMob4);
                    ageableMob4 = event4.getChild();
                    if (this.f_19796_.m_188499_()) {
                        ageableMob5 = this.getBreedOffspring(pLevel, pMate);
                        BabyFishSpawnEvent event5 = new BabyFishSpawnEvent((Mob)this, (Mob)pMate, ageableMob5);
                        ageableMob5 = event5.getChild();
                    }
                }
            }
        }
        if (cancelled = MinecraftForge.EVENT_BUS.post((Event)event)) {
            this.setAge(6000);
            pMate.setAge(6000);
            this.resetLove();
            pMate.resetLove();
            return;
        }
        if (ageablemob != null) {
            ageablemob.m_6863_(true);
            ageablemob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageablemob);
            pLevel.m_47205_((Entity)ageablemob);
            if (ageableMob2 != null) {
                ageableMob2.m_6863_(true);
                ageableMob2.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob2);
                pLevel.m_47205_((Entity)ageableMob2);
                if (ageableMob3 != null) {
                    ageableMob3.m_6863_(true);
                    ageableMob3.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                    this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob3);
                    pLevel.m_47205_((Entity)ageableMob3);
                    if (ageableMob4 != null) {
                        ageableMob4.m_6863_(true);
                        ageableMob4.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                        this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob4);
                        pLevel.m_47205_((Entity)ageableMob4);
                        if (ageableMob5 != null) {
                            ageableMob5.m_6863_(true);
                            ageableMob5.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                            this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob5);
                            pLevel.m_47205_((Entity)ageableMob5);
                        }
                    }
                }
            }
        }
    }

    public void finalizeSpawnChildFromBreeding(ServerLevel pLevel, BreedableWaterAnimal pAnimal, @javax.annotation.Nullable BreedableWaterAnimal pBaby) {
        Optional.ofNullable(this.getLoveCause()).or(() -> Optional.ofNullable(pAnimal.getLoveCause())).ifPresent(p_277486_ -> {
            p_277486_.m_36220_(Stats.f_12937_);
            LootContext $$4 = EntityPredicate.m_36616_((ServerPlayer)p_277486_, (Entity)this);
            LootContext $$5 = EntityPredicate.m_36616_((ServerPlayer)p_277486_, (Entity)pAnimal);
            LootContext $$6 = pBaby != null ? EntityPredicate.m_36616_((ServerPlayer)p_277486_, (Entity)pBaby) : null;
            CriteriaTriggers.f_10581_.m_66234_(p_277486_, p_18653_ -> p_18653_.m_18675_($$4, $$5, $$6));
        });
        this.setAge(6000);
        pAnimal.setAge(6000);
        this.resetLove();
        pAnimal.resetLove();
        pLevel.m_7605_((Entity)this, (byte)18);
        if (pLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
            pLevel.m_7967_((Entity)new ExperienceOrb((Level)pLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(pId);
        }
    }

    protected BreedableWaterAnimal(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        if (this.hasNormalControls()) {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        }
    }

    public boolean hasNormalControls() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FEED_TYPE, (Object)0);
        this.f_19804_.m_135372_(CAN_GROW_UP, (Object)true);
        this.f_19804_.m_135372_(IS_INVENTORY, (Object)true);
        this.f_19804_.m_135372_(DATA_BABY_ID, (Object)false);
        this.f_19804_.m_135372_(OUT_OF_WATER_TICKS, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Age", this.getAge());
        pCompound.m_128405_("ForcedAge", this.forcedAge);
        pCompound.m_128379_("CanGrowUp", this.getCanGrowUp().booleanValue());
        pCompound.m_128379_("IsFromInventory", this.isFromInventory().booleanValue());
        pCompound.m_128405_("FeedQuality", this.getFeedQuality());
        pCompound.m_128405_("InLove", this.inLove);
        if (this.loveCause != null) {
            pCompound.m_128362_("LoveCause", this.loveCause);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAge(pCompound.m_128451_("Age"));
        this.forcedAge = pCompound.m_128451_("ForcedAge");
        this.setCanGrowUp(pCompound.m_128471_("CanGrowUp"));
        this.setFromInventory(pCompound.m_128471_("IsFromInventory"));
        this.setFeedQuality(pCompound.m_128451_("FeedQuality"));
        this.inLove = pCompound.m_128451_("InLove");
        this.loveCause = pCompound.m_128403_("LoveCause") ? pCompound.m_128342_("LoveCause") : null;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    public int getFeedQuality() {
        return (Integer)this.f_19804_.m_135370_(FEED_TYPE);
    }

    public void setFeedQuality(int variant) {
        this.f_19804_.m_135381_(FEED_TYPE, (Object)variant);
    }

    public Boolean getCanGrowUp() {
        return (Boolean)this.f_19804_.m_135370_(CAN_GROW_UP);
    }

    public void setCanGrowUp(boolean variant) {
        this.f_19804_.m_135381_(CAN_GROW_UP, (Object)variant);
    }

    public Boolean isFromInventory() {
        return (Boolean)this.f_19804_.m_135370_(IS_INVENTORY);
    }

    public void setFromInventory(boolean variant) {
        this.f_19804_.m_135381_(IS_INVENTORY, (Object)variant);
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_ && this.canFlop()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        if (!this.m_9236_().f_46443_) {
            if (!this.m_20069_() && this.getOutOfWaterTicks() < 5 && !this.m_20160_()) {
                this.prevTicksOutOfWater = this.getOutOfWaterTicks();
                this.setOutOfWaterTicks(this.prevTicksOutOfWater + 1);
            } else if (this.m_20069_() && this.getOutOfWaterTicks() > 0) {
                this.prevTicksOutOfWater = this.getOutOfWaterTicks();
                this.setOutOfWaterTicks(this.prevTicksOutOfWater - 1);
            }
        }
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.m_6084_()) {
            int i = this.getAge();
            if (i < 0) {
                this.setAge(++i);
            } else if (i > 0) {
                this.setAge(--i);
            }
        }
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        }
        float prevRoll = this.currentRoll;
        float targetRoll = Math.max(-0.45f, Math.min(0.45f, (this.m_146908_() - this.f_19859_) * 0.1f));
        targetRoll = -targetRoll;
        this.currentRoll = prevRoll + (targetRoll - prevRoll) * 0.05f;
        if (this.m_6084_() && !this.getCanGrowUp().booleanValue() && this.getAge() > -500) {
            int i = this.getAge();
            this.setAge(i - 6000);
        }
    }

    public boolean canSwim() {
        return true;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_() && this.canSwim()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, this.floatsUp() ? -0.005 : -0.01, 0.0));
            }
            this.m_267651_(true);
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @javax.annotation.Nullable
    public abstract SoundEvent getFlopSound();

    public boolean canFlop() {
        return true;
    }

    public boolean floatsUp() {
        return true;
    }

    protected void m_267689_(float pPartialTick) {
        float f = Math.min(pPartialTick * 4.0f, 1.0f);
        this.f_267362_.m_267566_(f, 0.4f);
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        int i = this.getAge();
        if (this.m_6162_() && itemstack.m_204117_(MMTags.Items.FINTASTIC_BAD_FEED) && this.getCanGrowUp().booleanValue()) {
            this.setCanGrowUp(false);
            this.setAge(-12000);
            for (int j = 0; j < 7; ++j) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isFood(itemstack) || itemstack.m_204117_(MMTags.Items.FINTASTIC_ALL_FEEDS)) {
            if (itemstack.m_204117_(MMTags.Items.FINTASTIC_FEED)) {
                this.setFeedQuality(0);
            }
            if (itemstack.m_204117_(MMTags.Items.FINTASTIC_QUALITY_FEED)) {
                this.setFeedQuality(1);
            }
            if (itemstack.m_204117_(MMTags.Items.FINTASTIC_GREAT_FEED)) {
                this.setFeedQuality(2);
            }
            if (itemstack.m_204117_(MMTags.Items.FINTASTIC_PREMIUM_FEED)) {
                this.setFeedQuality(3);
            }
            if (this.m_6162_() && this.getCanGrowUp().booleanValue()) {
                this.ageUp(BreedableWaterAnimal.getSpeedUpSecondsWhenFeedingFish(-i, this.getFeedQuality()), true);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                if (itemstack.m_204117_(MMTags.Items.FINTASTIC_PREMIUM_FEED)) {
                    this.setCanGrowUp(true);
                    for (int j = 0; j < 7; ++j) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                } else {
                    return InteractionResult.PASS;
                }
            }
            if (!this.m_9236_().f_46443_ && i == 0 && this.canFallInLove()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.setInLove(pPlayer);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.ageUp(BreedableWaterAnimal.getSpeedUpSecondsWhenFeeding(-i), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return super.m_7111_(pPlayer, pVec, pHand);
    }

    public static int getSpeedUpSecondsWhenFeedingFish(int pTicksUntilAdult, int multiplier) {
        return (int)((float)(pTicksUntilAdult / 20) * 0.1f * (float)(multiplier + 1));
    }

    public boolean isFood(ItemStack pStack) {
        return this.fintasticFoodIngredients().test(pStack) || this.foodIngredients().test(pStack);
    }

    public Ingredient foodIngredients() {
        return this.fintasticFoodIngredients();
    }

    public Ingredient fintasticFoodIngredients() {
        return Ingredient.m_204132_(MMTags.Items.FINTASTIC_ALL_FEEDS);
    }

    public static boolean checkSurfaceWaterCreatureRules(EntityType<? extends BreedableWaterAnimal> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_) && (Boolean)CommonConfig.NATURAL_SPAWNS.get() != false;
    }

    public static class AgeableFishGroupData
    implements SpawnGroupData {
        private int groupSize;
        private final boolean shouldSpawnBaby;
        private final float babySpawnChance;

        private AgeableFishGroupData(boolean pShouldSpawnBaby, float pBabySpawnChance) {
            this.shouldSpawnBaby = pShouldSpawnBaby;
            this.babySpawnChance = pBabySpawnChance;
        }

        public AgeableFishGroupData(boolean pShouldSpawnBaby) {
            this(pShouldSpawnBaby, 0.05f);
        }

        public AgeableFishGroupData(float pBabySpawnChance) {
            this(true, pBabySpawnChance);
        }

        public int getGroupSize() {
            return this.groupSize;
        }

        public void increaseGroupSizeByOne() {
            ++this.groupSize;
        }

        public boolean isShouldSpawnBaby() {
            return this.shouldSpawnBaby;
        }

        public float getBabySpawnChance() {
            return this.babySpawnChance;
        }
    }

    @Cancelable
    public class BabyFishSpawnEvent
    extends Event {
        private final Mob parentA;
        private final Mob parentB;
        private final Player causedByPlayer;
        private BreedableWaterAnimal child;

        public BabyFishSpawnEvent(Mob parentA, @Nullable Mob parentB, BreedableWaterAnimal proposedChild) {
            ServerPlayer causedByPlayer = null;
            if (parentA instanceof BreedableWaterAnimal) {
                causedByPlayer = ((BreedableWaterAnimal)parentA).getLoveCause();
            }
            if (causedByPlayer == null && parentB instanceof BreedableWaterAnimal) {
                causedByPlayer = ((BreedableWaterAnimal)parentB).getLoveCause();
            }
            this.parentA = parentA;
            this.parentB = parentB;
            this.causedByPlayer = causedByPlayer;
            this.child = proposedChild;
        }

        public Mob getParentA() {
            return this.parentA;
        }

        public Mob getParentB() {
            return this.parentB;
        }

        @Nullable
        public Player getCausedByPlayer() {
            return this.causedByPlayer;
        }

        @Nullable
        public BreedableWaterAnimal getChild() {
            return this.child;
        }

        public void setChild(BreedableWaterAnimal proposedChild) {
            this.child = proposedChild;
        }
    }
}

