/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.misc;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.voidarkana.marvelous_menagerie.client.particles.MMParticles;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.misc.RiftEntity;
import net.voidarkana.marvelous_menagerie.util.MMTags;

public class Fracture
extends Mob {
    private static final Predicate<LivingEntity> PLAYER = entity -> entity instanceof Player;
    static final TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(PLAYER);
    private static final EntityDataAccessor<Boolean> IS_NATURAL = SynchedEntityData.m_135353_(Fracture.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> OPENING_TIME = SynchedEntityData.m_135353_(Fracture.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OPENING_TIME_LAG = SynchedEntityData.m_135353_(Fracture.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CLOSING_TIME = SynchedEntityData.m_135353_(Fracture.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SUMMONING_TIME = SynchedEntityData.m_135353_(Fracture.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    EntityType<?> entityType;
    public float rot;
    public float oRot;
    public float tRot;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0);
    }

    public Fracture(EntityType<Fracture> fractureEntityType, Level level) {
        super(fractureEntityType, level);
        this.f_19850_ = true;
        this.m_20242_(true);
    }

    public Fracture(Level level, double pX, double pY, double pZ) {
        this((EntityType<Fracture>)((EntityType)MMEntities.FRACTURE.get()), level);
        this.m_146884_(new Vec3(pX, pY, pZ));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_NATURAL, (Object)false);
        this.f_19804_.m_135372_(OPENING_TIME, (Object)0);
        this.f_19804_.m_135372_(OPENING_TIME_LAG, (Object)0);
        this.f_19804_.m_135372_(CLOSING_TIME, (Object)0);
        this.f_19804_.m_135372_(SUMMONING_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsNatural", this.isNatural());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsNatural(pCompound.m_128471_("IsNatural"));
    }

    public boolean isNatural() {
        return (Boolean)this.f_19804_.m_135370_(IS_NATURAL);
    }

    public void setIsNatural(boolean pFromBucket) {
        this.f_19804_.m_135381_(IS_NATURAL, (Object)pFromBucket);
    }

    public int getOpeningTime() {
        return (Integer)this.f_19804_.m_135370_(OPENING_TIME);
    }

    public void setOpeningTime(int time) {
        this.f_19804_.m_135381_(OPENING_TIME, (Object)time);
    }

    public int getOpeningTimeLag() {
        return (Integer)this.f_19804_.m_135370_(OPENING_TIME_LAG);
    }

    public void setOpeningTimeLag(int time) {
        this.f_19804_.m_135381_(OPENING_TIME_LAG, (Object)time);
    }

    public int getClosingTime() {
        return (Integer)this.f_19804_.m_135370_(CLOSING_TIME);
    }

    public void setClosingTime(int time) {
        this.f_19804_.m_135381_(CLOSING_TIME, (Object)time);
    }

    public int getSummoningTime() {
        return (Integer)this.f_19804_.m_135370_(SUMMONING_TIME);
    }

    public void setSummoningTime(int time) {
        this.f_19804_.m_135381_(SUMMONING_TIME, (Object)time);
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.singleton(ItemStack.f_41583_);
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public boolean m_7337_(Entity pEntity) {
        return Fracture.canFractureCollideWith((Entity)this, pEntity);
    }

    public static boolean canFractureCollideWith(Entity pVehicle, Entity pEntity) {
        return pEntity.m_5829_() || pEntity.m_6094_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_20147_() {
        return super.m_20147_() && this.getOpeningTime() < 20;
    }

    public boolean isValid() {
        return this.getClosingTime() <= 0 && this.getOpeningTime() >= 50 && this.getSummoningTime() <= 0;
    }

    public void m_8119_() {
        float f2;
        if (this.m_217043_().m_188503_(100) == 0) {
            this.m_9236_().m_7785_((double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.5f, this.m_217043_().m_188501_() * 0.4f + 0.8f, false);
        }
        if (this.m_5842_()) {
            double d0 = this.m_20183_().m_123341_();
            double d1 = this.m_20183_().m_123342_() + 1;
            double d2 = this.m_20183_().m_123343_();
            if (this.m_217043_().m_188503_(16) == 0) {
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123774_, d0 + 0.5, d1, d2 + 0.5, 0.0, 0.04, 0.0);
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123774_, d0 + (double)this.m_217043_().m_188501_(), d1 + (double)this.m_217043_().m_188501_(), d2 + (double)this.m_217043_().m_188501_(), 0.0, 0.04, 0.0);
            }
        }
        if (this.getOpeningTime() == 0 && !this.isNatural()) {
            this.m_9236_().m_7107_((ParticleOptions)MMParticles.RIFT.get(), (double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 1.1, (double)this.m_20183_().m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        if (this.getOpeningTime() == 0 && this.isNatural()) {
            this.setOpeningTime(20);
            this.setOpeningTimeLag(18);
        }
        if (this.getOpeningTime() == 20) {
            this.m_5496_(SoundEvents.f_11983_, 1.0f, 0.75f);
        }
        if (this.getOpeningTime() == 20 || this.getSummoningTime() == 40) {
            for (int i = 0; i < 20; ++i) {
                int xSpeed = this.m_217043_().m_216339_(-2, 3);
                int ySpeed = this.m_217043_().m_216339_(-2, 3);
                int zSpeed = this.m_217043_().m_216339_(-2, 3);
                this.m_9236_().m_7107_((ParticleOptions)MMParticles.TIME_SHARD.get(), (double)(this.m_20183_().m_123341_() + xSpeed) + 0.5, (double)(this.m_20183_().m_123342_() + ySpeed) + 1.25, (double)(this.m_20183_().m_123343_() + zSpeed) + 0.5, (double)(-xSpeed), (double)(-ySpeed), (double)(-zSpeed));
            }
        }
        if (this.getOpeningTime() > 15) {
            int ySpeed;
            if (this.m_217043_().m_188503_(4) == 0) {
                int xSpeed = this.m_217043_().m_216339_(-2, 3);
                ySpeed = this.m_217043_().m_216339_(-2, 3);
                int zSpeed = this.m_217043_().m_216339_(-2, 3);
                this.m_9236_().m_7107_((ParticleOptions)MMParticles.TIME_SHARD.get(), (double)(this.m_20183_().m_123341_() + xSpeed) + 0.5, (double)(this.m_20183_().m_123342_() + ySpeed) + 1.25, (double)(this.m_20183_().m_123343_() + zSpeed) + 0.5, (double)(-xSpeed), (double)(-ySpeed), (double)(-zSpeed));
            }
            if (this.m_217043_().m_188503_(16) == 0) {
                int xSpeed = this.m_217043_().m_216339_(-2, 3);
                ySpeed = this.m_217043_().m_216339_(-2, 3);
                int zSpeed = this.m_217043_().m_216339_(-2, 3);
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123810_, (double)this.m_20183_().m_123341_() + (double)xSpeed / 1.75 + 0.5, (double)this.m_20183_().m_123342_() + (double)ySpeed / 1.75 + 1.25, (double)this.m_20183_().m_123343_() + (double)zSpeed / 1.75 + 0.5, 0.0, 0.0, 0.0);
            }
        }
        super.m_8119_();
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(2.0), p_149015_ -> RiftEntity.targetingConditions.m_26885_((LivingEntity)this, p_149015_));
        if (this.getSummoningTime() > 0) {
            int prevSummoningTime = this.getSummoningTime();
            if (this.getSummoningTime() == 40 && !this.m_9236_().f_46443_) {
                this.spawnCreature();
                if (this.isNatural()) {
                    for (int i = this.m_217043_().m_216339_(1, 6); i > 0; --i) {
                        BuiltInRegistries.f_256780_.m_203431_(MMTags.EntityTypes.TIME_ABERRATIONS).flatMap(entityTypeNamed -> entityTypeNamed.m_213653_(this.m_9236_().f_46441_)).ifPresent(entityTypeHolder -> {
                            this.entityType = (EntityType)entityTypeHolder.get();
                        });
                        if (this.entityType == MMEntities.MOLTEN.get() && this.f_19796_.m_188503_(4) == 0) {
                            this.entityType = this.m_217043_().m_188503_(3) == 0 ? (EntityType)MMEntities.CHUD.get() : (EntityType)MMEntities.BEHOLDER.get();
                        }
                        this.spawnCreature();
                    }
                    this.setClosingTime(3);
                }
            }
            this.setSummoningTime(prevSummoningTime - 1);
        }
        if (this.getOpeningTime() > 2 && this.getOpeningTimeLag() < 50) {
            int prevOpeningTimeLag = this.getOpeningTimeLag();
            this.setOpeningTimeLag(prevOpeningTimeLag + 1);
        }
        if (this.getOpeningTime() < 50) {
            int prevOpeningTime = this.getOpeningTime();
            this.setOpeningTime(prevOpeningTime + 1);
        }
        if (this.getClosingTime() > 0) {
            int nextClosingTime = this.getClosingTime() - 1;
            if (nextClosingTime == 0) {
                this.m_146870_();
            } else if (nextClosingTime == 3) {
                for (int i = 0; i < 20; ++i) {
                    int xSpeed = this.m_217043_().m_216339_(-2, 3);
                    int ySpeed = this.m_217043_().m_216339_(-2, 3);
                    int zSpeed = this.m_217043_().m_216339_(-2, 3);
                    this.m_9236_().m_7107_((ParticleOptions)MMParticles.TIME_SHARD.get(), (double)(this.m_20183_().m_123341_() + xSpeed) + 0.5, (double)(this.m_20183_().m_123342_() + ySpeed) + 1.25, (double)(this.m_20183_().m_123343_() + zSpeed) + 0.5, (double)(-xSpeed), (double)(-ySpeed), (double)(-zSpeed));
                }
            }
            this.setClosingTime(nextClosingTime);
        }
        this.oRot = this.rot;
        this.tRot += 0.02f;
        while (this.rot >= (float)Math.PI) {
            this.rot -= (float)Math.PI * 2;
        }
        while (this.rot < (float)(-Math.PI)) {
            this.rot += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.rot += f2 * 0.4f;
        if (!list.isEmpty() && this.isValid() && this.isNatural()) {
            BuiltInRegistries.f_256780_.m_203431_(MMTags.EntityTypes.TIME_ABERRATIONS).flatMap(entityTypeNamed -> entityTypeNamed.m_213653_(this.m_9236_().f_46441_)).ifPresent(entityTypeHolder -> this.summonCreature((EntityType)entityTypeHolder.get()));
        }
    }

    public void m_7334_(Entity pEntity) {
        if (pEntity instanceof Boat) {
            if (pEntity.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(pEntity);
            }
        } else if (pEntity.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(pEntity);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_() && this.getClosingTime() == 0) {
            boolean flag;
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            boolean bl = flag = pSource.m_7639_() instanceof Player && ((Player)pSource.m_7639_()).m_150110_().f_35937_;
            if (flag) {
                this.closeFracture();
            }
            return false;
        }
        return false;
    }

    public void summonCreature(EntityType<?> ritualEntity) {
        this.setSummoningTime(80);
        this.entityType = ritualEntity;
    }

    public void spawnCreature() {
        if (this.entityType == null) {
            this.entityType = (EntityType)MMEntities.CHUD.get();
        }
        this.entityType.m_262496_((ServerLevel)this.m_9236_(), new BlockPos(this.m_20183_().m_123341_() + (this.isNatural() ? this.m_217043_().m_188503_(3) : 0), this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_() + (this.isNatural() ? this.m_217043_().m_188503_(3) : 0)), MobSpawnType.TRIGGERED);
        this.m_9236_().m_142346_(null, GameEvent.f_157810_, this.m_20183_());
    }

    public void closeFracture() {
        this.setClosingTime(20);
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public boolean m_271807_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected boolean m_8028_() {
        return !this.isNatural();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return this.isNatural();
    }
}

