/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.misc;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.fluids.FluidType;
import net.voidarkana.marvelous_menagerie.client.particles.MMParticles;
import net.voidarkana.marvelous_menagerie.common.entity.misc.Fracture;
import org.jetbrains.annotations.Nullable;

public class RiftEntity
extends Monster {
    private static final Predicate<LivingEntity> PLAYER = entity -> entity instanceof Player;
    static final TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(PLAYER);
    private static final EntityDataAccessor<Boolean> IS_NATURAL = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public RiftEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_NATURAL, (Object)true);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsNatural", this.isNatural());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsNatural(pCompound.m_128471_("IsNatural"));
    }

    public boolean isNatural() {
        return (Boolean)this.f_19804_.m_135370_(IS_NATURAL);
    }

    public void setIsNatural(boolean isNatural) {
        this.f_19804_.m_135381_(IS_NATURAL, (Object)isNatural);
    }

    public void m_8119_() {
        super.m_8119_();
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), p_149015_ -> targetingConditions.m_26885_((LivingEntity)this, p_149015_));
        if (this.m_217043_().m_188503_(4) == 0) {
            int xSpeed = this.m_217043_().m_216339_(-2, 3);
            int ySpeed = this.m_217043_().m_216339_(-2, 3);
            int zSpeed = this.m_217043_().m_216339_(-2, 3);
            this.m_9236_().m_7107_((ParticleOptions)MMParticles.TIME_SHARD.get(), this.m_20182_().m_7096_() + (double)xSpeed, this.m_20182_().m_7098_() + (double)ySpeed + 0.25, this.m_20182_().m_7094_() + (double)zSpeed, (double)(-xSpeed), (double)(-ySpeed), (double)(-zSpeed));
        }
        if (!list.isEmpty()) {
            this.createFracture();
        }
    }

    private void createFracture() {
        Level $$1 = this.m_9236_();
        if ($$1 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)$$1;
            Fracture fracture = new Fracture((Level)serverlevel, this.m_20182_().m_7096_(), this.m_20182_().m_7098_() - 0.25, this.m_20182_().m_7094_());
            fracture.setIsNatural(true);
            serverlevel.m_7967_((Entity)fracture);
            this.m_146870_();
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.NATURAL) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
        }
        if (pReason == MobSpawnType.STRUCTURE) {
            this.setIsNatural(false);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public boolean m_271807_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public static boolean checkRiftSpawnRules(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && RiftEntity.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && RiftEntity.checkRiftSpawn(pType, (LevelAccessor)pLevel, pSpawnType, pPos, pRandom);
    }

    public static boolean checkRiftSpawn(EntityType<? extends Mob> pType, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos = pPos.m_7495_();
        return pSpawnType == MobSpawnType.SPAWNER || pLevel.m_8055_(blockpos).m_60643_((BlockGetter)pLevel, blockpos, pType) && pPos.m_123342_() > 62;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return this.isNatural();
    }
}

