/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.worldgen;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.voidarkana.marvelous_menagerie.common.block.MMBlocks;
import net.voidarkana.marvelous_menagerie.common.worldgen.features.CalamitesFeature;
import net.voidarkana.marvelous_menagerie.common.worldgen.features.HugePrototaxitesFeature;
import net.voidarkana.marvelous_menagerie.common.worldgen.tree.custom.HugeSigillariaFoliagePlacer;
import net.voidarkana.marvelous_menagerie.common.worldgen.tree.custom.HugeSigillariaTrunkPlacer;
import net.voidarkana.marvelous_menagerie.common.worldgen.tree.custom.SigillariaFoliagePlacer;
import net.voidarkana.marvelous_menagerie.common.worldgen.tree.custom.SigillariaTrunkPlacer;
import net.voidarkana.marvelous_menagerie.common.worldgen.util.CalamitesFeatureConfiguration;
import net.voidarkana.marvelous_menagerie.common.worldgen.util.HugePrototaxitesFeatureConfiguration;

public class ModConfiguredFeatures {
    public static final DeferredRegister<Feature<?>> MOD_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"marvelous_menagerie");
    public static final RegistryObject<Feature<HugePrototaxitesFeatureConfiguration>> PROTOTAXITES_FEATURE = ModConfiguredFeatures.register_feature("prototaxites_feature", () -> new HugePrototaxitesFeature(HugePrototaxitesFeatureConfiguration.CODEC));
    public static final RegistryObject<Feature<CalamitesFeatureConfiguration>> CALAMITES_FEATURE = ModConfiguredFeatures.register_feature("calamites_feature", () -> new CalamitesFeature(CalamitesFeatureConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> SIGILLARIA_KEY = ModConfiguredFeatures.registerKey("sigillaria");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SIGILLARIA_HUGE = ModConfiguredFeatures.registerKey("sigillaria_huge");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PROTOTAXITES_KEY = ModConfiguredFeatures.registerKey("prototaxites");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CALAMITES_KEY = ModConfiguredFeatures.registerKey("calamites");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHALE_KEY = ModConfiguredFeatures.registerKey("shale");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHALE_FOSSIL_KEY = ModConfiguredFeatures.registerKey("shale_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILTSTONE_KEY = ModConfiguredFeatures.registerKey("siltstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILTSTONE_FOSSIL_KEY = ModConfiguredFeatures.registerKey("siltstone_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GABBRO_KEY = ModConfiguredFeatures.registerKey("gabbro");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GABBRO_FOSSIL_KEY = ModConfiguredFeatures.registerKey("gabbro_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUDSTONE_KEY = ModConfiguredFeatures.registerKey("mudstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUDSTONE_FOSSIL_KEY = ModConfiguredFeatures.registerKey("mudstone_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIMESTONE_KEY = ModConfiguredFeatures.registerKey("limestone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIMESTONE_FOSSIL_KEY = ModConfiguredFeatures.registerKey("limestone_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHALK_KEY = ModConfiguredFeatures.registerKey("chalk");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHALK_FOSSIL_KEY = ModConfiguredFeatures.registerKey("chalk_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRECCIA_KEY = ModConfiguredFeatures.registerKey("breccia");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRECCIA_FOSSIL_KEY = ModConfiguredFeatures.registerKey("breccia_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DIATOMITE_KEY = ModConfiguredFeatures.registerKey("diatomite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DIATOMITE_FOSSIL_KEY = ModConfiguredFeatures.registerKey("diatomite_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EXTRA_PERMAFROST_KEY = ModConfiguredFeatures.registerKey("extra_permafrost");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_FOSSIL_KEY = ModConfiguredFeatures.registerKey("permafrost_fossil");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.f_144267_);
        TagMatchTest dirtReplaceables = new TagMatchTest(BlockTags.f_144274_);
        TagMatchTest iceReplaceables = new TagMatchTest(BlockTags.f_13047_);
        BlockMatchTest shaleReplaceables = new BlockMatchTest((Block)MMBlocks.SHALE.get());
        BlockMatchTest siltstoneReplaceables = new BlockMatchTest((Block)MMBlocks.SILTSTONE.get());
        BlockMatchTest gabbroReplaceables = new BlockMatchTest((Block)MMBlocks.GABBRO.get());
        BlockMatchTest mudstoneReplaceables = new BlockMatchTest((Block)MMBlocks.MUDSTONE.get());
        BlockMatchTest limestoneReplaceables = new BlockMatchTest((Block)MMBlocks.LIMESTONE.get());
        BlockMatchTest chalkReplaceables = new BlockMatchTest((Block)MMBlocks.CHALK.get());
        BlockMatchTest brecciaReplaceables = new BlockMatchTest((Block)MMBlocks.BRECCIA.get());
        BlockMatchTest diatomiteReplaceables = new BlockMatchTest((Block)MMBlocks.DIATOMITE.get());
        BlockMatchTest permafrostReplaceables = new BlockMatchTest((Block)MMBlocks.PERMAFROST.get());
        ModConfiguredFeatures.register(context, SIGILLARIA_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MMBlocks.SIGILLARIA_STEM.get())), (TrunkPlacer)new SigillariaTrunkPlacer(7, 1, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MMBlocks.SIGILLARIA_LEAVES.get())), (FoliagePlacer)new SigillariaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_());
        ModConfiguredFeatures.register(context, SIGILLARIA_HUGE, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MMBlocks.SIGILLARIA_STEM.get())), (TrunkPlacer)new HugeSigillariaTrunkPlacer(20, 1, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MMBlocks.SIGILLARIA_LEAVES.get())), (FoliagePlacer)new HugeSigillariaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 5), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_());
        ModConfiguredFeatures.register(context, PROTOTAXITES_KEY, (Feature)PROTOTAXITES_FEATURE.get(), new HugePrototaxitesFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MMBlocks.PROTOTAXITES_BLOCK.get())), 3));
        ModConfiguredFeatures.register(context, CALAMITES_KEY, (Feature)CALAMITES_FEATURE.get(), new CalamitesFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MMBlocks.CALAMITES_LOG.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MMBlocks.CALAMITES_BRANCH.get())), 12, 15));
        ModConfiguredFeatures.register(context, SHALE_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)deepslateReplaceables, ((Block)MMBlocks.SHALE.get()).m_49966_(), 64));
        ModConfiguredFeatures.register(context, SHALE_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)shaleReplaceables, ((Block)MMBlocks.SHALE_FOSSIL_BLOCK.get()).m_49966_(), 15));
        ModConfiguredFeatures.register(context, SILTSTONE_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)deepslateReplaceables, ((Block)MMBlocks.SILTSTONE.get()).m_49966_(), 64));
        ModConfiguredFeatures.register(context, SILTSTONE_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)siltstoneReplaceables, ((Block)MMBlocks.SILTSTONE_FOSSIL_BLOCK.get()).m_49966_(), 15));
        ModConfiguredFeatures.register(context, GABBRO_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)deepslateReplaceables, ((Block)MMBlocks.GABBRO.get()).m_49966_(), 64));
        ModConfiguredFeatures.register(context, GABBRO_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)gabbroReplaceables, ((Block)MMBlocks.GABBRO_FOSSIL_BLOCK.get()).m_49966_(), 15));
        ModConfiguredFeatures.register(context, MUDSTONE_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)MMBlocks.MUDSTONE.get()).m_49966_(), 64));
        ModConfiguredFeatures.register(context, MUDSTONE_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)mudstoneReplaceables, ((Block)MMBlocks.MUDSTONE_FOSSIL_BLOCK.get()).m_49966_(), 15));
        ModConfiguredFeatures.register(context, LIMESTONE_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)MMBlocks.LIMESTONE.get()).m_49966_(), 64));
        ModConfiguredFeatures.register(context, LIMESTONE_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)limestoneReplaceables, ((Block)MMBlocks.LIMESTONE_FOSSIL_BLOCK.get()).m_49966_(), 15));
        ModConfiguredFeatures.register(context, CHALK_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)MMBlocks.CHALK.get()).m_49966_(), 64));
        ModConfiguredFeatures.register(context, CHALK_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)chalkReplaceables, ((Block)MMBlocks.CHALK_FOSSIL_BLOCK.get()).m_49966_(), 15));
        ModConfiguredFeatures.register(context, BRECCIA_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)MMBlocks.BRECCIA.get()).m_49966_(), 64));
        ModConfiguredFeatures.register(context, BRECCIA_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)brecciaReplaceables, ((Block)MMBlocks.BRECCIA_FOSSIL_BLOCK.get()).m_49966_(), 15));
        ModConfiguredFeatures.register(context, DIATOMITE_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)MMBlocks.DIATOMITE.get()).m_49966_(), 64));
        ModConfiguredFeatures.register(context, DIATOMITE_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)diatomiteReplaceables, ((Block)MMBlocks.DIATOMITE_FOSSIL_BLOCK.get()).m_49966_(), 15));
        List<OreConfiguration.TargetBlockState> extraPermafrost = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceables, (BlockState)((Block)MMBlocks.PERMAFROST.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)dirtReplaceables, (BlockState)((Block)MMBlocks.PERMAFROST.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)iceReplaceables, (BlockState)((Block)MMBlocks.PERMAFROST.get()).m_49966_()));
        ModConfiguredFeatures.register(context, EXTRA_PERMAFROST_KEY, Feature.f_65731_, new OreConfiguration(extraPermafrost, 64));
        ModConfiguredFeatures.register(context, PERMAFROST_FOSSIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)permafrostReplaceables, ((Block)MMBlocks.PERMAFROST_FOSSIL_BLOCK.get()).m_49966_(), 15));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("marvelous_menagerie", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    public static <T extends FeatureConfiguration> RegistryObject<Feature<T>> register_feature(String name, Supplier<Feature<T>> featureSupplier) {
        return MOD_FEATURES.register(name, featureSupplier);
    }

    public static void register(IEventBus eventBus) {
        MOD_FEATURES.register(eventBus);
    }
}

