/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.worldgen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.voidarkana.marvelous_menagerie.common.block.custom.plant.CalamitesBranchBlock;
import net.voidarkana.marvelous_menagerie.common.worldgen.util.CalamitesFeatureConfiguration;

public class CalamitesFeature
extends Feature<CalamitesFeatureConfiguration> {
    public CalamitesFeature(Codec<CalamitesFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    protected int getCalamitesHeight(RandomSource pRandom, CalamitesFeatureConfiguration pConfig) {
        return pRandom.m_216339_(pConfig.minHeight, pConfig.maxHeight + 1);
    }

    protected boolean isValidPosition(LevelAccessor pLevel, BlockPos pPos, int pMaxHeight, BlockPos.MutableBlockPos pMutablePos, CalamitesFeatureConfiguration pConfig) {
        int i = pPos.m_123342_();
        return i >= pLevel.m_141937_() + 1 && i + pMaxHeight + 1 < pLevel.m_151558_();
    }

    public boolean m_142674_(FeaturePlaceContext<CalamitesFeatureConfiguration> pContext) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos;
        CalamitesFeatureConfiguration calamitesFeatureConfiguration;
        RandomSource randomsource;
        int i;
        BlockPos blockpos;
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        if (!this.isValidPosition((LevelAccessor)worldgenlevel, blockpos = pContext.m_159777_(), i = this.getCalamitesHeight(randomsource = pContext.m_225041_(), calamitesFeatureConfiguration = (CalamitesFeatureConfiguration)pContext.m_159778_()), blockpos$mutableblockpos = new BlockPos.MutableBlockPos(), calamitesFeatureConfiguration)) {
            return false;
        }
        this.placeBranches((LevelAccessor)worldgenlevel, randomsource, blockpos, calamitesFeatureConfiguration, i, blockpos$mutableblockpos, pContext);
        this.placeStem((LevelAccessor)worldgenlevel, randomsource, blockpos, calamitesFeatureConfiguration, i, blockpos$mutableblockpos, pContext);
        return true;
    }

    protected void placeBranches(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos, CalamitesFeatureConfiguration pConfig, int pMaxHeight, BlockPos.MutableBlockPos pMutablePos, FeaturePlaceContext<CalamitesFeatureConfiguration> pContext) {
        int midSectionEnd = pMaxHeight - 3;
        int midSectionLength = pMaxHeight - 6;
        int midSectionPortionSmall = (int)Math.floor((double)midSectionLength / 3.0);
        int midSectionPortionBigStart = 4 + midSectionPortionSmall;
        int midSectionPortionBigEnd = pMaxHeight - 3 - midSectionPortionSmall;
        for (int currentHeight = 1; currentHeight <= pMaxHeight; ++currentHeight) {
            BlockState blockstate;
            int z;
            int x;
            if (currentHeight <= 2 || currentHeight == pMaxHeight) continue;
            int radiusDiagonal = currentHeight == 3 || currentHeight == pMaxHeight - 2 ? 1 : (currentHeight == pMaxHeight - 1 ? 0 : (currentHeight >= midSectionPortionBigStart && currentHeight <= midSectionPortionBigEnd ? 3 : 2));
            int radius = radiusDiagonal + 1;
            for (x = -radius; x <= radius; ++x) {
                for (z = -radius; z <= radius; ++z) {
                    if ((x != 0 || z == 0) && (z != 0 || x == 0)) continue;
                    pMutablePos.m_122154_((Vec3i)pPos, x, currentHeight - 1, z);
                    blockstate = pConfig.branchProvider.m_213972_(pRandom, pPos);
                    if (x == 0) {
                        this.m_5974_((LevelWriter)pLevel, (BlockPos)pMutablePos, blockstate);
                    }
                    if (z != 0) continue;
                    this.m_5974_((LevelWriter)pLevel, (BlockPos)pMutablePos, (BlockState)blockstate.m_61124_((Property)CalamitesBranchBlock.ROTATION_8, (Comparable)Integer.valueOf(2)));
                }
            }
            for (x = -radiusDiagonal; x <= radiusDiagonal; ++x) {
                for (z = -radiusDiagonal; z <= radiusDiagonal; ++z) {
                    if (Math.abs(x) != Math.abs(z) || z == 0) continue;
                    pMutablePos.m_122154_((Vec3i)pPos, x, currentHeight - 1, z);
                    blockstate = pConfig.branchProvider.m_213972_(pRandom, pPos);
                    if (x < 0 && z < 0 || x > 0 && z > 0) {
                        this.m_5974_((LevelWriter)pLevel, (BlockPos)pMutablePos, (BlockState)blockstate.m_61124_((Property)CalamitesBranchBlock.ROTATION_8, (Comparable)Integer.valueOf(7)));
                    }
                    if ((x >= 0 || z <= 0) && (x <= 0 || z >= 0)) continue;
                    this.m_5974_((LevelWriter)pLevel, (BlockPos)pMutablePos, (BlockState)blockstate.m_61124_((Property)CalamitesBranchBlock.ROTATION_8, (Comparable)Integer.valueOf(1)));
                }
            }
        }
    }

    protected void placeStem(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos, CalamitesFeatureConfiguration pConfig, int pMaxHeight, BlockPos.MutableBlockPos pMutablePos, FeaturePlaceContext<CalamitesFeatureConfiguration> pContext) {
        for (int currentHeight = 1; currentHeight <= pMaxHeight; ++currentHeight) {
            pMutablePos.m_122154_((Vec3i)pPos, 0, currentHeight - 1, 0);
            BlockState blockstate = pConfig.stemProvider.m_213972_(pRandom, pPos);
            this.m_5974_((LevelWriter)pLevel, (BlockPos)pMutablePos, blockstate);
        }
    }
}

