/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.worldgen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.voidarkana.marvelous_menagerie.common.worldgen.util.HugePrototaxitesFeatureConfiguration;

public class HugePrototaxitesFeature
extends Feature<HugePrototaxitesFeatureConfiguration> {
    public HugePrototaxitesFeature(Codec<HugePrototaxitesFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    protected int getProtoHeight(RandomSource pRandom) {
        return pRandom.m_216339_(6, 10) + 2;
    }

    protected boolean isValidPosition(LevelAccessor pLevel, BlockPos pPos, int pMaxHeight, BlockPos.MutableBlockPos pMutablePos, HugePrototaxitesFeatureConfiguration pConfig) {
        int i = pPos.m_123342_();
        return i >= pLevel.m_141937_() + 1 && i + pMaxHeight + 1 < pLevel.m_151558_();
    }

    public boolean m_142674_(FeaturePlaceContext<HugePrototaxitesFeatureConfiguration> pContext) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos;
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        BlockPos blockpos = pContext.m_159777_();
        RandomSource randomsource = pContext.m_225041_();
        HugePrototaxitesFeatureConfiguration hugePrototaxitesFeatureConfiguration = (HugePrototaxitesFeatureConfiguration)pContext.m_159778_();
        int i = this.getProtoHeight(randomsource);
        if (!this.isValidPosition((LevelAccessor)worldgenlevel, blockpos, i, blockpos$mutableblockpos = new BlockPos.MutableBlockPos(), hugePrototaxitesFeatureConfiguration)) {
            return false;
        }
        this.placeStem((LevelAccessor)worldgenlevel, randomsource, blockpos, hugePrototaxitesFeatureConfiguration, i, blockpos$mutableblockpos, pContext);
        return true;
    }

    protected void placeStem(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos, HugePrototaxitesFeatureConfiguration pConfig, int pMaxHeight, BlockPos.MutableBlockPos pMutablePos, FeaturePlaceContext<HugePrototaxitesFeatureConfiguration> pContext) {
        int radius = 1;
        for (int currentHeight = 1; currentHeight <= pMaxHeight; ++currentHeight) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockState blockstate;
                    boolean flag6;
                    boolean flag = j == -radius;
                    boolean flag1 = j == radius;
                    boolean flag2 = k == -radius;
                    boolean flag3 = k == radius;
                    boolean flag4 = flag || flag1;
                    boolean flag5 = flag2 || flag3;
                    boolean bl = flag6 = j == 0 && k == 0;
                    if ((!flag4 || !flag5 && currentHeight > pMaxHeight - 6 || currentHeight <= pMaxHeight - 6) && currentHeight < pMaxHeight) {
                        pMutablePos.m_122154_((Vec3i)pPos, j, currentHeight - 1, k);
                        if (pLevel.m_8055_((BlockPos)pMutablePos).m_60804_((BlockGetter)pLevel, (BlockPos)pMutablePos)) continue;
                        blockstate = pConfig.stemProvider.m_213972_(pRandom, pPos);
                        this.m_5974_((LevelWriter)pLevel, (BlockPos)pMutablePos, blockstate);
                        if (currentHeight != 1 || !flag6) continue;
                        this.replaceGround(pContext, pPos);
                        continue;
                    }
                    pMutablePos.m_122154_((Vec3i)pPos, 0, currentHeight - 1, 0);
                    blockstate = pConfig.stemProvider.m_213972_(pRandom, pPos);
                    this.m_5974_((LevelWriter)pLevel, (BlockPos)pMutablePos, blockstate);
                }
            }
        }
    }

    public void replaceGround(FeaturePlaceContext<HugePrototaxitesFeatureConfiguration> pContext, BlockPos pos) {
        this.placeCircle(pContext, pos.m_122024_().m_122012_());
        this.placeCircle(pContext, pos.m_122030_(2).m_122012_());
        this.placeCircle(pContext, pos.m_122024_().m_122020_(2));
        this.placeCircle(pContext, pos.m_122030_(2).m_122020_(2));
        for (int j = 0; j < 5; ++j) {
            int k = pContext.m_225041_().m_188503_(64);
            int l = k % 8;
            int i1 = k / 8;
            if (l != 0 && l != 7 && i1 != 0 && i1 != 7) continue;
            this.placeCircle(pContext, pos.m_7918_(-3 + l, -1, -3 + i1));
        }
    }

    private void placeCircle(FeaturePlaceContext<HugePrototaxitesFeatureConfiguration> pContext, BlockPos pPos) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placeMyceliumAt(pContext, pPos.m_7918_(i, 0, j));
            }
        }
    }

    private void placeMyceliumAt(FeaturePlaceContext<HugePrototaxitesFeatureConfiguration> pContext, BlockPos pPos) {
        SimpleStateProvider provider = BlockStateProvider.m_191382_((Block)Blocks.f_50195_);
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pPos.m_6630_(i);
            if (Feature.m_65788_((LevelSimulatedReader)pContext.m_159774_(), (BlockPos)blockpos)) {
                this.m_5974_((LevelWriter)pContext.m_159774_(), blockpos, ForgeEventFactory.alterGround((LevelSimulatedReader)pContext.m_159774_(), (RandomSource)pContext.m_225041_(), (BlockPos)blockpos, (BlockState)provider.m_213972_(pContext.m_225041_(), pPos)));
                break;
            }
            if (!pContext.m_159774_().m_7433_(pPos, BlockBehaviour.BlockStateBase::m_60795_) && i < 0) break;
        }
    }
}

