/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.worldgen.tree.custom;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractHugeTreeGrower
extends AbstractTreeGrower {
    public boolean m_213817_(ServerLevel pLevel, ChunkGenerator pGenerator, BlockPos pPos, BlockState pState, RandomSource pRandom) {
        for (int i = 1; i >= -1; --i) {
            for (int j = 1; j >= -1; --j) {
                if (!AbstractHugeTreeGrower.isThreeByThreeSapling(pState, (BlockGetter)pLevel, pPos, i, j)) continue;
                return this.placeHumongous(pLevel, pGenerator, pPos, pState, pRandom, i, j);
            }
        }
        return super.m_213817_(pLevel, pGenerator, pPos, pState, pRandom);
    }

    @Nullable
    protected abstract ResourceKey<ConfiguredFeature<?, ?>> getConfiguredHugeFeature(RandomSource var1);

    public boolean placeHumongous(ServerLevel pLevel, ChunkGenerator pGenerator, BlockPos pPos, BlockState pState, RandomSource pRandom, int pBranchX, int pBranchY) {
        ResourceKey<ConfiguredFeature<?, ?>> resourcekey = this.getConfiguredHugeFeature(pRandom);
        if (resourcekey == null) {
            return false;
        }
        Holder holder = (Holder)pLevel.m_9598_().m_175515_(Registries.f_256911_).m_203636_(resourcekey).orElse(null);
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)pLevel, (RandomSource)pRandom, (BlockPos)pPos, (Holder)holder);
        holder = event.getFeature();
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        ConfiguredFeature configuredfeature = (ConfiguredFeature)holder.m_203334_();
        BlockState blockstate = Blocks.f_50016_.m_49966_();
        pLevel.m_7731_(pPos.m_7918_(pBranchX - 1, 0, pBranchY - 1), blockstate, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX - 1, 0, pBranchY), blockstate, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX - 1, 0, pBranchY + 1), blockstate, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX, 0, pBranchY - 1), blockstate, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX, 0, pBranchY), blockstate, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX, 0, pBranchY + 1), blockstate, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX + 1, 0, pBranchY - 1), blockstate, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX + 1, 0, pBranchY), blockstate, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX + 1, 0, pBranchY + 1), blockstate, 4);
        if (configuredfeature.m_224953_((WorldGenLevel)pLevel, pGenerator, pRandom, pPos.m_7918_(pBranchX, 0, pBranchY))) {
            return true;
        }
        pLevel.m_7731_(pPos.m_7918_(pBranchX - 1, 0, pBranchY - 1), pState, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX - 1, 0, pBranchY), pState, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX - 1, 0, pBranchY + 1), pState, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX, 0, pBranchY - 1), pState, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX, 0, pBranchY), pState, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX, 0, pBranchY + 1), pState, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX + 1, 0, pBranchY - 1), pState, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX + 1, 0, pBranchY), pState, 4);
        pLevel.m_7731_(pPos.m_7918_(pBranchX + 1, 0, pBranchY + 1), pState, 4);
        return false;
    }

    public static boolean isThreeByThreeSapling(BlockState pBlockUnder, BlockGetter pLevel, BlockPos pPos, int pXOffset, int pZOffset) {
        Block block = pBlockUnder.m_60734_();
        return pLevel.m_8055_(pPos.m_7918_(pXOffset, 0, pZOffset + 1)).m_60713_(block) && pLevel.m_8055_(pPos.m_7918_(pXOffset, 0, pZOffset)).m_60713_(block) && pLevel.m_8055_(pPos.m_7918_(pXOffset, 0, pZOffset - 1)).m_60713_(block) && pLevel.m_8055_(pPos.m_7918_(pXOffset + 1, 0, pZOffset - 1)).m_60713_(block) && pLevel.m_8055_(pPos.m_7918_(pXOffset + 1, 0, pZOffset)).m_60713_(block) && pLevel.m_8055_(pPos.m_7918_(pXOffset + 1, 0, pZOffset + 1)).m_60713_(block) && pLevel.m_8055_(pPos.m_7918_(pXOffset - 1, 0, pZOffset - 1)).m_60713_(block) && pLevel.m_8055_(pPos.m_7918_(pXOffset - 1, 0, pZOffset)).m_60713_(block) && pLevel.m_8055_(pPos.m_7918_(pXOffset - 1, 0, pZOffset + 1)).m_60713_(block);
    }
}

