/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.voidarkana.marvelous_menagerie.common.block.MMBlocks;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import net.voidarkana.marvelous_menagerie.data.manager.RitualManager;
import net.voidarkana.marvelous_menagerie.util.render.RenderUtil;

@OnlyIn(value=Dist.CLIENT)
public class RitualRecipeCategory
implements IRecipeCategory<RitualManager.RitualProcessData> {
    public static final ResourceLocation UID = new ResourceLocation("marvelous_menagerie", "summoning_ritual");
    public static final ResourceLocation TEXTURE = new ResourceLocation("marvelous_menagerie", "textures/gui/jei/summoning_ritual.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private final IDrawable goober;
    private final IDrawable sparkles;
    private final IDrawable resultArrow1;
    private final IDrawable resultArrow2;
    private final IDrawable resultArrow3;
    private final IDrawable resultArrow4;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 65);
        this.goober = guiHelper.createDrawable(TEXTURE, 0, 0, 24, 28);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MMBlocks.CHRONO_ALTAR.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.sparkles = guiHelper.createDrawable(TEXTURE, 32, 0, 48, 48);
        this.resultArrow1 = guiHelper.createDrawable(TEXTURE, 0, 32, 19, 12);
        this.resultArrow2 = guiHelper.createDrawable(TEXTURE, 0, 48, 10, 18);
        this.resultArrow3 = guiHelper.createDrawable(TEXTURE, 16, 48, 10, 18);
        this.resultArrow4 = guiHelper.createDrawable(TEXTURE, 32, 48, 19, 12);
    }

    public RecipeType<RitualManager.RitualProcessData> getRecipeType() {
        return new RecipeType(UID, RitualManager.RitualProcessData.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.marvelous_menagerie.summoning_rituals");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualManager.RitualProcessData recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 16).addIngredients(recipe.input1());
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 36).addIngredients(recipe.input2());
        builder.addSlot(RecipeIngredientRole.INPUT, 100, 36).addIngredients(recipe.input3());
        builder.addSlot(RecipeIngredientRole.INPUT, 130, 16).addIngredients(recipe.input4());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 65, 50).addItemStack(new ItemStack((ItemLike)MMItems.CHRONO_WATCH.get()))).addTooltipCallback((view, tooltip) -> tooltip.add(Component.m_237115_((String)"jei.marvelous_menagerie.chrono_watch_tooltip").m_6270_(Style.f_131099_.m_178520_(49913))));
    }

    public void draw(RitualManager.RitualProcessData recipe, IRecipeSlotsView view, GuiGraphics graphics, double mouseX, double mouseY) {
        this.slotDrawable.draw(graphics, 3, 15);
        this.slotDrawable.draw(graphics, 33, 35);
        this.slotDrawable.draw(graphics, 99, 35);
        this.slotDrawable.draw(graphics, 129, 15);
        this.goober.draw(graphics, 0, 14);
        this.goober.draw(graphics, 30, 34);
        this.goober.draw(graphics, 96, 34);
        this.goober.draw(graphics, 126, 14);
        this.resultArrow1.draw(graphics, 26, 2);
        this.resultArrow2.draw(graphics, 39, 14);
        this.resultArrow3.draw(graphics, 100, 14);
        this.resultArrow4.draw(graphics, 105, 2);
        this.sparkles.draw(graphics, 50, -3);
        Entity model = null;
        EntityType type = recipe.output();
        if (type != null) {
            model = type.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        }
        if (model != null && model instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)model;
            int scale = (double)entity.m_6972_((Pose)Pose.STANDING).f_20378_ < 0.75 && (double)entity.m_6972_((Pose)Pose.STANDING).f_20377_ < 0.75 ? 35 : (entity.m_6972_((Pose)Pose.STANDING).f_20378_ < 1.0f ? 25 : (int)Math.max(Math.max(1.0f / entity.m_6972_((Pose)Pose.STANDING).f_20378_, 1.0f) * Math.max(1.0f / entity.m_6972_((Pose)Pose.STANDING).f_20377_, 1.0f), 1.0f) * 10);
            RenderUtil.renderEntityInInventoryWithoutHeadFollowing(graphics, 73, 33, scale, (float)Math.toRadians(-75.0), (float)Math.toRadians(-45.0), entity);
        }
    }
}

