/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.data.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMBiomeTagGenerator;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMBlockStateProvider;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMBlockTagGenerator;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMEntityTagGenerator;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMItemModelProvider;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMItemTagGenerator;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMLootModifierProvider;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMLootTableProvider;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMPOITagsProvider;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.MMRecipeProvider;
import net.voidarkana.marvelous_menagerie.data.datagen.providers.ModWorldGenProvider;

@Mod.EventBusSubscriber(modid="marvelous_menagerie", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MMDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new MMRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)MMLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new MMBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MMItemModelProvider(packOutput, existingFileHelper));
        MMBlockTagGenerator blockTagGenerator = (MMBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new MMBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MMItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(true, (DataProvider)new MMEntityTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new MMBiomeTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MMPOITagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MMLootModifierProvider(packOutput));
    }
}

