/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.data.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.voidarkana.marvelous_menagerie.data.manager.codec.FossilCleaningRecipeCodec;
import net.voidarkana.marvelous_menagerie.data.manager.codec.WeightedItemCodec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FossilCleaningManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = new GsonBuilder().create();
    public static final Logger LOGGER = LogManager.getLogger();
    protected static Map<Item, List<WeightedItemCodec>> recipeList = new HashMap<Item, List<WeightedItemCodec>>();
    protected static Map<ResourceLocation, FossilCleaningRecipeCodec> recipeListRl = new HashMap<ResourceLocation, FossilCleaningRecipeCodec>();
    private final String folderName;

    public FossilCleaningManager() {
        this(GSON_INSTANCE, "gameplay/fossil_cleaning");
    }

    public FossilCleaningManager(Gson pGson, String pDirectory) {
        super(pGson, pDirectory);
        this.folderName = pDirectory;
    }

    public static Map<Item, List<WeightedItemCodec>> getRecipes() {
        return recipeList;
    }

    public static void setRecipeList(Map<Item, List<WeightedItemCodec>> recipeList) {
        FossilCleaningManager.recipeList = recipeList;
    }

    public static List<WeightedItemCodec> getItems(Item item) {
        return recipeList.getOrDefault(item, Collections.emptyList());
    }

    public static boolean containsRecipe(Item item) {
        return recipeList.containsKey(item);
    }

    public static ItemStack getRandomItemStack(Item input, Level level) {
        if (null == level) {
            return ItemStack.f_41583_;
        }
        Item outputItem = null;
        List<WeightedItemCodec> outputs = recipeList.get(input);
        int totalWeight = 0;
        for (WeightedItemCodec itemWeightedPair : outputs) {
            totalWeight += itemWeightedPair.getWeight();
        }
        int randomNr = level.f_46441_.m_188503_(totalWeight);
        int cumulativeWeight = 0;
        for (WeightedItemCodec itemWeightedPair : outputs) {
            if (randomNr >= (cumulativeWeight += itemWeightedPair.getWeight())) continue;
            outputItem = itemWeightedPair.getItem();
            break;
        }
        return new ItemStack(outputItem);
    }

    public static void populateRecipeMap(Level level) {
        recipeList.clear();
        HashMap weightedPairsTemp = new HashMap();
        for (ResourceLocation resourceLocation : recipeListRl.keySet()) {
            FossilCleaningRecipeCodec analyzerRecipeCodec = recipeListRl.get(resourceLocation);
            List<ResourceLocation> tagsRL = analyzerRecipeCodec.getInputItemTags();
            List<ResourceLocation> itemsRL = analyzerRecipeCodec.getInputItems();
            for (ResourceLocation tag : tagsRL) {
                TagKey itemTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag);
                level.m_9598_().m_6632_(Registries.f_256913_).ifPresent(reg -> {
                    Iterable itemHolder = reg.m_206058_(itemTagKey);
                    for (Holder tempItemHolder : itemHolder) {
                        Item item = (Item)tempItemHolder.get();
                        if (weightedPairsTemp.containsKey(item)) {
                            LOGGER.warn("Item {} for resourceLocation {} already has items assigned, adding more", (Object)item, (Object)resourceLocation);
                        }
                        List weightedPairsList = weightedPairsTemp.getOrDefault(item, new ArrayList());
                        weightedPairsList.addAll(analyzerRecipeCodec.getItemWeightedPairs());
                        weightedPairsTemp.put(item, weightedPairsList);
                    }
                    if (!itemHolder.iterator().hasNext()) {
                        LOGGER.error("Tag for {} does not have any items!", (Object)itemTagKey);
                        LOGGER.error("Analyzer recipe for {} might not have any items assigned, or it uses items from a mod, but the mod isn't installed!", (Object)resourceLocation);
                    }
                });
            }
            for (ResourceLocation items : itemsRL) {
                level.m_9598_().m_6632_(Registries.f_256913_).ifPresent(reg -> {
                    Item item = (Item)reg.m_7745_(items);
                    if (item == null) {
                        LOGGER.error("Item {} does not exist, currently parsing through {}!", (Object)items, (Object)resourceLocation);
                        LOGGER.error("Recipe for {} might not have any items assigned, or it uses items from a mod, but the mod isn't installed!", (Object)resourceLocation);
                        return;
                    }
                    if (weightedPairsTemp.containsKey(item)) {
                        LOGGER.warn("Item {} for resourceLocation {} already has items assigned, adding more", (Object)item, (Object)resourceLocation);
                    }
                    List weightedPairsList = weightedPairsTemp.getOrDefault(item, new ArrayList());
                    weightedPairsList.addAll(analyzerRecipeCodec.getItemWeightedPairs());
                    weightedPairsTemp.put(item, weightedPairsList);
                });
            }
        }
        LOGGER.info("Registered {} jsons with items!", (Object)weightedPairsTemp.keySet().size());
        recipeList.putAll(weightedPairsTemp);
        weightedPairsTemp.clear();
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        recipeList.clear();
        HashMap<ResourceLocation, FossilCleaningRecipeCodec> recipeList = new HashMap<ResourceLocation, FossilCleaningRecipeCodec>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            FossilCleaningRecipeCodec.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                FossilCleaningRecipeCodec analyzerRecipe = (FossilCleaningRecipeCodec)result.getFirst();
                recipeList.put(key, analyzerRecipe);
            }).ifRight(partial -> LOGGER.error("Failed to parse recipe JSON for {} due to: {}", (Object)this.folderName, (Object)partial.message()));
        }
        recipeListRl = recipeList;
        LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)recipeListRl.size());
    }
}

