/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.data.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.network.PacketDistributor;
import net.voidarkana.marvelous_menagerie.data.manager.codec.IndexTagsCodec;
import net.voidarkana.marvelous_menagerie.util.network.MMMessages;
import net.voidarkana.marvelous_menagerie.util.network.message.PaleonomiconIndexSyncPacket;

public class PaleonomiconIndexManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = new GsonBuilder().create();
    public static final List<EntityCodec> DATA = Lists.newArrayList();

    public PaleonomiconIndexManager() {
        super(GSON_INSTANCE, "gameplay/paleonomicon_indexes");
    }

    public void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        DATA.clear();
        jsons.forEach((resourceLocation, jsonElement) -> {
            EntityCodec entryData = (EntityCodec)EntityCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).result().orElseThrow();
            DATA.add(entryData);
        });
    }

    public void onDatapackSync(@Nullable ServerPlayer player) {
        if (DATA.isEmpty()) {
            return;
        }
        HashBiMap registryMap = HashBiMap.create();
        for (EntityCodec data : DATA) {
            ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)data.entityName);
            if (id == null) continue;
            registryMap.put((Object)id, (Object)data);
        }
        if (player == null) {
            MMMessages.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PaleonomiconIndexSyncPacket((BiMap<ResourceLocation, EntityCodec>)registryMap));
        } else {
            MMMessages.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PaleonomiconIndexSyncPacket((BiMap<ResourceLocation, EntityCodec>)registryMap));
        }
    }

    public void synchronizeRegistryForClient(BiMap<ResourceLocation, EntityCodec> newData) {
        DATA.clear();
        DATA.addAll(newData.values());
    }

    public record EntityCodec(EntityType entityName, String icon, String link, List<IndexTagsCodec> tags) {
        public static final Codec<EntityCodec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256780_.m_194605_().fieldOf("entity_name").forGetter(EntityCodec::entityName), (App)Codec.STRING.fieldOf("icon").forGetter(EntityCodec::icon), (App)Codec.STRING.fieldOf("link").forGetter(EntityCodec::link), (App)IndexTagsCodec.CODEC.listOf().fieldOf("indexes").forGetter(EntityCodec::tags)).apply((Applicative)instance, EntityCodec::new));

        public String getIcon() {
            return this.icon;
        }

        public static EntityCodec fromNetwork(FriendlyByteBuf buf) {
            EntityType entity = (EntityType)buf.m_236816_((IdMap)BuiltInRegistries.f_256780_);
            String icon = (String)buf.m_271872_((Codec)Codec.STRING);
            String link = (String)buf.m_271872_((Codec)Codec.STRING);
            List tags = (List)buf.m_271872_(IndexTagsCodec.CODEC.listOf());
            return new EntityCodec(entity, icon, link, tags);
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_236818_((IdMap)BuiltInRegistries.f_256780_, (Object)this.entityName);
            buf.m_272073_((Codec)Codec.STRING, (Object)this.icon);
            buf.m_272073_((Codec)Codec.STRING, (Object)this.link);
            buf.m_272073_(IndexTagsCodec.CODEC.listOf(), this.tags);
        }
    }
}

