/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.data.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.network.PacketDistributor;
import net.voidarkana.marvelous_menagerie.MarvelousMenagerie;
import net.voidarkana.marvelous_menagerie.util.network.MMMessages;
import net.voidarkana.marvelous_menagerie.util.network.message.SyncSummoningRituals;

public class RitualManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = new GsonBuilder().create();
    public static final List<RitualProcessData> DATA = Lists.newArrayList();

    public RitualManager() {
        super(GSON_INSTANCE, "gameplay/summoning_rituals");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        DATA.clear();
        object.forEach((resourceLocation, jsonElement) -> {
            try {
                JsonObject json = jsonElement.getAsJsonObject();
                RitualProcessData data = RitualProcessData.fromJson(json);
                DATA.add(data);
            }
            catch (Exception e) {
                MarvelousMenagerie.LOGGER.error("Failed to read Fractured recipe for resource {}", resourceLocation, (Object)e);
            }
        });
        MarvelousMenagerie.LOGGER.info("Loaded {} summoning rituals", (Object)DATA.size());
    }

    public void onDatapackSync(@Nullable ServerPlayer player) {
        if (DATA.isEmpty()) {
            return;
        }
        HashBiMap registryMap = HashBiMap.create();
        for (RitualProcessData data : DATA) {
            ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)data.output);
            if (id == null) continue;
            registryMap.put((Object)id, (Object)data);
        }
        if (player == null) {
            MMMessages.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncSummoningRituals((BiMap<ResourceLocation, RitualProcessData>)registryMap));
        } else {
            MMMessages.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncSummoningRituals((BiMap<ResourceLocation, RitualProcessData>)registryMap));
        }
    }

    public void synchronizeRegistryForClient(BiMap<ResourceLocation, RitualProcessData> newData) {
        DATA.clear();
        DATA.addAll(newData.values());
    }

    public record RitualProcessData(Ingredient input1, Ingredient input2, Ingredient input3, Ingredient input4, EntityType output) {
        public static RitualProcessData fromJson(JsonObject json) {
            Ingredient input1 = Ingredient.m_43917_((JsonElement)json.get("input1"));
            Ingredient input2 = Ingredient.m_43917_((JsonElement)json.get("input2"));
            Ingredient input3 = Ingredient.m_43917_((JsonElement)json.get("input3"));
            Ingredient input4 = Ingredient.m_43917_((JsonElement)json.get("input4"));
            EntityType output = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(json.get("output").getAsString()));
            return new RitualProcessData(input1, input2, input3, input4, output);
        }

        public static RitualProcessData fromNetwork(FriendlyByteBuf buf) {
            Ingredient input1 = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient input2 = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient input3 = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient input4 = Ingredient.m_43940_((FriendlyByteBuf)buf);
            EntityType entity = (EntityType)buf.m_271872_(BuiltInRegistries.f_256780_.m_194605_());
            return new RitualProcessData(input1, input2, input3, input4, entity);
        }

        public void toNetwork(FriendlyByteBuf buf, RitualProcessData recipe) {
            recipe.input1.m_43923_(buf);
            recipe.input2.m_43923_(buf);
            recipe.input3.m_43923_(buf);
            recipe.input4.m_43923_(buf);
            buf.m_272073_(BuiltInRegistries.f_256780_.m_194605_(), (Object)recipe.output);
        }
    }
}

