/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.voidarkana.marvelous_menagerie.common.block.custom.PaleontologyTableBlock;
import net.voidarkana.marvelous_menagerie.common.blockentity.custom.PaleontologyTableBlockEntity;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BrushItem.class})
public class BrushItemMixin
extends Item {
    @Shadow
    private static final double f_279643_ = Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0;

    public BrushItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"onUseTick"}, at={@At(value="HEAD")})
    private void brushPaleoTable(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration, CallbackInfo ci) {
        if (pRemainingUseDuration >= 0 && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            HitResult hitresult = this.calculateHitResult(pLivingEntity);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    BlockPos blockpos;
                    BlockState blockstate;
                    Block $$18;
                    boolean flag;
                    int i = this.m_8105_(pStack) - pRemainingUseDuration + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag && ($$18 = (blockstate = pLevel.m_8055_(blockpos = blockhitresult.m_82425_())).m_60734_()) instanceof PaleontologyTableBlock) {
                        PaleontologyTableBlock brushableblock = (PaleontologyTableBlock)$$18;
                        BlockEntity blockentity = pLevel.m_7702_(blockpos);
                        if (blockentity instanceof PaleontologyTableBlockEntity) {
                            boolean flag1;
                            PaleontologyTableBlockEntity brushableblockentity = (PaleontologyTableBlockEntity)pLevel.m_7702_(blockpos);
                            SoundEvent soundevent = brushableblock.getBrushSound();
                            pLevel.m_247517_(player, blockpos, soundevent, SoundSource.BLOCKS);
                            if (!pLevel.m_5776_() && (flag1 = brushableblockentity.brush(pLevel.m_46467_(), player, blockhitresult.m_82434_()))) {
                                EquipmentSlot equipmentslot = pStack.equals(player.m_6844_(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                                pStack.m_41622_(1, pLivingEntity, p_279044_ -> p_279044_.m_21166_(equipmentslot));
                            }
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void useOn(UseOnContext pContext, CallbackInfoReturnable<InteractionResult> cir) {
        Player player = pContext.m_43723_();
        if (player != null) {
            ItemStack offhand = player.m_21120_(InteractionHand.OFF_HAND);
            HitResult hitresult = this.calculateHitResult((LivingEntity)player);
            if (hitresult instanceof BlockHitResult) {
                BlockEntity blockentity;
                BlockPos blockpos;
                Level level;
                BlockState blockstate;
                Block $$18;
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (!player.m_9236_().f_46443_ && ($$18 = (blockstate = (level = player.m_9236_()).m_8055_(blockpos = blockhitresult.m_82425_())).m_60734_()) instanceof PaleontologyTableBlock && (blockentity = level.m_7702_(blockpos)) instanceof PaleontologyTableBlockEntity) {
                    PaleontologyTableBlockEntity brushableblockentity = (PaleontologyTableBlockEntity)blockentity;
                    if (!brushableblockentity.stack.m_41619_() && offhand.m_204117_(MMTags.Items.ANIMAL_FOSSILS)) {
                        cir.setReturnValue((Object)InteractionResult.FAIL);
                    }
                }
            }
        }
    }

    private HitResult calculateHitResult(LivingEntity pEntity) {
        return ProjectileUtil.m_278180_((Entity)pEntity, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), (double)f_279643_);
    }
}

