/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.util;

import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.util.lambda.Cons;
import net.voidarkana.marvelous_menagerie.util.mini2DX.compat.MathUtils;

public class Mathf {
    public static final float STARTING_ANGLE = (float)Math.PI / 180;
    static Random rand = new Random();
    public static final int lookupSize = 256;
    public static float[][] randLookup = new float[256][256];

    public static Vec3 randVec3() {
        float t = rand.nextFloat() * (float)Math.PI * 2.0f;
        float z = rand.nextFloat() * 2.0f - 1.0f;
        float s1z = org.joml.Math.sqrt((float)(1.0f - z * z));
        return new Vec3((double)(s1z * MathUtils.cos(t)), (double)(s1z * MathUtils.sin(t)), (double)z);
    }

    public static Vec2 randVec2() {
        float t = rand.nextFloat() * (float)Math.PI * 2.0f;
        return new Vec2(MathUtils.cos(t), MathUtils.sin(t));
    }

    public static Vec2 randVec2Uniform() {
        return new Vec2(rand.nextFloat(), rand.nextFloat());
    }

    public static float randFloat(float max) {
        return rand.nextFloat() * max;
    }

    public static float randInt(int exclusiveMax) {
        return rand.nextInt(exclusiveMax);
    }

    public static float randFloat(float min, float max) {
        return rand.nextFloat() * (max - min) + min;
    }

    public static void randVec3(Cons.Cons3<Float, Float, Float> cons) {
        float t = rand.nextFloat() * (float)Math.PI * 2.0f;
        float z = rand.nextFloat() * 2.0f - 1.0f;
        float s1z = org.joml.Math.sqrt((float)(1.0f - z * z));
        cons.get(Float.valueOf(s1z * MathUtils.cos(t)), Float.valueOf(s1z * MathUtils.sin(t)), Float.valueOf(z));
    }

    public static float sinDeg(float deg) {
        return Mth.m_14031_((float)(deg * ((float)Math.PI / 180)));
    }

    public static float cosDeg(float deg) {
        return Mth.m_14089_((float)(deg * ((float)Math.PI / 180)));
    }

    public static float getHorzAngle(Vec3 vec) {
        return (float)Math.toDegrees(Mth.m_14136_((double)vec.m_7094_(), (double)vec.m_7096_())) + 90.0f;
    }

    public static Vec3 relativeDirectionHorzF(Direction dir, Vec3 vec) {
        Vec3 dirvecZ = new Vec3((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_());
        Vec3 dirvecX = new Vec3((double)(-dir.m_122431_()), (double)dir.m_122430_(), (double)dir.m_122429_());
        Vec3 dirvecY = new Vec3(dirvecX.m_7096_(), dirvecX.m_7098_(), dirvecX.m_7094_());
        dirvecY.m_82537_(dirvecZ);
        dirvecX.m_82490_(vec.m_7096_());
        dirvecY.m_82490_(vec.m_7098_());
        dirvecZ.m_82490_(vec.m_7094_());
        dirvecX.m_82549_(dirvecY);
        dirvecX.m_82549_(dirvecZ);
        return dirvecX;
    }

    public static Vec3 relativeDirectionHorz(Direction dir, Vec3 vec) {
        Vec3 v = Mathf.relativeDirectionHorzF(dir, vec);
        return new Vec3(v.m_7096_(), v.m_7098_(), v.m_7094_());
    }

    public static Vec3 vec3i(Vec3 v) {
        return new Vec3(v.m_7096_(), v.m_7098_(), v.m_7094_());
    }

    public static float lerp(float t, float x, float x2) {
        return t * (x2 - x) + x;
    }

    public static float map(float r, float rmin, float rmax, float mapmin, float mapmax) {
        return mapmin + (mapmax - mapmin) * (r - rmin) / (rmax - rmin);
    }

    public static float mapClamped(float r, float rmin, float rmax, float mapmin, float mapmax) {
        return mapmin + (mapmax - mapmin) * Mth.m_14036_((float)((r - rmin) / (rmax - rmin)), (float)0.0f, (float)1.0f);
    }

    public static float catmull(float t, float x, float x2, float m1, float m2) {
        float t2 = t * t;
        float t3 = t2 * t;
        return (2.0f * t3 - 3.0f * t2 + 1.0f) * x + (t3 - 2.0f * t2 + t) * m1 + (-2.0f * t3 + 3.0f * t2) * x2 + (t3 - t2) * m2;
    }

    public static float catmullNorm(float t, float m1, float m2) {
        float t2 = t * t;
        float t3 = t2 * t;
        return (t3 - 2.0f * t2 + t) * m1 + (-2.0f * t3 + 3.0f * t2) + (t3 - t2) * m2;
    }

    public static float dst2(float x, float y) {
        return x * x + y * y;
    }

    public static float approach(float x, float target, float speed) {
        return x + (target >= x ? Math.min(speed, target - x) : -Math.min(speed, x - target));
    }

    public static float lerpTowards(float x, float target, float speed) {
        return x + (target - x) * speed;
    }

    public static float getRandFromPoint(int x, int y) {
        return randLookup[x & 0xFF][y & 0xFF];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                Mathf.randLookup[i][j] = Mathf.randFloat(1.0f);
            }
        }
    }
}

