/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.util.network.message;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.voidarkana.marvelous_menagerie.MarvelousMenagerie;
import net.voidarkana.marvelous_menagerie.common.block.custom.FossilBlock;

public class ChangeFossilMessage {
    public int success;
    public BlockPos pos;

    public ChangeFossilMessage(int pSuccess, BlockPos pPos) {
        this.success = pSuccess;
        this.pos = pPos;
    }

    public static ChangeFossilMessage read(FriendlyByteBuf buf) {
        return new ChangeFossilMessage(buf.readInt(), buf.m_130135_());
    }

    public static void write(ChangeFossilMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.success);
        buf.m_130064_(message.pos);
    }

    public static void handle(ChangeFossilMessage message, Supplier<NetworkEvent.Context> context) {
        Block block;
        Level level;
        ServerPlayer sender = context.get().getSender();
        if (context.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            level = MarvelousMenagerie.PROXY.getWorld();
        } else {
            if (sender == null) {
                return;
            }
            level = sender.m_9236_();
        }
        if (level != null && level.m_46805_(message.pos) && (block = level.m_8055_(message.pos).m_60734_()) instanceof FossilBlock) {
            FossilBlock fossil = (FossilBlock)block;
            BlockState state = level.m_8055_(message.pos);
            fossil.destroyOriginalWithSuccessLevel(level, message.success, message.pos);
            level.m_7260_(message.pos, state, state, 3);
        }
    }
}

