/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.util.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class RenderUtil {
    public static final Set<UUID> hiddenEntities = Collections.synchronizedSet(new HashSet());

    public static <T extends Entity> void renderEntity(T pEntity, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer renderer = entityRenderDispatcher.m_114382_(pEntity);
        try {
            renderer.m_7392_(pEntity, 0.0f, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        }
        catch (Throwable throwable) {
            throw new ReportedException(CrashReport.m_127521_((Throwable)throwable, (String)"Error rendering entity"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends Entity> boolean shouldSkipRendering(boolean pFirstPerson, T pEntity) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        boolean isFirstPerson = Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
        return pFirstPerson ? isFirstPerson : !isFirstPerson && pEntity == localPlayer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends Entity> EntityRenderer<? super T> getEntityRenderer(@Nullable T pEntity) {
        if (pEntity == null) {
            return null;
        }
        return Minecraft.m_91087_().m_91290_().m_114382_(pEntity);
    }

    public static void renderEntityInInventoryWithoutHeadFollowing(GuiGraphics pGuiGraphics, int pX, int pY, int pScale, float angleXComponent, float angleYComponent, LivingEntity pEntity) {
        float f = angleXComponent;
        float f1 = angleYComponent;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = pEntity.f_20883_;
        float f3 = pEntity.m_146908_();
        float f4 = pEntity.m_146909_();
        float f5 = pEntity.f_20886_;
        float f6 = pEntity.f_20885_;
        pEntity.f_20883_ = 180.0f + f * 20.0f;
        pEntity.m_146922_(180.0f + f * 40.0f);
        pEntity.m_146926_(0.0f);
        pEntity.f_20885_ = (float)(180.0 + Math.toRadians(-45.0) * 40.0);
        pEntity.f_20886_ = (float)(180.0 + Math.toRadians(-45.0) * 40.0);
        InventoryScreen.m_280432_((GuiGraphics)pGuiGraphics, (int)pX, (int)pY, (int)pScale, (Quaternionf)quaternionf, (Quaternionf)quaternionf1, (LivingEntity)pEntity);
        pEntity.f_20883_ = f2;
        pEntity.m_146922_(f3);
        pEntity.m_146926_(f4);
        pEntity.f_20886_ = f5;
        pEntity.f_20885_ = f6;
    }
}

