/*
 * Decompiled with CFR 0.152.
 */
package com.drogamleczna.industrialdeco.block.custom;

import com.drogamleczna.industrialdeco.entity.ModEntities;
import com.drogamleczna.industrialdeco.entity.Seat;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChairBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape SHAPE_N;
    public static final VoxelShape SHAPE_S;
    public static final VoxelShape SHAPE_E;
    public static final VoxelShape SHAPE_W;
    public static final VoxelShape SHAPE_ARM_N;
    public static final VoxelShape SHAPE_ARM_S;
    public static final VoxelShape SHAPE_ARM_E;
    public static final VoxelShape SHAPE_ARM_W;
    public static final VoxelShape SHAPE_BACK_N;
    public static final VoxelShape SHAPE_BACK_S;
    public static final VoxelShape SHAPE_BACK_E;
    public static final VoxelShape SHAPE_BACK_W;
    public static final VoxelShape BASE;

    public ChairBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    @Nullable
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        if (direction == Direction.EAST) {
            return SHAPE_E;
        }
        if (direction == Direction.WEST) {
            return SHAPE_W;
        }
        if (direction == Direction.SOUTH) {
            return SHAPE_S;
        }
        return SHAPE_N;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (Seat.sit(ModEntities.SEAT.get(), player, pos, 0.25, ((Direction)state.getValue((Property)DIRECTION)).getOpposite())) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    static {
        BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        SHAPE_ARM_E = Block.box((double)14.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        SHAPE_ARM_W = Block.box((double)0.0, (double)8.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
        SHAPE_ARM_N = Block.box((double)0.0, (double)8.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0);
        SHAPE_ARM_S = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
        SHAPE_BACK_N = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        SHAPE_BACK_S = Block.box((double)0.0, (double)8.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        SHAPE_BACK_E = Block.box((double)14.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        SHAPE_BACK_W = Block.box((double)0.0, (double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        SHAPE_N = Shapes.or((VoxelShape)Shapes.or((VoxelShape)BASE, (VoxelShape)SHAPE_BACK_N), (VoxelShape)Shapes.or((VoxelShape)SHAPE_ARM_W, (VoxelShape)SHAPE_ARM_E));
        SHAPE_S = Shapes.or((VoxelShape)Shapes.or((VoxelShape)BASE, (VoxelShape)SHAPE_BACK_S), (VoxelShape)Shapes.or((VoxelShape)SHAPE_ARM_W, (VoxelShape)SHAPE_ARM_E));
        SHAPE_W = Shapes.or((VoxelShape)Shapes.or((VoxelShape)BASE, (VoxelShape)SHAPE_BACK_W), (VoxelShape)Shapes.or((VoxelShape)SHAPE_ARM_N, (VoxelShape)SHAPE_ARM_S));
        SHAPE_E = Shapes.or((VoxelShape)Shapes.or((VoxelShape)BASE, (VoxelShape)SHAPE_BACK_E), (VoxelShape)Shapes.or((VoxelShape)SHAPE_ARM_N, (VoxelShape)SHAPE_ARM_S));
    }
}

