/*
 * Decompiled with CFR 0.152.
 */
package com.drogamleczna.industrialdeco.block.custom;

import com.drogamleczna.industrialdeco.IndustrialDeco;
import com.drogamleczna.industrialdeco.block.custom.PoleBlock;
import com.drogamleczna.industrialdeco.block.custom.util.CrossbuckType;
import com.drogamleczna.industrialdeco.block.custom.util.CrossbuckTypeProperty;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CrossbuckBlock
extends PoleBlock {
    public static final CrossbuckTypeProperty CTYPE = CrossbuckTypeProperty.create("crossbuck_type", CrossbuckType.CANADA, CrossbuckType.POLAND, CrossbuckType.POLAND_MULTITRACK, CrossbuckType.SWEDEN, CrossbuckType.SWEDEN_MULTITRACK, CrossbuckType.BELGIUM, CrossbuckType.BELGIUM_MULTITRACK, CrossbuckType.EUROPE, CrossbuckType.EUROPE_MULTITRACK, CrossbuckType.JAPAN);

    public CrossbuckBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.POLAND)));
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        pLevel.updateNeighborsAt(pPos, (Block)this);
        if (pPlayer.getMainHandItem().is(Items.STICK)) {
            this.changeType(pState, pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        if (pPlayer.getMainHandItem().is(IndustrialDeco.WRENCH_TAG)) {
            this.changeType(pState, pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CTYPE});
    }

    public void changeType(BlockState pState, Level pLevel, BlockPos pPos) {
        switch ((CrossbuckType)((Object)pState.getValue((Property)CTYPE))) {
            case POLAND: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.POLAND_MULTITRACK)), 0);
                break;
            }
            case POLAND_MULTITRACK: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.SWEDEN)), 0);
                break;
            }
            case SWEDEN: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.SWEDEN_MULTITRACK)), 0);
                break;
            }
            case SWEDEN_MULTITRACK: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.BELGIUM)), 0);
                break;
            }
            case BELGIUM: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.BELGIUM_MULTITRACK)), 0);
                break;
            }
            case BELGIUM_MULTITRACK: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.EUROPE)), 0);
                break;
            }
            case EUROPE: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.EUROPE_MULTITRACK)), 0);
                break;
            }
            case EUROPE_MULTITRACK: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.CANADA)), 0);
                break;
            }
            case CANADA: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.JAPAN)), 0);
                break;
            }
            case JAPAN: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CTYPE, (Comparable)((Object)CrossbuckType.POLAND)), 0);
            }
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }
}

