/*
 * Decompiled with CFR 0.152.
 */
package com.drogamleczna.industrialdeco.block.custom;

import com.drogamleczna.industrialdeco.IndustrialDeco;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoubleCurvedPoleBlock
extends HorizontalDirectionalBlock {
    public static final VoxelShape SHAPE_N;
    public static final VoxelShape SHAPE_S;
    public static final VoxelShape SHAPE_E;
    public static final VoxelShape SHAPE_W;
    public static final VoxelShape SHAPE_ARM_N;
    public static final VoxelShape SHAPE_ARM_S;
    public static final VoxelShape SHAPE_ARM_E;
    public static final VoxelShape SHAPE_ARM_W;
    public static final VoxelShape BASE;

    public DoubleCurvedPoleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    @Nullable
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        if (direction == Direction.EAST) {
            return SHAPE_E;
        }
        if (direction == Direction.WEST) {
            return SHAPE_W;
        }
        if (direction == Direction.SOUTH) {
            return SHAPE_S;
        }
        return SHAPE_N;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        pLevel.updateNeighborsAt(pPos, (Block)this);
        if (pPlayer.getMainHandItem().is(Items.STICK)) {
            this.changeType(pState, pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        if (pPlayer.getMainHandItem().is(IndustrialDeco.WRENCH_TAG)) {
            this.changeType(pState, pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void changeType(BlockState pState, Level pLevel, BlockPos pPos) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)Direction.EAST), 0);
                break;
            }
            case EAST: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)Direction.WEST), 0);
                break;
            }
            case WEST: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)Direction.SOUTH), 0);
                break;
            }
            case SOUTH: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)Direction.NORTH), 0);
            }
        }
    }

    static {
        BASE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
        SHAPE_ARM_E = Block.box((double)5.0, (double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)16.0);
        SHAPE_ARM_W = Block.box((double)5.0, (double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)16.0);
        SHAPE_ARM_N = Block.box((double)0.0, (double)11.0, (double)5.0, (double)16.0, (double)15.0, (double)11.0);
        SHAPE_ARM_S = Block.box((double)0.0, (double)11.0, (double)5.0, (double)16.0, (double)15.0, (double)11.0);
        SHAPE_N = Shapes.or((VoxelShape)BASE, (VoxelShape)SHAPE_ARM_N);
        SHAPE_S = Shapes.or((VoxelShape)BASE, (VoxelShape)SHAPE_ARM_S);
        SHAPE_E = Shapes.or((VoxelShape)BASE, (VoxelShape)SHAPE_ARM_E);
        SHAPE_W = Shapes.or((VoxelShape)BASE, (VoxelShape)SHAPE_ARM_W);
    }
}

