/*
 * Decompiled with CFR 0.152.
 */
package com.drogamleczna.industrialdeco.block.custom;

import com.drogamleczna.industrialdeco.IndustrialDeco;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetalFenceBlock
extends HorizontalDirectionalBlock {
    public static final VoxelShape SHAPE_N;
    public static final VoxelShape SHAPE_S;
    public static final VoxelShape SHAPE_E;
    public static final VoxelShape SHAPE_W;
    public static final VoxelShape SHAPE_N_C;
    public static final VoxelShape SHAPE_S_C;
    public static final VoxelShape SHAPE_E_C;
    public static final VoxelShape SHAPE_W_C;
    public static final VoxelShape SHAPE_N_P;
    public static final VoxelShape SHAPE_S_P;
    public static final VoxelShape SHAPE_E_P;
    public static final VoxelShape SHAPE_W_P;
    public static final VoxelShape SHAPE_N_P2;
    public static final VoxelShape SHAPE_S_P2;
    public static final VoxelShape SHAPE_E_P2;
    public static final VoxelShape SHAPE_W_P2;
    public static final VoxelShape LEG_NW;
    public static final VoxelShape LEG_NE;
    public static final VoxelShape LEG_SW;
    public static final VoxelShape LEG_SE;
    public static final VoxelShape MIDDLE;
    public static final BooleanProperty HAS_POLE_BASE;

    public MetalFenceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_POLE_BASE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        pLevel.updateNeighborsAt(pPos, (Block)this);
        if (pPlayer.getMainHandItem().is(Items.STICK)) {
            this.changeType(pState, pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        if (pPlayer.getMainHandItem().is(IndustrialDeco.WRENCH_TAG)) {
            this.changeType(pState, pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void changeType(BlockState pState, Level pLevel, BlockPos pPos) {
        if (((Boolean)pLevel.getBlockState(pPos).getValue((Property)HAS_POLE_BASE)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)HAS_POLE_BASE, (Comparable)Boolean.valueOf(false)), 0);
        } else {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)HAS_POLE_BASE, (Comparable)Boolean.valueOf(true)), 0);
        }
    }

    @Nullable
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Boolean hasPoleBase;
        Direction direction = (Direction)pState.getValue((Property)FACING);
        try {
            hasPoleBase = (boolean)((Boolean)pLevel.getBlockState(pPos).getValue((Property)HAS_POLE_BASE));
        }
        catch (Exception e) {
            hasPoleBase = false;
        }
        if (hasPoleBase.booleanValue()) {
            if (direction == Direction.EAST) {
                return SHAPE_E_C;
            }
            if (direction == Direction.WEST) {
                return SHAPE_W_C;
            }
            if (direction == Direction.SOUTH) {
                return SHAPE_S_C;
            }
            return SHAPE_N_C;
        }
        if (direction == Direction.EAST) {
            return SHAPE_E;
        }
        if (direction == Direction.WEST) {
            return SHAPE_W;
        }
        if (direction == Direction.SOUTH) {
            return SHAPE_S;
        }
        return SHAPE_N;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{HAS_POLE_BASE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection())).setValue((Property)HAS_POLE_BASE, (Comparable)Boolean.valueOf(false));
    }

    static {
        MIDDLE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        LEG_SE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)19.0, (double)2.0);
        LEG_NE = Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)19.0, (double)16.0);
        LEG_SW = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)19.0, (double)2.0);
        LEG_NW = Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)19.0, (double)16.0);
        SHAPE_S_P = Block.box((double)1.0, (double)17.0, (double)0.0, (double)15.0, (double)20.0, (double)2.0);
        SHAPE_N_P = Block.box((double)1.0, (double)17.0, (double)14.0, (double)15.0, (double)20.0, (double)16.0);
        SHAPE_E_P = Block.box((double)0.0, (double)17.0, (double)1.0, (double)2.0, (double)20.0, (double)15.0);
        SHAPE_W_P = Block.box((double)14.0, (double)17.0, (double)1.0, (double)16.0, (double)20.0, (double)15.0);
        SHAPE_S_P2 = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
        SHAPE_N_P2 = Block.box((double)0.0, (double)10.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0);
        SHAPE_E_P2 = Block.box((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
        SHAPE_W_P2 = Block.box((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        SHAPE_S = Shapes.or((VoxelShape)Shapes.or((VoxelShape)LEG_SW, (VoxelShape)LEG_SE), (VoxelShape)Shapes.or((VoxelShape)SHAPE_S_P, (VoxelShape)SHAPE_S_P2));
        SHAPE_N = Shapes.or((VoxelShape)Shapes.or((VoxelShape)LEG_NW, (VoxelShape)LEG_NE), (VoxelShape)Shapes.or((VoxelShape)SHAPE_N_P, (VoxelShape)SHAPE_N_P2));
        SHAPE_W = Shapes.or((VoxelShape)Shapes.or((VoxelShape)LEG_SW, (VoxelShape)LEG_NW), (VoxelShape)Shapes.or((VoxelShape)SHAPE_W_P, (VoxelShape)SHAPE_W_P2));
        SHAPE_E = Shapes.or((VoxelShape)Shapes.or((VoxelShape)LEG_SE, (VoxelShape)LEG_NE), (VoxelShape)Shapes.or((VoxelShape)SHAPE_E_P, (VoxelShape)SHAPE_E_P2));
        SHAPE_S_C = Shapes.or((VoxelShape)SHAPE_S, (VoxelShape)MIDDLE);
        SHAPE_N_C = Shapes.or((VoxelShape)SHAPE_N, (VoxelShape)MIDDLE);
        SHAPE_W_C = Shapes.or((VoxelShape)SHAPE_W, (VoxelShape)MIDDLE);
        SHAPE_E_C = Shapes.or((VoxelShape)SHAPE_E, (VoxelShape)MIDDLE);
        HAS_POLE_BASE = BooleanProperty.create((String)"has_pole_base");
    }
}

