/*
 * Decompiled with CFR 0.152.
 */
package com.drogamleczna.industrialdeco.block.custom;

import com.drogamleczna.industrialdeco.IndustrialDeco;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PalletBlock
extends HorizontalDirectionalBlock {
    public static final VoxelShape SHAPE_N;
    public static final VoxelShape SHAPE_S;
    public static final VoxelShape SHAPE_E;
    public static final VoxelShape SHAPE_W;

    public PalletBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    @Nullable
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        if (direction == Direction.EAST) {
            return SHAPE_E;
        }
        if (direction == Direction.WEST) {
            return SHAPE_W;
        }
        if (direction == Direction.SOUTH) {
            return SHAPE_S;
        }
        return SHAPE_N;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getClockWise());
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        pLevel.updateNeighborsAt(pPos, (Block)this);
        if (pPlayer.getMainHandItem().is(Items.STICK)) {
            this.changeType(pState, pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        if (pPlayer.getMainHandItem().is(IndustrialDeco.WRENCH_TAG)) {
            this.changeType(pState, pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void changeType(BlockState pState, Level pLevel, BlockPos pPos) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)Direction.EAST), 0);
                break;
            }
            case EAST: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)Direction.WEST), 0);
                break;
            }
            case WEST: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)Direction.SOUTH), 0);
                break;
            }
            case SOUTH: {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)Direction.NORTH), 0);
            }
        }
    }

    static {
        SHAPE_S = Block.box((double)0.0, (double)0.0, (double)-1.25, (double)12.8, (double)2.3, (double)17.5);
        SHAPE_N = Block.box((double)3.2, (double)0.0, (double)-1.25, (double)16.0, (double)2.3, (double)17.5);
        SHAPE_W = Block.box((double)-1.25, (double)0.0, (double)0.0, (double)17.5, (double)2.3, (double)12.8);
        SHAPE_E = Block.box((double)-1.25, (double)0.0, (double)3.2, (double)17.5, (double)2.3, (double)16.0);
    }
}

