/*
 * Decompiled with CFR 0.152.
 */
package com.drogamleczna.industrialdeco.block.custom;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WireBoxBlock
extends DirectionalBlock {
    public static final VoxelShape SHAPE_N;
    public static final VoxelShape SHAPE_S;
    public static final VoxelShape SHAPE_E;
    public static final VoxelShape SHAPE_W;
    public static final VoxelShape SHAPE_U;
    public static final VoxelShape SHAPE_D;

    public WireBoxBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return null;
    }

    @Nullable
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        if (direction == Direction.EAST) {
            return SHAPE_E;
        }
        if (direction == Direction.WEST) {
            return SHAPE_W;
        }
        if (direction == Direction.SOUTH) {
            return SHAPE_S;
        }
        if (direction == Direction.UP) {
            return SHAPE_U;
        }
        if (direction == Direction.DOWN) {
            return SHAPE_D;
        }
        return SHAPE_N;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite());
    }

    static {
        SHAPE_S = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)3.0);
        SHAPE_N = Block.box((double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0, (double)16.0);
        SHAPE_E = Block.box((double)0.0, (double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)12.0);
        SHAPE_W = Block.box((double)13.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        SHAPE_U = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0);
        SHAPE_D = Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    }
}

