/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.glitchmanv.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.glitchmanv.GlitchmanvMod;
import net.mcreator.glitchmanv.procedures.CanChangeBlocksProcedure;
import net.mcreator.glitchmanv.procedures.CanCrashProcedure;
import net.mcreator.glitchmanv.procedures.CanSpawnProcedure;
import net.mcreator.glitchmanv.procedures.ClearEntitiesProcedure;
import net.mcreator.glitchmanv.procedures.IsThereEntityProcedure;
import net.mcreator.glitchmanv.procedures.OpenConfig2Procedure;
import net.mcreator.glitchmanv.procedures.RateOfSpawnProcedure;
import net.mcreator.glitchmanv.world.inventory.ConfigMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ConfigButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ConfigButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ConfigButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ConfigButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ConfigButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ConfigMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            IsThereEntityProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            ClearEntitiesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            CanCrashProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            CanChangeBlocksProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            RateOfSpawnProcedure.execute((LevelAccessor)world, (Entity)entity, guistate);
        }
        if (buttonID == 5) {
            CanSpawnProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            OpenConfig2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GlitchmanvMod.addNetworkMessage(ConfigButtonMessage.class, ConfigButtonMessage::buffer, ConfigButtonMessage::new, ConfigButtonMessage::handler);
    }
}

