/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.glitchmanv.network;

import java.util.function.Supplier;
import net.mcreator.glitchmanv.GlitchmanvMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GlitchmanvModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GlitchmanvMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "glitchmanv_mapvars";
        public double USBZ = 0.0;
        public double USBY = 0.0;
        public double USBX = 0.0;
        public double SeenAnimationEnd = 0.0;
        public double PlayersInWorld = 0.0;
        public double EntityLimit = 0.0;
        public double Rate = 3.0;
        public boolean Finished = false;
        public boolean CanSpawn = true;
        public boolean CanCrash = true;
        public boolean CanChangeBlocks = true;
        public double sx = 0.0;
        public double sz = 0.0;
        public double sy = 0.0;
        public double SpawnX = 0.0;
        public double SpawnY = 0.0;
        public double SpawnZ = 0.0;
        public boolean CanMoveChunks = true;
        public double password = 0.0;
        public double keypad = 1.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.USBZ = nbt.m_128459_("USBZ");
            this.USBY = nbt.m_128459_("USBY");
            this.USBX = nbt.m_128459_("USBX");
            this.SeenAnimationEnd = nbt.m_128459_("SeenAnimationEnd");
            this.PlayersInWorld = nbt.m_128459_("PlayersInWorld");
            this.EntityLimit = nbt.m_128459_("EntityLimit");
            this.Rate = nbt.m_128459_("Rate");
            this.Finished = nbt.m_128471_("Finished");
            this.CanSpawn = nbt.m_128471_("CanSpawn");
            this.CanCrash = nbt.m_128471_("CanCrash");
            this.CanChangeBlocks = nbt.m_128471_("CanChangeBlocks");
            this.sx = nbt.m_128459_("sx");
            this.sz = nbt.m_128459_("sz");
            this.sy = nbt.m_128459_("sy");
            this.SpawnX = nbt.m_128459_("SpawnX");
            this.SpawnY = nbt.m_128459_("SpawnY");
            this.SpawnZ = nbt.m_128459_("SpawnZ");
            this.CanMoveChunks = nbt.m_128471_("CanMoveChunks");
            this.password = nbt.m_128459_("password");
            this.keypad = nbt.m_128459_("keypad");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("USBZ", this.USBZ);
            nbt.m_128347_("USBY", this.USBY);
            nbt.m_128347_("USBX", this.USBX);
            nbt.m_128347_("SeenAnimationEnd", this.SeenAnimationEnd);
            nbt.m_128347_("PlayersInWorld", this.PlayersInWorld);
            nbt.m_128347_("EntityLimit", this.EntityLimit);
            nbt.m_128347_("Rate", this.Rate);
            nbt.m_128379_("Finished", this.Finished);
            nbt.m_128379_("CanSpawn", this.CanSpawn);
            nbt.m_128379_("CanCrash", this.CanCrash);
            nbt.m_128379_("CanChangeBlocks", this.CanChangeBlocks);
            nbt.m_128347_("sx", this.sx);
            nbt.m_128347_("sz", this.sz);
            nbt.m_128347_("sy", this.sy);
            nbt.m_128347_("SpawnX", this.SpawnX);
            nbt.m_128347_("SpawnY", this.SpawnY);
            nbt.m_128347_("SpawnZ", this.SpawnZ);
            nbt.m_128379_("CanMoveChunks", this.CanMoveChunks);
            nbt.m_128347_("password", this.password);
            nbt.m_128347_("keypad", this.keypad);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                GlitchmanvMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "glitchmanv_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                GlitchmanvMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    GlitchmanvMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    GlitchmanvMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                GlitchmanvMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

