/*
 * Decompiled with CFR 0.152.
 */
package com.zeitaria.skygrid.loot;

import com.zeitaria.skygrid.config.SkyGridConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.event.level.ChunkEvent;

public final class SkyGridLootHandler {
    private static List<ResourceLocation> LOOT_TABLE_POOL;

    public static void onChunkLoad(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (LOOT_TABLE_POOL == null) {
            LOOT_TABLE_POOL = SkyGridLootHandler.buildLootPool();
        }
        if (LOOT_TABLE_POOL.isEmpty()) {
            return;
        }
        LevelChunk chunk = level.getChunk(event.getChunk().getPos().x, event.getChunk().getPos().z);
        for (Map.Entry entry : chunk.getBlockEntities().entrySet()) {
            int spacing;
            BlockPos pos = (BlockPos)entry.getKey();
            BlockEntity be = (BlockEntity)entry.getValue();
            if (!(be instanceof RandomizableContainerBlockEntity)) continue;
            RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)be;
            Block block = level.getBlockState(pos).getBlock();
            if (block != Blocks.CHEST && block != Blocks.BARREL || container.getLootTable() != null || !SkyGridLootHandler.isOnGrid(pos, spacing = ((Integer)SkyGridConfig.SPACING.get()).intValue()) || container.getLootTable() != null) continue;
            ResourceLocation id = LOOT_TABLE_POOL.get(level.random.nextInt(LOOT_TABLE_POOL.size()));
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id);
            container.setLootTable(key, level.random.nextLong());
            container.setChanged();
        }
    }

    private static boolean isOnGrid(BlockPos pos, int spacing) {
        return SkyGridLootHandler.mod(pos.getX(), spacing) == 0 && SkyGridLootHandler.mod(pos.getY(), spacing) == 0 && SkyGridLootHandler.mod(pos.getZ(), spacing) == 0;
    }

    private static int mod(int a, int m) {
        int r = a % m;
        return r < 0 ? r + m : r;
    }

    private static List<ResourceLocation> buildLootPool() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (String s : (List)SkyGridConfig.LOOT_TABLE_WHITELIST.get()) {
            ResourceLocation.tryParse((String)s);
            ResourceLocation id = ResourceLocation.tryParse((String)s);
            if (id == null) continue;
            list.add(id);
        }
        return list;
    }
}

