/*
 * Decompiled with CFR 0.152.
 */
package com.zeitaria.skygrid.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zeitaria.skygrid.config.SkyGridConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class SkyGridChunkGenerator
extends ChunkGenerator {
    public static final MapCodec<SkyGridChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(g -> g.biomeSource), (App)Codec.INT.optionalFieldOf("spacing", (Object)4).forGetter(g -> g.spacing)).apply((Applicative)instance, SkyGridChunkGenerator::new));
    private static final ResourceLocation WATER_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"water");
    private static final ResourceLocation AIR_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"air");
    private static final ResourceLocation CAVE_AIR_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cave_air");
    private static final ResourceLocation VOID_AIR_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"void_air");
    private final int spacing;
    private volatile List<BlockState> allBlocksNoWaterNoAir;
    private volatile List<BlockState> nonFluidBlocks;

    public SkyGridChunkGenerator(BiomeSource biomeSource, int spacingFromJson) {
        super(biomeSource);
        int cfg = (Integer)SkyGridConfig.SPACING.get();
        int json = Math.max(2, spacingFromJson);
        this.spacing = Math.max(2, cfg > 0 ? cfg : json);
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunk) {
        this.ensurePoolsBuilt();
        int minY = chunk.getMinBuildHeight();
        int maxY = chunk.getMaxBuildHeight();
        int baseX = chunk.getPos().getMinBlockX();
        int baseZ = chunk.getPos().getMinBlockZ();
        for (int lx = 0; lx < 16; ++lx) {
            int wx = baseX + lx;
            if (!this.onGrid(wx)) continue;
            for (int lz = 0; lz < 16; ++lz) {
                int wz = baseZ + lz;
                if (!this.onGrid(wz)) continue;
                for (int y = minY; y < maxY; ++y) {
                    if (!this.onGrid(y)) continue;
                    BlockPos worldPos = new BlockPos(wx, y, wz);
                    BlockState state = y <= 64 ? SkyGridChunkGenerator.pickFrom(this.allBlocksNoWaterNoAir, worldPos, randomState) : SkyGridChunkGenerator.pickFrom(this.nonFluidBlocks, worldPos, randomState);
                    chunk.setBlockState(new BlockPos(lx, y, lz), state, false);
                }
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    public int getBaseHeight(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState random) {
        return level.getMinBuildHeight();
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor height, RandomState random) {
        return new NoiseColumn(height.getMinBuildHeight(), new BlockState[0]);
    }

    private boolean onGrid(int v) {
        int m = v % this.spacing;
        if (m < 0) {
            m += this.spacing;
        }
        return m == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePoolsBuilt() {
        if (this.allBlocksNoWaterNoAir != null && this.nonFluidBlocks != null) {
            return;
        }
        SkyGridChunkGenerator skyGridChunkGenerator = this;
        synchronized (skyGridChunkGenerator) {
            if (this.allBlocksNoWaterNoAir != null && this.nonFluidBlocks != null) {
                return;
            }
            ArrayList<BlockState> all = new ArrayList<BlockState>();
            ArrayList<BlockState> noFluid = new ArrayList<BlockState>();
            for (Block b : BuiltInRegistries.BLOCK) {
                ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)b);
                if (id == null || id.equals((Object)AIR_ID) || id.equals((Object)CAVE_AIR_ID) || id.equals((Object)VOID_AIR_ID) || id.equals((Object)WATER_ID)) continue;
                String idString = id.toString();
                if (((List)SkyGridConfig.BLOCK_BLACKLIST.get()).contains(idString)) continue;
                BlockState st = b.defaultBlockState();
                all.add(st);
                if (SkyGridChunkGenerator.isFluidLike(st)) continue;
                noFluid.add(st);
            }
            if (all.isEmpty()) {
                all.add(Blocks.STONE.defaultBlockState());
            }
            if (noFluid.isEmpty()) {
                noFluid.add(Blocks.STONE.defaultBlockState());
            }
            this.allBlocksNoWaterNoAir = List.copyOf(all);
            this.nonFluidBlocks = List.copyOf(noFluid);
        }
    }

    private static boolean isFluidLike(BlockState st) {
        if (st.getBlock() instanceof LiquidBlock) {
            return true;
        }
        return !st.getFluidState().isEmpty();
    }

    private static BlockState pickFrom(List<BlockState> pool, BlockPos pos, RandomState randomState) {
        long h = SkyGridChunkGenerator.mix(pos.getX(), pos.getY(), pos.getZ());
        long worldish = randomState.hashCode();
        RandomSource r = RandomSource.create((long)(h ^ worldish));
        return pool.get(r.nextInt(pool.size()));
    }

    private static long mix(int x, int y, int z) {
        long h = 1469598103934665603L;
        h = (h ^ (long)x) * 1099511628211L;
        h = (h ^ (long)y) * 1099511628211L;
        h = (h ^ (long)z) * 1099511628211L;
        return h;
    }

    public void addDebugScreenInfo(List<String> info, RandomState randomState, BlockPos pos) {
        info.add("SkyGrid Modded Generator");
        info.add("Spacing: " + this.spacing);
        info.add("Fluids allowed at Y <= 64");
    }

    public int getMinY() {
        return -64;
    }

    public int getGenDepth() {
        return 384;
    }

    public int getSeaLevel() {
        return 63;
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
    }

    public void buildSurface(WorldGenRegion region, StructureManager structureManager, RandomState randomState, ChunkAccess chunk) {
    }

    public void applyCarvers(WorldGenRegion region, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunk, GenerationStep.Carving step) {
    }

    public void applyBiomeDecoration(WorldGenLevel level, ChunkAccess chunk, StructureManager structureManager) {
    }
}

