/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.util.ProperBrewingRecipe;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="greekfantasy")
public class GFBrewingRecipes {
    @SubscribeEvent
    public static void onRegisterBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        if (GreekFantasy.CONFIG.isMirroringEffectEnabled()) {
            builder.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{GFBrewingRecipes.createPotion((Holder<Potion>)Potions.AWKWARD)}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)GFRegistry.ItemReg.MIRROR.get()}), GFBrewingRecipes.createPotion(GFRegistry.PotionReg.MIRRORING)));
            builder.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{GFBrewingRecipes.createPotion(GFRegistry.PotionReg.MIRRORING)}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), GFBrewingRecipes.createPotion(GFRegistry.PotionReg.LONG_MIRRORING)));
        }
        if (GreekFantasy.CONFIG.isCurseOfCirceEnabled()) {
            builder.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{GFBrewingRecipes.createPotion((Holder<Potion>)Potions.AWKWARD)}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)GFRegistry.ItemReg.BOAR_EAR.get()}), GFBrewingRecipes.createPotion(GFRegistry.PotionReg.CURSE_OF_CIRCE)));
            builder.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{GFBrewingRecipes.createPotion(GFRegistry.PotionReg.CURSE_OF_CIRCE)}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), GFBrewingRecipes.createPotion(GFRegistry.PotionReg.LONG_CURSE_OF_CIRCE)));
        }
        builder.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{GFBrewingRecipes.createPotion((Holder<Potion>)Potions.AWKWARD)}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)GFRegistry.ItemReg.SNAKESKIN.get()}), GFBrewingRecipes.createPotion(GFRegistry.PotionReg.SLOW_SWIM)));
        builder.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{GFBrewingRecipes.createPotion(GFRegistry.PotionReg.SLOW_SWIM)}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), GFBrewingRecipes.createPotion(GFRegistry.PotionReg.LONG_SLOW_SWIM)));
    }

    private static ItemStack createPotion(DeferredHolder<Potion, Potion> potion) {
        return GFBrewingRecipes.createPotion((Holder<Potion>)potion.getDelegate());
    }

    private static ItemStack createPotion(Holder<Potion> potion) {
        ItemStack stack = new ItemStack((ItemLike)Items.POTION);
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
        return stack;
    }
}

