/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GFConfig {
    public final ModConfigSpec.IntValue APOLLO_BOW_DURABILITY_ON_USE;
    public final ModConfigSpec.IntValue ARTEMIS_BOW_DURABILITY_ON_USE;
    public final ModConfigSpec.IntValue AVERNAL_BOW_DURABILITY_ON_USE;
    public final ModConfigSpec.IntValue BAG_OF_WIND_DURATION;
    public final ModConfigSpec.IntValue BAG_OF_WIND_COOLDOWN;
    public final ModConfigSpec.IntValue BAG_OF_WIND_DURABILITY_ON_USE;
    public final ModConfigSpec.IntValue CONCH_DURABILITY_ON_USE;
    public final ModConfigSpec.IntValue DRAGON_TOOTH_SPARTI_COUNT;
    public final ModConfigSpec.IntValue DRAGON_TOOTH_SPARTI_LIFESPAN;
    public final ModConfigSpec.IntValue HORN_OF_PLENTY_DURABILITY_ON_USE;
    public final ModConfigSpec.IntValue STAFF_OF_HEALING_COOLDOWN;
    public final ModConfigSpec.IntValue STAFF_OF_HEALING_DURABILITY_ON_USE;
    public final ModConfigSpec.IntValue THUNDERBOLT_COOLDOWN;
    public final ModConfigSpec.IntValue THUNDERBOLT_DURABILITY_ON_USE;
    public final ModConfigSpec.IntValue THUNDERBOLT_DURABILITY_ON_FIREFLASH;
    public final ModConfigSpec.IntValue THYRSUS_COOLDOWN;
    public final ModConfigSpec.IntValue THYRSUS_DURABILITY_ON_USE;
    public final ModConfigSpec.BooleanValue UNICORN_HORN_CURES_EFFECTS;
    public final ModConfigSpec.IntValue UNICORN_HORN_DURABILITY_ON_USE;
    private final ModConfigSpec.DoubleValue WINGED_SANDALS_DURABILITY_CHANCE;
    private double wingedSandalsDurabilityChance;
    public final ModConfigSpec.IntValue WAND_OF_CIRCE_DURATION;
    public final ModConfigSpec.IntValue WAND_OF_CIRCE_COOLDOWN;
    public final ModConfigSpec.IntValue WAND_OF_CIRCE_DURABILITY_ON_USE;
    private final ModConfigSpec.BooleanValue HELM_HIDES_ARMOR;
    private boolean helmHidesArmor;
    public final ModConfigSpec.BooleanValue BANE_OF_SERPENTS_ENABLED;
    public final ModConfigSpec.BooleanValue BANE_OF_SERPENTS_TRADEABLE;
    public final ModConfigSpec.BooleanValue DAYBREAK_ENABLED;
    public final ModConfigSpec.BooleanValue FIREFLASH_ENABLED;
    public final ModConfigSpec.BooleanValue FIREFLASH_DESTROYS_BLOCKS;
    private final ModConfigSpec.BooleanValue FLYING_ENABLED;
    private boolean isFlyingEnabled;
    public final ModConfigSpec.BooleanValue HUNTING_ENABLED;
    public final ModConfigSpec.BooleanValue HUNTING_TRADEABLE;
    public final ModConfigSpec.BooleanValue LORD_OF_THE_SEA_ENABLED;
    public final ModConfigSpec.IntValue LORD_OF_THE_SEA_WHIRL_LIFESPAN;
    private final ModConfigSpec.BooleanValue MIRRORING_ENCHANTMENT_ENABLED;
    public final ModConfigSpec.BooleanValue MIRRORING_TRADEABLE;
    private boolean isMirroringEnchantmentEnabled;
    public final ModConfigSpec.BooleanValue SMASHING_NERF;
    public final ModConfigSpec.BooleanValue SMASHING_TRADEABLE;
    private final ModConfigSpec.BooleanValue OVERSTEP_ENABLED;
    public final ModConfigSpec.BooleanValue OVERSTEP_TRADEABLE;
    private boolean isOverstepEnabled;
    private final ModConfigSpec.BooleanValue POISONING_ENABLED;
    public final ModConfigSpec.BooleanValue POISONING_TRADEABLE;
    private boolean isPoisoningEnabled;
    public final ModConfigSpec.BooleanValue RAISING_ENABLED;
    public final ModConfigSpec.IntValue RAISING_SPARTI_LIFESPAN;
    private final ModConfigSpec.BooleanValue SILKSTEP_ENABLED;
    public final ModConfigSpec.BooleanValue SILKSTEP_TRADEABLE;
    private boolean isSilkstepEnabled;
    public final ModConfigSpec.DoubleValue CIRCE_SPAWN_CHANCE;
    public final ModConfigSpec.DoubleValue ELPIS_SPAWN_CHANCE;
    public final ModConfigSpec.BooleanValue GIANT_BOAR_NON_NETHER;
    public final ModConfigSpec.DoubleValue MEDUSA_LIGHTNING_CHANCE;
    public final ModConfigSpec.DoubleValue MEDUSA_SPAWN_CHANCE;
    public final ModConfigSpec.DoubleValue NEMEAN_LION_LIGHTNING_CHANCE;
    public final ModConfigSpec.DoubleValue SHADE_SPAWN_CHANCE;
    public final ModConfigSpec.DoubleValue SATYR_SHAMAN_CHANCE;
    public final ModConfigSpec.DoubleValue SCYLLA_SPAWN_CHANCE;
    private static final ResourceLocation SATYR_SONG_FALLBACK = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"greensleeves");
    private final ModConfigSpec.ConfigValue<? extends String> SATYR_SONG;
    private ResourceLocation satyrSong;
    public final ModConfigSpec.BooleanValue SHADE_IMMUNE_TO_NONOWNER;
    private final ModConfigSpec.BooleanValue SHOW_ARACHNE_BOSS_BAR;
    private boolean showArachneBossBar;
    private final ModConfigSpec.BooleanValue SHOW_CIRCE_BOSS_BAR;
    private boolean showCirceBossBar;
    private final ModConfigSpec.BooleanValue SHOW_CRETAN_BOSS_BAR;
    private boolean showCretanBossBar;
    private final ModConfigSpec.BooleanValue SHOW_GIANT_BOAR_BOSS_BAR;
    private boolean showGiantBoarBossBar;
    private final ModConfigSpec.BooleanValue SHOW_HYDRA_BOSS_BAR;
    private boolean showHydraBossBar;
    private final ModConfigSpec.BooleanValue SHOW_MEDUSA_BOSS_BAR;
    private boolean showMedusaBossBar;
    private final ModConfigSpec.BooleanValue SHOW_NEMEAN_LION_BOSS_BAR;
    private boolean showNemeanLionBossBar;
    private final ModConfigSpec.BooleanValue SHOW_PYTHON_BOSS_BAR;
    private boolean showPythonBossBar;
    private final ModConfigSpec.BooleanValue SHOW_SCYLLA_BOSS_BAR;
    private boolean showScyllaBossBar;
    public final ModConfigSpec.BooleanValue ARA_SEEK_CAMP;
    public final ModConfigSpec.BooleanValue CENTAUR_SEEK_CAMP;
    public final ModConfigSpec.BooleanValue CYCLOPS_SEEK_CAVE;
    public final ModConfigSpec.BooleanValue DOLPHIN_SEEK_OCEAN_VILLAGE;
    public final ModConfigSpec.BooleanValue GIGANTE_SEEK_CAMP;
    public final ModConfigSpec.BooleanValue GUARDIAN_SEEK_OCEAN_VILLAGE;
    public final ModConfigSpec.BooleanValue HYDRA_SEEK_LAIR;
    public final ModConfigSpec.BooleanValue NEMEAN_LION_SEEK_DEN;
    public final ModConfigSpec.BooleanValue SATYR_SEEK_CAMP;
    public final ModConfigSpec.BooleanValue TRITON_SEEK_OCEAN_VILLAGE;
    private final ModConfigSpec.BooleanValue CURSE_OF_CIRCE_ENABLED;
    private boolean isCurseOfCirceEnabled;
    public final ModConfigSpec.IntValue CURSE_OF_CIRCE_DURATION;
    private final ModConfigSpec.ConfigValue<List<? extends String>> CURSE_OF_CIRCE_WHITELIST;
    private List<? extends String> curseOfCirceWhitelist;
    private final ModConfigSpec.BooleanValue MIRRORING_EFFECT_ENABLED;
    private boolean isMirroringEffectEnabled;
    public final ModConfigSpec.BooleanValue PETRIFIED_NERF;
    public final ModConfigSpec.BooleanValue STUNNED_NERF;
    private final ModConfigSpec.BooleanValue PALLADIUM_ENABLED;
    private boolean palladiumEnabled;
    private final ModConfigSpec.IntValue PALLADIUM_CHUNK_RANGE;
    private int palladiumChunkRange;
    private final ModConfigSpec.IntValue PALLADIUM_Y_RANGE;
    private int palladiumYRange;
    public static final String WILDCARD = "*";
    private final ModConfigSpec.ConfigValue<List<? extends String>> SPAWN_DIMENSION_WHITELIST;
    private List<? extends String> spawnDimensionWhitelist;
    private final ModConfigSpec.BooleanValue IS_SPAWN_DIMENSION_WHITELIST;
    private boolean isSpawnDimensionWhitelist;
    private final ModConfigSpec.ConfigValue<List<? extends String>> FEATURE_DIMENSION_WHITELIST;
    private List<? extends String> featureDimensionWhitelist;
    private final ModConfigSpec.BooleanValue IS_FEATURE_DIMENSION_WHITELIST;
    private boolean isFeatureDimensionWhitelist;
    private static final String[] curseOfCirceWhitelistDefault = new String[]{BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PLAYER).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VILLAGER).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE_VILLAGER).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VINDICATOR).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.WANDERING_TRADER).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ILLUSIONER).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PILLAGER).toString(), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"ara").toString(), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"dryad").toString(), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"lampad").toString(), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"naiad").toString(), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"satyr").toString()};

    public GFConfig(ModContainer modContainer) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("items");
        this.APOLLO_BOW_DURABILITY_ON_USE = builder.defineInRange("apollo_bow_durability_on_use", 1, 0, 64);
        this.ARTEMIS_BOW_DURABILITY_ON_USE = builder.defineInRange("artemis_bow_durability_on_use", 1, 0, 64);
        this.AVERNAL_BOW_DURABILITY_ON_USE = builder.defineInRange("avernal_bow_durability_on_use", 1, 0, 64);
        this.BAG_OF_WIND_DURATION = builder.defineInRange("bag_of_wind_duration", 400, 1, 24000);
        this.BAG_OF_WIND_COOLDOWN = builder.defineInRange("bag_of_wind_cooldown", 700, 0, 12000);
        this.BAG_OF_WIND_DURABILITY_ON_USE = builder.defineInRange("bag_of_wind_durability_on_use", 1, 0, 64);
        this.CONCH_DURABILITY_ON_USE = builder.defineInRange("conch_durability_on_use", 0, 0, 64);
        this.HELM_HIDES_ARMOR = builder.define("helm_hides_armor", true);
        this.DRAGON_TOOTH_SPARTI_COUNT = builder.defineInRange("dragon_tooth_sparti_count", 1, 0, 8);
        this.DRAGON_TOOTH_SPARTI_LIFESPAN = builder.defineInRange("dragon_tooth_sparti_lifespan", 300, 1, 24000);
        this.HORN_OF_PLENTY_DURABILITY_ON_USE = builder.defineInRange("horn_of_plenty_durability_on_use", 1, 0, 64);
        this.THUNDERBOLT_COOLDOWN = builder.defineInRange("thunderbolt_cooldown", 100, 0, 24000);
        this.THUNDERBOLT_DURABILITY_ON_USE = builder.defineInRange("thunderbolt_durability_on_use", 15, 0, 128);
        this.THUNDERBOLT_DURABILITY_ON_FIREFLASH = builder.defineInRange("thunderbolt_durability_on_fireflash", 25, 0, 128);
        this.THYRSUS_COOLDOWN = builder.defineInRange("thyrsus_cooldown", 60, 0, 24000);
        this.THYRSUS_DURABILITY_ON_USE = builder.defineInRange("thyrsus_durability_on_use", 1, 0, 64);
        this.STAFF_OF_HEALING_COOLDOWN = builder.defineInRange("staff_of_healing_cooldown", 35, 0, 24000);
        this.STAFF_OF_HEALING_DURABILITY_ON_USE = builder.defineInRange("staff_of_healing_durability_on_use", 1, 0, 64);
        this.UNICORN_HORN_CURES_EFFECTS = builder.define("unicorn_horn_cures_effects", true);
        this.UNICORN_HORN_DURABILITY_ON_USE = builder.defineInRange("unicorn_horn_durability_on_use", 1, 0, 64);
        this.WAND_OF_CIRCE_DURATION = builder.defineInRange("wand_of_circe_duration", 900, 1, 24000);
        this.WAND_OF_CIRCE_COOLDOWN = builder.defineInRange("wand_of_circe_cooldown", 50, 0, 24000);
        this.WAND_OF_CIRCE_DURABILITY_ON_USE = builder.defineInRange("wand_of_circe_durability_on_use", 1, 0, 64);
        this.WINGED_SANDALS_DURABILITY_CHANCE = builder.comment("Percent chance of winged sandals losing durability each tick").defineInRange("winged_sandals_durability_chance", 0.0, 0.0, 1.0);
        builder.pop();
        builder.push("enchantments");
        this.BANE_OF_SERPENTS_ENABLED = builder.define("bane_of_serpents_enabled", true);
        this.BANE_OF_SERPENTS_TRADEABLE = builder.define("bane_of_serpents_tradeable_by_villagers", true);
        this.DAYBREAK_ENABLED = builder.define("daybreak_enabled", true);
        this.FIREFLASH_ENABLED = builder.define("fireflash_enabled", true);
        this.FIREFLASH_DESTROYS_BLOCKS = builder.define("fireflash_destroys_blocks", true);
        this.FLYING_ENABLED = builder.define("flying_enabled", true);
        this.HUNTING_ENABLED = builder.define("hunting_enabled", true);
        this.HUNTING_TRADEABLE = builder.define("hunting_tradeable_by_villagers", true);
        this.LORD_OF_THE_SEA_ENABLED = builder.define("lord_of_the_sea_enabled", true);
        this.LORD_OF_THE_SEA_WHIRL_LIFESPAN = builder.defineInRange("lord_of_the_sea_whirl_lifespan", 60, 1, 1200);
        this.MIRRORING_ENCHANTMENT_ENABLED = builder.define("mirroring_enabled", true);
        this.MIRRORING_TRADEABLE = builder.define("mirroring_tradeable_by_villagers", true);
        this.SMASHING_NERF = builder.comment("When true, Smashing applies slowness instead of stunning").define("smashing_nerf", false);
        this.SMASHING_TRADEABLE = builder.define("smashing_tradeable_by_villagers", false);
        this.OVERSTEP_ENABLED = builder.define("overstep_enabled", true);
        this.OVERSTEP_TRADEABLE = builder.define("overstep_tradeable_by_villagers", true);
        this.POISONING_ENABLED = builder.define("poisoning_enabled", true);
        this.POISONING_TRADEABLE = builder.define("poisoning_tradeable_by_villagers", false);
        this.RAISING_ENABLED = builder.define("raising_enabled", true);
        this.RAISING_SPARTI_LIFESPAN = builder.defineInRange("raising_sparti_lifespan", 120, 1, 1200);
        this.SILKSTEP_ENABLED = builder.define("silkstep_enabled", true);
        this.SILKSTEP_TRADEABLE = builder.define("silkstep_tradeable_by_villagers", false);
        builder.pop();
        builder.push("mobs");
        this.CIRCE_SPAWN_CHANCE = builder.defineInRange("circe_spawn_chance", 2.0, 0.0, 100.0);
        this.GIANT_BOAR_NON_NETHER = builder.comment("Whether a hoglin must be outside of the nether to be turned to a Giant Boar").define("giant_boar_non_nether", true);
        this.ELPIS_SPAWN_CHANCE = builder.comment("Percent chance that opening a mysterious box spawns an Elpis").defineInRange("elpis_spawn_chance", 60.0, 0.0, 100.0);
        this.MEDUSA_LIGHTNING_CHANCE = builder.comment("Percent chance that lightning converts Gorgon to Medusa").defineInRange("medusa_lightning_chance", 95.0, 0.0, 100.0);
        this.MEDUSA_SPAWN_CHANCE = builder.defineInRange("medusa_spawn_chance", (double)0.8f, 0.0, 100.0);
        this.NEMEAN_LION_LIGHTNING_CHANCE = builder.comment("Percent chance that lightning converts strengthened Ocelot to Nemean Lion").defineInRange("nemean_lion_lightning_chance", 100.0, 0.0, 100.0);
        this.SHADE_SPAWN_CHANCE = builder.defineInRange("shade_spawn_chance", 100.0, 0.0, 100.0);
        this.SATYR_SHAMAN_CHANCE = builder.defineInRange("satyr_shaman_chance", 24.0, 0.0, 100.0);
        this.SCYLLA_SPAWN_CHANCE = builder.comment("Percent chance that creating a Charybdis also creates a Scylla").defineInRange("scylla_spawn_chance", 55.0, 0.0, 100.0);
        this.SATYR_SONG = builder.define("satyr_song", (Object)SATYR_SONG_FALLBACK.toString());
        this.SHADE_IMMUNE_TO_NONOWNER = builder.define("shade_immune_to_nonowner", true);
        this.SHOW_ARACHNE_BOSS_BAR = builder.define("show_arachne_boss_bar", false);
        this.SHOW_CIRCE_BOSS_BAR = builder.define("show_circe_boss_bar", false);
        this.SHOW_CRETAN_BOSS_BAR = builder.define("show_cretan_boss_bar", false);
        this.SHOW_GIANT_BOAR_BOSS_BAR = builder.define("show_giant_boar_boss_bar", true);
        this.SHOW_HYDRA_BOSS_BAR = builder.define("show_hydra_boss_bar", true);
        this.SHOW_MEDUSA_BOSS_BAR = builder.define("show_medusa_boss_bar", false);
        this.SHOW_NEMEAN_LION_BOSS_BAR = builder.define("show_nemean_lion_boss_bar", true);
        this.SHOW_PYTHON_BOSS_BAR = builder.define("show_python_boss_bar", true);
        this.SHOW_SCYLLA_BOSS_BAR = builder.define("show_scylla_boss_bar", true);
        builder.pop();
        builder.push("goals");
        this.ARA_SEEK_CAMP = builder.define("ara_seek_camp", true);
        this.CENTAUR_SEEK_CAMP = builder.define("centaur_seek_camp", false);
        this.CYCLOPS_SEEK_CAVE = builder.define("cyclops_seek_cave", false);
        this.DOLPHIN_SEEK_OCEAN_VILLAGE = builder.define("dolphin_seek_ocean_village", false);
        this.GIGANTE_SEEK_CAMP = builder.define("gigante_seek_camp", false);
        this.GUARDIAN_SEEK_OCEAN_VILLAGE = builder.define("guardian_seek_ocean_village", true);
        this.HYDRA_SEEK_LAIR = builder.define("hydra_seek_lair", true);
        this.NEMEAN_LION_SEEK_DEN = builder.define("nemean_lion_seek_den", true);
        this.SATYR_SEEK_CAMP = builder.define("satyr_seek_camp", false);
        this.TRITON_SEEK_OCEAN_VILLAGE = builder.define("triton_seek_ocean_village", true);
        builder.pop();
        builder.push("mob_effects");
        this.CURSE_OF_CIRCE_ENABLED = builder.define("curse_of_circe_enabled", true);
        this.CURSE_OF_CIRCE_DURATION = builder.defineInRange("curse_of_circe_duration", 900, 1, 24000);
        this.CURSE_OF_CIRCE_WHITELIST = builder.comment(new String[]{"Mobs that can be affected by the Curse of Circe.", "Accepts entity id or mod id with wildcard.", "Example: [\"minecraft:zombie\", \"othermod:*\"]"}).defineList("curse_of_circe_whitelist", List.of(curseOfCirceWhitelistDefault), o -> o instanceof String);
        this.MIRRORING_EFFECT_ENABLED = builder.define("mirroring_enabled", false);
        this.PETRIFIED_NERF = builder.comment("When true, Petrified applies slowness instead of stunning").define("petrified_nerf", false);
        this.STUNNED_NERF = builder.comment("When true, Stunned applies slowness instead of stunning").define("stunned_nerf", false);
        builder.pop();
        builder.push("palladium");
        this.PALLADIUM_ENABLED = builder.comment("Whether the Palladium can prevent monster spawns").define("palladium_enabled", true);
        this.PALLADIUM_CHUNK_RANGE = builder.comment("The radius (in chunks) of the area protected by Palladium blocks (0=same chunk only)").defineInRange("palladium_chunk_range", 2, 0, 3);
        this.PALLADIUM_Y_RANGE = builder.comment("The vertical area (in blocks) protected by Palladium blocks").defineInRange("palladium_y_range", 128, 0, 255);
        builder.pop();
        builder.push("mob_spawns");
        this.SPAWN_DIMENSION_WHITELIST = builder.comment(new String[]{"Dimensions in which mobs can spawn.", "Accepts dimension id or mod id with wildcard.", "Example: [\"minecraft:the_nether\", \"rftoolsdim:*\"]"}).define("spawn_dimensions", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:*"}));
        this.IS_SPAWN_DIMENSION_WHITELIST = builder.comment("true if the above list is a whitelist, false for blacklist").define("is_whitelist", true);
        builder.pop();
        builder.comment("Feature generation chances (higher number = more features)").push("features");
        this.FEATURE_DIMENSION_WHITELIST = builder.comment(new String[]{"Dimensions in which mobs can spawn.", "Accepts dimension id or mod id with wildcard.", "Example: [\"minecraft:the_nether\", \"rftoolsdim:*\"]"}).define("spawn_dimensions", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:*"}));
        this.IS_FEATURE_DIMENSION_WHITELIST = builder.comment("true if the above list is a whitelist, false for blacklist").define("is_whitelist", true);
        builder.pop();
        ModConfigSpec spec = builder.build();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec);
    }

    public void bake() {
        this.helmHidesArmor = (Boolean)this.HELM_HIDES_ARMOR.get();
        this.wingedSandalsDurabilityChance = (Double)this.WINGED_SANDALS_DURABILITY_CHANCE.get();
        this.isFlyingEnabled = (Boolean)this.FLYING_ENABLED.get();
        this.isMirroringEnchantmentEnabled = (Boolean)this.MIRRORING_ENCHANTMENT_ENABLED.get();
        this.isOverstepEnabled = (Boolean)this.OVERSTEP_ENABLED.get();
        this.isPoisoningEnabled = (Boolean)this.POISONING_ENABLED.get();
        this.isSilkstepEnabled = (Boolean)this.SILKSTEP_ENABLED.get();
        this.showArachneBossBar = (Boolean)this.SHOW_ARACHNE_BOSS_BAR.get();
        this.showCirceBossBar = (Boolean)this.SHOW_CIRCE_BOSS_BAR.get();
        this.showCretanBossBar = (Boolean)this.SHOW_CRETAN_BOSS_BAR.get();
        this.showGiantBoarBossBar = (Boolean)this.SHOW_GIANT_BOAR_BOSS_BAR.get();
        this.showHydraBossBar = (Boolean)this.SHOW_HYDRA_BOSS_BAR.get();
        this.showMedusaBossBar = (Boolean)this.SHOW_MEDUSA_BOSS_BAR.get();
        this.showNemeanLionBossBar = (Boolean)this.SHOW_NEMEAN_LION_BOSS_BAR.get();
        this.showPythonBossBar = (Boolean)this.SHOW_PYTHON_BOSS_BAR.get();
        this.showScyllaBossBar = (Boolean)this.SHOW_SCYLLA_BOSS_BAR.get();
        this.satyrSong = ResourceLocation.tryParse((String)((String)this.SATYR_SONG.get()));
        if (null == this.satyrSong) {
            this.satyrSong = SATYR_SONG_FALLBACK;
        }
        this.isCurseOfCirceEnabled = (Boolean)this.CURSE_OF_CIRCE_ENABLED.get();
        this.curseOfCirceWhitelist = ImmutableList.copyOf((Collection)((Collection)this.CURSE_OF_CIRCE_WHITELIST.get()));
        this.isMirroringEffectEnabled = (Boolean)this.MIRRORING_EFFECT_ENABLED.get();
        this.palladiumEnabled = (Boolean)this.PALLADIUM_ENABLED.get();
        this.palladiumChunkRange = (Integer)this.PALLADIUM_CHUNK_RANGE.get();
        this.palladiumYRange = (Integer)this.PALLADIUM_Y_RANGE.get();
        this.spawnDimensionWhitelist = (List)this.SPAWN_DIMENSION_WHITELIST.get();
        this.isSpawnDimensionWhitelist = (Boolean)this.IS_SPAWN_DIMENSION_WHITELIST.get();
        this.featureDimensionWhitelist = (List)this.FEATURE_DIMENSION_WHITELIST.get();
        this.isFeatureDimensionWhitelist = (Boolean)this.IS_FEATURE_DIMENSION_WHITELIST.get();
    }

    public boolean helmHidesArmor() {
        return this.helmHidesArmor;
    }

    public double getWingedSandalsDurabilityChance() {
        return this.wingedSandalsDurabilityChance;
    }

    public boolean isFlyingEnabled() {
        return this.isFlyingEnabled;
    }

    public boolean isPoisoningEnabled() {
        return this.isPoisoningEnabled;
    }

    public boolean isMirroringEnchantmentEnabled() {
        return this.isMirroringEnchantmentEnabled;
    }

    public boolean isOverstepEnabled() {
        return this.isOverstepEnabled;
    }

    public boolean isSilkstepEnabled() {
        return this.isSilkstepEnabled;
    }

    public boolean showArachneBossBar() {
        return this.showArachneBossBar;
    }

    public boolean showCirceBossBar() {
        return this.showCirceBossBar;
    }

    public boolean showCretanBossBar() {
        return this.showCretanBossBar;
    }

    public boolean showGiantBoarBossBar() {
        return this.showGiantBoarBossBar;
    }

    public boolean showHydraBossBar() {
        return this.showHydraBossBar;
    }

    public boolean showMedusaBossBar() {
        return this.showMedusaBossBar;
    }

    public boolean showNemeanLionBossBar() {
        return this.showNemeanLionBossBar;
    }

    public boolean showPythonBossBar() {
        return this.showPythonBossBar;
    }

    public boolean showScyllaBossBar() {
        return this.showScyllaBossBar;
    }

    public ResourceLocation getSatyrSong() {
        return this.satyrSong;
    }

    public boolean isCurseOfCirceEnabled() {
        return this.isCurseOfCirceEnabled;
    }

    public boolean isCurseOfCirceApplicable(@NonNull LivingEntity entity) {
        ResourceLocation type = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return this.curseOfCirceWhitelist.contains(type.toString()) || this.curseOfCirceWhitelist.contains(type.getNamespace() + ":*");
    }

    public boolean isMirroringEffectEnabled() {
        return this.isMirroringEffectEnabled;
    }

    public boolean isPalladiumEnabled() {
        return this.palladiumEnabled;
    }

    public int getPalladiumChunkRange() {
        return this.palladiumChunkRange;
    }

    public int getPalladiumYRange() {
        return this.palladiumYRange;
    }

    public boolean featureMatchesDimension(Level level) {
        return GFConfig.matchesDimension(this.featureDimensionWhitelist, this.isFeatureDimensionWhitelist, level.dimension().location());
    }

    public boolean spawnMatchesDimension(ServerLevel level) {
        return GFConfig.matchesDimension(this.spawnDimensionWhitelist, this.isSpawnDimensionWhitelist, level.dimension().location());
    }

    private static boolean matchesDimension(List<? extends String> list, boolean isWhitelist, ResourceLocation dimensionId) {
        return isWhitelist == (list.contains(dimensionId.toString()) || list.contains(dimensionId.getNamespace() + ":*"));
    }
}

