/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy;

import greekfantasy.GFRegistry;
import greekfantasy.GFSavedData;
import greekfantasy.GreekFantasy;
import greekfantasy.enchantment.EnchantmentUtils;
import greekfantasy.enchantment.GFEnchantments;
import greekfantasy.entity.Arion;
import greekfantasy.entity.Automaton;
import greekfantasy.entity.Cerastes;
import greekfantasy.entity.GoldenRam;
import greekfantasy.entity.Naiad;
import greekfantasy.entity.Orthus;
import greekfantasy.entity.Palladium;
import greekfantasy.entity.Triton;
import greekfantasy.entity.Whirl;
import greekfantasy.entity.ai.DolphinTemptByTritonGoal;
import greekfantasy.entity.ai.MoveToStructureGoal;
import greekfantasy.entity.boss.Geryon;
import greekfantasy.entity.boss.GiantBoar;
import greekfantasy.entity.boss.NemeanLion;
import greekfantasy.entity.monster.Circe;
import greekfantasy.entity.monster.Shade;
import greekfantasy.integration.RGCompat;
import greekfantasy.item.HellenicArmorItem;
import greekfantasy.item.NemeanLionHideItem;
import greekfantasy.item.ThunderboltItem;
import greekfantasy.network.SCurseOfCircePacket;
import greekfantasy.util.SummonBossUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public final class GFEvents {

    public static final class ForgeHandler {
        private static final List<PendingSummonCheck> PENDING_SUMMON_CHECKS = new ArrayList<PendingSummonCheck>();
        private static long lastSummonProcessTick = -1L;

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onPlayerDeath(LivingDeathEvent event) {
            Player player;
            LivingEntity livingEntity;
            if (!event.isCanceled() && !event.getEntity().level().isClientSide() && (livingEntity = event.getEntity()) instanceof Player && !(player = (Player)livingEntity).isSpectator() && player.experienceLevel > 3 && !player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && (double)(player.getRandom().nextFloat() * 100.0f) < (Double)GreekFantasy.CONFIG.SHADE_SPAWN_CHANCE.get()) {
                int xp = player.totalExperience;
                player.giveExperienceLevels(-(player.experienceLevel + 1));
                Shade shade = (Shade)((EntityType)GFRegistry.EntityReg.SHADE.get()).create(player.level());
                shade.moveTo(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
                shade.setStoredXP(Mth.floor((float)((float)xp * 0.9f)));
                shade.setOwnerUUID(player.getUUID());
                shade.setPersistenceRequired();
                player.level().addFreshEntity((Entity)shade);
            }
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            if (!event.isCanceled() && event.getEntity().isEffectiveAi() && event.getSource().getEntity() instanceof Player) {
                BlockPos deathPos = event.getEntity().blockPosition();
                if (event.getEntity() instanceof Cow && Geryon.canGeryonSpawnOn((LevelAccessor)event.getEntity().level(), deathPos)) {
                    ArrayList<BlockPos> heads = new ArrayList<BlockPos>();
                    int r = 3;
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    for (int x = -3; x <= 3; ++x) {
                        for (int y = -2; y <= 2; ++y) {
                            for (int z = -3; z <= 3; ++z) {
                                pos.setWithOffset((Vec3i)deathPos, x, y, z);
                                if (event.getEntity().level().getBlockState((BlockPos)pos).is((Block)GFRegistry.BlockReg.GIGANTE_HEAD.get())) {
                                    heads.add(pos.immutable());
                                }
                                if (heads.size() < 3) continue;
                                heads.subList(0, 3).forEach(p -> event.getEntity().level().destroyBlock(p, false));
                                float yaw = Mth.wrapDegrees((float)(event.getSource().getEntity().getYRot() + 180.0f));
                                Geryon.spawnGeryon(event.getEntity().level(), deathPos, yaw);
                                return;
                            }
                        }
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            EntityHitResult entityHitResult;
            HitResult hitResult;
            if (!event.getProjectile().level().isClientSide() && event.getRayTraceResult().getType() == HitResult.Type.ENTITY && (hitResult = event.getRayTraceResult()) instanceof EntityHitResult && (hitResult = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof LivingEntity) {
                AbstractArrow arrow;
                Projectile projectile;
                LivingEntity livingEntity = (LivingEntity)hitResult;
                double dot = ForgeHandler.getDotProduct((Entity)livingEntity, (Entity)event.getProjectile(), true);
                GreekFantasy.LOGGER.debug("dot=" + dot);
                int achillesCount = HellenicArmorItem.getAchillesCount(livingEntity);
                if (achillesCount > 0 && HellenicArmorItem.isImmune(livingEntity, event.getProjectile(), dot, achillesCount)) {
                    event.getProjectile().setDeltaMovement(event.getProjectile().getDeltaMovement().multiply(-1.0, 1.0, -1.0));
                    event.setCanceled(true);
                    HellenicArmorItem.damageArmor(livingEntity, 1);
                    return;
                }
                if (achillesCount > 0 && (projectile = event.getProjectile()) instanceof AbstractArrow && HellenicArmorItem.isCritical(livingEntity, arrow = (AbstractArrow)projectile, dot, achillesCount)) {
                    arrow.setBaseDamage(arrow.getBaseDamage() * (2.0 + 0.5 * (double)achillesCount));
                    event.setCanceled(false);
                    return;
                }
                ItemStack helmet = livingEntity.getItemBySlot(EquipmentSlot.HEAD);
                if (achillesCount == 0 && helmet.is((Item)GFRegistry.ItemReg.NEMEAN_LION_HIDE.get()) && NemeanLionHideItem.isImmune(livingEntity, event.getProjectile(), dot)) {
                    event.getProjectile().setDeltaMovement(event.getProjectile().getDeltaMovement().multiply(-1.0, 1.0, -1.0));
                    event.setCanceled(true);
                    helmet.hurtAndBreak(1, livingEntity, EquipmentSlot.HEAD);
                    return;
                }
            }
        }

        private static double getDotProduct(Entity first, Entity second, boolean horizontalOnly) {
            Vec2 firstVec = new Vec2(horizontalOnly ? 0.0f : first.getXRot(), first.getYRot());
            Vec2 secondVec = new Vec2(horizontalOnly ? 0.0f : second.getXRot(), second.getYRot());
            Vec3 firstFacing = Vec3.directionFromRotation((Vec2)firstVec);
            Vec3 secondFacing = Vec3.directionFromRotation((Vec2)secondVec);
            GreekFantasy.LOGGER.debug("\nfirst=" + String.valueOf(firstFacing) + "\nsecond=" + String.valueOf(secondFacing));
            return secondFacing.dot(firstFacing);
        }

        /*
         * Enabled aggressive block sorting
         */
        @SubscribeEvent
        public static void onLivingTick(EntityTickEvent.Post event) {
            LivingEntity livingEntity;
            block5: {
                block4: {
                    Entity entity = event.getEntity();
                    if (!(entity instanceof LivingEntity)) return;
                    livingEntity = (LivingEntity)entity;
                    if (livingEntity.level().isClientSide()) {
                        return;
                    }
                    if (!livingEntity.hasEffect(GFRegistry.MobEffectReg.PRISONER_OF_HADES)) return;
                    if (livingEntity.level().dimension() != Level.NETHER) break block4;
                    if (!GreekFantasy.isRGLoaded() || !(livingEntity instanceof Player)) break block5;
                    Player player = (Player)livingEntity;
                    if (!RGCompat.getInstance().canRemovePrisonerEffect(player)) break block5;
                }
                livingEntity.removeEffect(GFRegistry.MobEffectReg.PRISONER_OF_HADES);
                return;
            }
            livingEntity.setPortalCooldown();
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            GFSavedData data;
            if (!event.getEntity().isAlive()) {
                return;
            }
            boolean isRidingLion = event.getEntity().getVehicle() instanceof NemeanLion;
            Pose currentPose = event.getEntity().getForcedPose();
            if (isRidingLion && currentPose != Pose.FALL_FLYING) {
                event.getEntity().setForcedPose(Pose.FALL_FLYING);
                event.getEntity().setPose(Pose.FALL_FLYING);
            } else if (!isRidingLion && Pose.FALL_FLYING == currentPose) {
                event.getEntity().setForcedPose(null);
            }
            if (GreekFantasy.CONFIG.isCurseOfCirceEnabled()) {
                boolean curseOfCirce = event.getEntity().hasEffect(GFRegistry.MobEffectReg.CURSE_OF_CIRCE);
                if (event.getEntity().level().isClientSide()) {
                    Pose forcedPose = event.getEntity().getForcedPose();
                    if (curseOfCirce && forcedPose != Pose.SWIMMING) {
                        event.getEntity().setForcedPose(Pose.SWIMMING);
                        event.getEntity().setPose(Pose.SWIMMING);
                    } else if (!curseOfCirce && Pose.SWIMMING == forcedPose) {
                        event.getEntity().setForcedPose(null);
                    }
                } else if (!curseOfCirce && event.getEntity().getForcedPose() != null) {
                    event.getEntity().setForcedPose(null);
                }
            }
            if (GreekFantasy.CONFIG.isFlyingEnabled() && event.getEntity().level() instanceof ServerLevel && !event.getEntity().isCreative() && !event.getEntity().isSpectator() && event.getEntity().tickCount > 10 && event.getEntity().level().getGameTime() % 11L == 0L && (data = GFSavedData.getOrCreate((ServerLevel)event.getEntity().level())).hasFlyingPlayer(event.getEntity()) && !GFSavedData.validatePlayer(event.getEntity())) {
                data.removeFlyingPlayer(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onChangeEquipment(LivingEquipmentChangeEvent event) {
            Player player;
            LivingEntity livingEntity;
            if (GreekFantasy.CONFIG.isFlyingEnabled() && (livingEntity = event.getEntity()) instanceof Player && (player = (Player)livingEntity).level() instanceof ServerLevel && event.getSlot() == EquipmentSlot.FEET && event.getTo().is((Item)GFRegistry.ItemReg.WINGED_SANDALS.get())) {
                GFSavedData data = GFSavedData.getOrCreate((ServerLevel)player.level());
                if (GFSavedData.validatePlayer(player)) {
                    data.addFlyingPlayer(player);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerAttack(AttackEntityEvent event) {
            if (ForgeHandler.isStunnedOrPetrified((LivingEntity)event.getEntity())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            if (ForgeHandler.isStunnedOrPetrified((LivingEntity)event.getEntity())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            Player player;
            if (ForgeHandler.isStunnedOrPetrified((LivingEntity)event.getEntity())) {
                event.setCanceled(true);
                return;
            }
            if (!event.isCanceled() && !event.getLevel().isClientSide() && (player = event.getEntity()) instanceof Player) {
                Player player2 = player;
                BlockPos placedPos = event.getPos().relative(event.getFace());
                PENDING_SUMMON_CHECKS.add(new PendingSummonCheck(placedPos, player2.getUUID(), 1));
            }
        }

        @SubscribeEvent
        public static void onPlayerTickPost(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.level().isClientSide()) {
                return;
            }
            long gameTime = player2.level().getGameTime();
            if (gameTime == lastSummonProcessTick) {
                return;
            }
            lastSummonProcessTick = gameTime;
            if (PENDING_SUMMON_CHECKS.isEmpty()) {
                return;
            }
            ServerLevel level = (ServerLevel)player2.level();
            PENDING_SUMMON_CHECKS.removeIf(check -> {
                --check.ticksLeft;
                if (check.ticksLeft > 0) {
                    return false;
                }
                BlockPos pos = check.pos;
                if (!level.isLoaded(pos)) {
                    return true;
                }
                Player owner = level.getPlayerByUUID(check.playerId);
                if (owner != null) {
                    // empty if block
                }
                SummonBossUtil.onPlaceBronzeBlock((Level)level, pos, level.getBlockState(pos), (Entity)owner);
                return true;
            });
        }

        private static boolean isStunnedOrPetrified(@Nullable LivingEntity entity) {
            return entity != null && entity.isAlive() && (entity.hasEffect(GFRegistry.MobEffectReg.STUNNED) || entity.hasEffect(GFRegistry.MobEffectReg.PETRIFIED));
        }

        @SubscribeEvent
        public static void onLivingTarget(LivingChangeTargetEvent event) {
            Mob mob;
            LivingEntity livingEntity;
            if (null == event.getOriginalAboutToBeSetTarget() || event.getEntity().level().isClientSide()) {
                return;
            }
            if (GreekFantasy.CONFIG.isCurseOfCirceEnabled() && (livingEntity = event.getEntity()) instanceof Mob) {
                mob = (Mob)livingEntity;
                if (event.getOriginalAboutToBeSetTarget() != mob.getLastHurtByMob() && (mob.hasEffect(GFRegistry.MobEffectReg.CURSE_OF_CIRCE) || event.getOriginalAboutToBeSetTarget().hasEffect(GFRegistry.MobEffectReg.CURSE_OF_CIRCE))) {
                    event.setCanceled(true);
                }
            }
            if ((livingEntity = event.getEntity()) instanceof Mob && ForgeHandler.isStunnedOrPetrified((LivingEntity)(mob = (Mob)livingEntity))) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onMobEffectStart(MobEffectEvent.Added event) {
            if (!event.getEntity().level().isClientSide() && GreekFantasy.CONFIG.isCurseOfCirceEnabled() && event.getEffectInstance() != null && event.getEffectInstance().is(GFRegistry.MobEffectReg.CURSE_OF_CIRCE) && event.getOldEffectInstance() == null) {
                if (event.getOldEffectInstance() == null) {
                    float health = Mth.clamp((float)event.getEntity().getHealth(), (float)1.0f, (float)(event.getEntity().getMaxHealth() + -10.0f));
                    event.getEntity().setHealth(health);
                }
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)SCurseOfCircePacket.addEffect(event.getEntity().getId(), event.getEffectInstance().getDuration()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @SubscribeEvent
        public static void onMobEffectRemove(MobEffectEvent.Remove event) {
            if (!event.getEntity().level().isClientSide() && GreekFantasy.CONFIG.isCurseOfCirceEnabled() && event.getEffectInstance() != null && event.getEffectInstance().is(GFRegistry.MobEffectReg.CURSE_OF_CIRCE)) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)SCurseOfCircePacket.removeEffect(event.getEntity().getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @SubscribeEvent
        public static void onMobEffectExpire(MobEffectEvent.Expired event) {
            if (!event.getEntity().level().isClientSide() && GreekFantasy.CONFIG.isCurseOfCirceEnabled() && event.getEffectInstance() != null && event.getEffectInstance().is(GFRegistry.MobEffectReg.CURSE_OF_CIRCE)) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)SCurseOfCircePacket.removeEffect(event.getEntity().getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @SubscribeEvent
        public static void onEntityPlaceBlock(BlockEvent.EntityPlaceEvent event) {
            if (!event.isCanceled() && event.getLevel() instanceof Level && SummonBossUtil.isSummonBlock(event.getPlacedBlock())) {
                SummonBossUtil.onPlaceBronzeBlock((Level)event.getLevel(), event.getPos(), event.getPlacedBlock(), event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onItemAttributeModifiers(ItemAttributeModifierEvent event) {
        }

        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
            Entity pos;
            Level level;
            if (event.getEntity() != null && event.getEntity().getType() == EntityType.WITCH && (level = event.getLevel()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                if (!event.getLevel().isClientSide() && event.getLevel().getRandom().nextDouble() * 100.0 < (Double)GreekFantasy.CONFIG.CIRCE_SPAWN_CHANCE.get()) {
                    event.getEntity().discard();
                    pos = event.getEntity().blockPosition();
                    Circe circe = (Circe)((EntityType)GFRegistry.EntityReg.CIRCE.get()).create((Level)level2);
                    if (circe != null) {
                        circe.moveTo(event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), event.getEntity().getYRot(), event.getEntity().getXRot());
                        level2.addFreshEntity((Entity)circe);
                        circe.finalizeSpawn((ServerLevelAccessor)level2, level2.getCurrentDifficultyAt((BlockPos)pos), MobSpawnType.NATURAL, null);
                    }
                }
            }
            if ((pos = event.getEntity()) instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)pos;
                if (!event.getEntity().level().isClientSide()) {
                    if (mob.getType() == EntityType.WITHER_SKELETON) {
                        mob.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal(mob, Orthus.class, 6.0f, 1.0, 1.2));
                    }
                    if (mob.getType() == EntityType.RABBIT && ((Rabbit)event.getEntity()).getVariant().id() != 99) {
                        mob.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal(mob, Cerastes.class, 6.0f, 1.0, 1.2, e -> {
                            Cerastes cerastes;
                            return e instanceof Cerastes && !(cerastes = (Cerastes)((Object)e)).isHiding();
                        }));
                    }
                    if (mob.getType() == EntityType.DOLPHIN && mob instanceof Dolphin) {
                        Dolphin dolphin = (Dolphin)mob;
                        mob.goalSelector.addGoal(2, (Goal)new DolphinTemptByTritonGoal(dolphin, 0.9, Ingredient.of((TagKey)ItemTags.FISHES)));
                        if (((Boolean)GreekFantasy.CONFIG.DOLPHIN_SEEK_OCEAN_VILLAGE.get()).booleanValue()) {
                            mob.goalSelector.addGoal(3, (Goal)new MoveToStructureGoal((PathfinderMob)dolphin, 1.0, 5, 10, 15, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"ocean_village"), BehaviorUtils::getRandomSwimmablePos));
                        }
                    }
                    if (mob.getType() == EntityType.DROWNED) {
                        mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Triton.class, false));
                        mob.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)mob, Naiad.class, true, false));
                    }
                    if (mob.getType() == EntityType.ZOMBIE || mob.getType() == EntityType.DROWNED || mob.getType() == EntityType.HUSK) {
                        mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Automaton.class, true));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingCheckSpawn(MobSpawnEvent.SpawnPlacementCheck event) {
            ServerLevelAccessor serverLevelAccessor;
            int cRadius = GreekFantasy.CONFIG.getPalladiumChunkRange();
            int cVertical = GreekFantasy.CONFIG.getPalladiumYRange() / 2;
            if (GreekFantasy.CONFIG.isPalladiumEnabled() && !event.getLevel().isClientSide() && (event.getSpawnType() == MobSpawnType.NATURAL || event.getSpawnType() == MobSpawnType.REINFORCEMENT || event.getSpawnType() == MobSpawnType.PATROL || event.getSpawnType() == MobSpawnType.SPAWNER) && (serverLevelAccessor = event.getLevel()) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)serverLevelAccessor;
                if (event.getEntityType().getBaseClass().isAssignableFrom(Enemy.class)) {
                    BlockPos eventPos = event.getPos();
                    ChunkPos eventChunkPos = new ChunkPos(eventPos);
                    ChunkPos minChunkPos = new ChunkPos(eventChunkPos.x - cRadius, eventChunkPos.z - cRadius);
                    ChunkPos maxChunkPos = new ChunkPos(eventChunkPos.x + cRadius, eventChunkPos.z + cRadius);
                    BlockPos minBlock = minChunkPos.getBlockAt(0, eventPos.getY() - cVertical, 0);
                    BlockPos maxBlock = maxChunkPos.getBlockAt(15, eventPos.getY() + cVertical, 15);
                    AABB aabb = new AABB((double)minBlock.getX(), (double)minBlock.getY(), (double)minBlock.getZ(), (double)(maxBlock.getX() + 1), (double)(maxBlock.getY() + 1), (double)(maxBlock.getZ() + 1));
                    LevelEntityGetter entityGetter = level.getEntities();
                    entityGetter.get(EntityTypeTest.forClass(Palladium.class), aabb, e -> AbortableIterationConsumer.Continuation.ABORT);
                }
            }
        }

        @SubscribeEvent
        public static void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
            LivingEntity livingEntity;
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getType() == EntityType.OCELOT && livingEntity.hasEffect(MobEffects.DAMAGE_BOOST) && livingEntity.level().getDifficulty() != Difficulty.PEACEFUL && (double)(livingEntity.level().random.nextFloat() * 100.0f) < (Double)GreekFantasy.CONFIG.NEMEAN_LION_LIGHTNING_CHANCE.get()) {
                NemeanLion lion = (NemeanLion)((EntityType)GFRegistry.EntityReg.NEMEAN_LION.get()).create(event.getEntity().level());
                lion.copyPosition(event.getEntity());
                if (event.getEntity().hasCustomName()) {
                    lion.setCustomName(event.getEntity().getCustomName());
                    lion.setCustomNameVisible(event.getEntity().isCustomNameVisible());
                }
                lion.setPersistenceRequired();
                event.getEntity().level().addFreshEntity((Entity)lion);
                event.getEntity().discard();
            }
        }

        @SubscribeEvent
        public static void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
            if (event.isCanceled() || !(event.getLevel() instanceof ServerLevel)) {
                return;
            }
            if (ForgeHandler.isStunnedOrPetrified((LivingEntity)event.getEntity())) {
                event.setCanceled(true);
                return;
            }
            if (ForgeHandler.handleBossTransformInteract((ServerLevel)event.getLevel(), event.getEntity(), event.getTarget(), event.getItemStack())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayerInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
            if (event.isCanceled() || !(event.getLevel() instanceof ServerLevel)) {
                return;
            }
            if (ForgeHandler.isStunnedOrPetrified((LivingEntity)event.getEntity())) {
                event.setCanceled(true);
                return;
            }
            if (ForgeHandler.handleBossTransformInteract((ServerLevel)event.getLevel(), event.getEntity(), event.getTarget(), event.getItemStack())) {
                event.setCanceled(true);
            }
        }

        private static boolean handleBossTransformInteract(ServerLevel level, Player player, Entity target, ItemStack itemStack) {
            if (target.isRemoved()) {
                return false;
            }
            if ((!((Boolean)GreekFantasy.CONFIG.GIANT_BOAR_NON_NETHER.get()).booleanValue() || level.dimension() != Level.NETHER) && target.getType() == EntityType.HOGLIN && target instanceof Hoglin) {
                Hoglin hoglin = (Hoglin)target;
                if (itemStack.is(GiantBoar.TRIGGER) && !hoglin.isBaby()) {
                    GiantBoar.spawnGiantBoar(level, hoglin);
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                    return true;
                }
            }
            if (target.getType() == EntityType.HORSE && target instanceof Horse) {
                Horse horse = (Horse)target;
                if (itemStack.is(Arion.TRIGGER) && !horse.isBaby() && horse.isTamed()) {
                    Arion.spawnArion(level, player, horse);
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                    return true;
                }
            }
            if (target.getType() == EntityType.SHEEP && target instanceof Sheep) {
                Sheep sheep = (Sheep)target;
                if (itemStack.is(GoldenRam.TRIGGER) && sheep.readyForShearing() && sheep.getColor() == DyeColor.YELLOW) {
                    GoldenRam.spawnGoldenRam(level, player, sheep);
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                    return true;
                }
            }
            return false;
        }

        @SubscribeEvent
        public static void onPlayerStartUsingItem(LivingEntityUseItemEvent.Start event) {
            LivingEntity livingEntity;
            if (ForgeHandler.isStunnedOrPetrified(event.getEntity())) {
                event.setCanceled(true);
                return;
            }
            if (!event.getEntity().level().isClientSide() && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                if (!(event.isCanceled() || !event.getItem().is(Items.TRIDENT) || EnchantmentUtils.getEnchantmentLevel(GFEnchantments.LORD_OF_THE_SEA, (LivingEntity)player, event.getItem()) <= 0 || player.getCooldowns().isOnCooldown(Items.TRIDENT) || GreekFantasy.isRGLoaded() && !RGCompat.getInstance().canUseLordOfTheSea((Player)player))) {
                    event.setCanceled(true);
                    ForgeHandler.useLordOfTheSea(player, event.getItem());
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTickUsingItem(LivingEntityUseItemEvent.Tick event) {
            if (ForgeHandler.isStunnedOrPetrified(event.getEntity())) {
                event.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent
        public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
            Player player;
            if (ForgeHandler.isStunnedOrPetrified((LivingEntity)event.getEntity())) {
                event.setCanceled(true);
                return;
            }
            if (!event.getEntity().level().isClientSide() && (player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                if (!event.isCanceled() && event.getItemStack().is(Items.CLOCK) && EnchantmentUtils.getEnchantmentLevel(GFEnchantments.DAYBREAK, (LivingEntity)player2, event.getItemStack()) > 0 && player2.level().getGameRules().getBoolean(GameRules.RULE_DAYLIGHT) && player2.level().getDayTime() % 24000L > 13000L && (!GreekFantasy.isRGLoaded() || RGCompat.getInstance().canUseDaybreak((Player)player2))) {
                    event.setCanceled(true);
                    ForgeHandler.useDaybreak(player2, event.getItemStack());
                }
            }
        }

        private static void useLordOfTheSea(ServerPlayer player, ItemStack item) {
            BlockHitResult raytrace = ThunderboltItem.raytraceFromEntity((LivingEntity)player, 48.0f);
            if (raytrace.getType() != HitResult.Type.MISS) {
                Whirl whirl = (Whirl)((EntityType)GFRegistry.EntityReg.WHIRL.get()).create(player.level());
                BlockPos pos = new BlockPos((int)raytrace.getLocation().x, (int)raytrace.getLocation().y, (int)raytrace.getLocation().z);
                if (player.level().getFluidState(pos).is(FluidTags.WATER) && player.level().getFluidState(pos.below((int)Math.ceil(whirl.getBbHeight()))).is(FluidTags.WATER)) {
                    whirl.moveTo(raytrace.getLocation().x(), raytrace.getLocation().y() - (double)whirl.getBbHeight(), raytrace.getLocation().z(), 0.0f, 0.0f);
                    player.level().addFreshEntity((Entity)whirl);
                    whirl.setLimitedLife((Integer)GreekFantasy.CONFIG.LORD_OF_THE_SEA_WHIRL_LIFESPAN.get() * 20);
                    whirl.setAttractMobs(true);
                    whirl.playSound((SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), 1.5f, 0.6f + whirl.getRandom().nextFloat() * 0.32f);
                    LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(player.level());
                    bolt.setSilent(true);
                    bolt.setPos(raytrace.getLocation().x(), raytrace.getLocation().y(), raytrace.getLocation().z());
                    bolt.setVisualOnly(true);
                    player.level().addFreshEntity((Entity)bolt);
                    player.getCooldowns().addCooldown(item.getItem(), 100);
                    if (!player.isCreative()) {
                        item.hurtAndBreak(25, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    }
                }
            }
        }

        private static void useDaybreak(ServerPlayer player, ItemStack item) {
            ServerLevel world = (ServerLevel)player.level();
            long nextDay = world.getLevelData().getDayTime() + 24000L;
            world.setDayTime(nextDay - nextDay % 24000L);
            player.onEquippedItemBroken(item.getItem(), EquipmentSlot.MAINHAND);
            if (!player.isCreative()) {
                item.shrink(1);
            }
        }

        private static final class PendingSummonCheck {
            private final BlockPos pos;
            private final UUID playerId;
            private int ticksLeft;

            private PendingSummonCheck(BlockPos pos, UUID playerId, int ticksLeft) {
                this.pos = pos;
                this.playerId = playerId;
                this.ticksLeft = ticksLeft;
            }
        }
    }
}

