/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.enchantment.EnchantmentUtils;
import greekfantasy.enchantment.GFEnchantments;
import greekfantasy.integration.RGCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class GFSavedData
extends SavedData {
    private final List<UUID> flyingPlayers = new ArrayList<UUID>();
    private static final String KEY_PLAYERS = "FlyingPlayers";

    public static GFSavedData getOrCreate(ServerLevel server) {
        return (GFSavedData)server.getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(GFSavedData::new, GFSavedData::load), "greekfantasy");
    }

    public static GFSavedData load(CompoundTag nbt, HolderLookup.Provider provider) {
        GFSavedData instance = new GFSavedData();
        instance.loadNBT(nbt);
        return instance;
    }

    public void addFlyingPlayer(Player player) {
        this.flyingPlayers.add(player.getUUID());
        player.getAbilities().mayfly = true;
        player.onUpdateAbilities();
    }

    public void removeFlyingPlayer(Player player) {
        this.flyingPlayers.remove(player.getUUID());
        player.getAbilities().mayfly = false;
        player.getAbilities().flying = false;
        player.onUpdateAbilities();
    }

    public boolean hasFlyingPlayer(Player player) {
        return this.flyingPlayers.contains(player.getUUID());
    }

    public List<UUID> getFlyingPlayers() {
        return this.flyingPlayers;
    }

    public void loadNBT(CompoundTag nbt) {
        if (nbt.contains(KEY_PLAYERS)) {
            ListTag playerList = nbt.getList(KEY_PLAYERS, 8);
            int il = playerList.size();
            for (int i = 0; i < il; ++i) {
                this.flyingPlayers.add(UUID.fromString(playerList.getString(i)));
            }
        }
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        ListTag flyingPlayerList = new ListTag();
        for (UUID uuid : this.flyingPlayers) {
            flyingPlayerList.add((Object)StringTag.valueOf((String)uuid.toString()));
        }
        compound.put(KEY_PLAYERS, (Tag)flyingPlayerList);
        return compound;
    }

    public static boolean validatePlayer(Player player) {
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        return feet.is((Item)GFRegistry.ItemReg.WINGED_SANDALS.get()) && EnchantmentUtils.getEnchantmentLevel(GFEnchantments.FLYING, (LivingEntity)player, feet) > 0 && (!GreekFantasy.isRGLoaded() || RGCompat.getInstance().canUseFlying(player));
    }
}

