/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy;

import greekfantasy.GFConfig;
import greekfantasy.GFEvents;
import greekfantasy.GFRegistry;
import greekfantasy.client.GFClientEvents;
import greekfantasy.network.CPlayNotePacket;
import greekfantasy.network.SCurseOfCircePacket;
import greekfantasy.network.SQuestPacket;
import greekfantasy.util.CodecJsonDataManager;
import greekfantasy.util.Quest;
import greekfantasy.util.Song;
import greekfantasy.worldgen.maze.WeightedTemplateList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="greekfantasy")
public class GreekFantasy {
    public static final String MODID = "greekfantasy";
    public static GFConfig CONFIG;
    public static final Logger LOGGER;
    private static boolean isRpgGodsLoaded;
    private static final CodecJsonDataManager<Song> SONG_JSON_MANAGER;
    public static final Map<ResourceLocation, Song> SONG_MAP;
    private static final CodecJsonDataManager<Quest> QUEST_JSON_MANAGER;
    public static final Map<ResourceLocation, Quest> QUEST_MAP;
    private static final CodecJsonDataManager<WeightedTemplateList> MAZE_PIECE_JSON_MANAGER;

    public GreekFantasy(IEventBus modEventBus, ModContainer modContainer) {
        CONFIG = new GFConfig(modContainer);
        GFRegistry.register(modEventBus);
        NeoForge.EVENT_BUS.register(GFEvents.ForgeHandler.class);
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register(GFClientEvents.ForgeHandler.class);
            modEventBus.register(GFClientEvents.ModHandler.class);
        }
        modEventBus.addListener(GreekFantasy::setup);
        modEventBus.addListener(GreekFantasy::loadConfig);
        modEventBus.addListener(GreekFantasy::reloadConfig);
        modEventBus.addListener(GreekFantasy::registerPayloads);
        NeoForge.EVENT_BUS.addListener(GreekFantasy::addReloadListeners);
    }

    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(CPlayNotePacket.TYPE, CPlayNotePacket.CODEC, CPlayNotePacket::handlePacket);
        registrar.playToClient(SQuestPacket.TYPE, SQuestPacket.CODEC, SQuestPacket::handlePacket);
        registrar.playToClient(SCurseOfCircePacket.TYPE, SCurseOfCircePacket.CODEC, SCurseOfCircePacket::handlePacket);
    }

    public static void setup(FMLCommonSetupEvent event) {
        isRpgGodsLoaded = ModList.get().isLoaded("rpggods");
    }

    public static void loadConfig(ModConfigEvent.Loading event) {
        CONFIG.bake();
    }

    public static void reloadConfig(ModConfigEvent.Reloading event) {
        CONFIG.bake();
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(QUEST_JSON_MANAGER);
        event.addListener(SONG_JSON_MANAGER);
        event.addListener(MAZE_PIECE_JSON_MANAGER);
    }

    public static WeightedTemplateList getMazePiece(ResourceLocation id) {
        return MAZE_PIECE_JSON_MANAGER.getData().getOrDefault(id, WeightedTemplateList.EMPTY);
    }

    public static boolean isRGLoaded() {
        return isRpgGodsLoaded;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MODID);
        SONG_JSON_MANAGER = new CodecJsonDataManager<Song>("songs", Song.CODEC);
        SONG_MAP = new HashMap<ResourceLocation, Song>();
        QUEST_JSON_MANAGER = new CodecJsonDataManager<Quest>("quests", Quest.CODEC);
        QUEST_MAP = new HashMap<ResourceLocation, Quest>();
        QUEST_JSON_MANAGER.subscribeAsSyncable(SQuestPacket::new);
        MAZE_PIECE_JSON_MANAGER = new CodecJsonDataManager<WeightedTemplateList>("worldgen/maze_piece", WeightedTemplateList.CODEC);
    }
}

