/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import greekfantasy.GFRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GoldenStringBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    protected static final VoxelShape SHAPE_CENTER = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)3.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0);
    protected static final Map<BlockState, VoxelShape> SHAPE_MAP = new HashMap<BlockState, VoxelShape>();

    public GoldenStringBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH}).add(new Property[]{EAST}).add(new Property[]{SOUTH}).add(new Property[]{WEST}).add(new Property[]{AGE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return super.getStateForPlacement(context);
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)blockState.getValue((Property)AGE) <= 0) {
            level.setBlock(pos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.canSurvive((LevelReader)level, currentPos)) {
            return stateIn.getFluidState().getType().defaultFluidState().createLegacyBlock();
        }
        if ((Integer)stateIn.getValue((Property)AGE) <= 0) {
            level.scheduleTick(currentPos, (Block)this, 80);
        }
        boolean north = level.getBlockState(currentPos.relative(Direction.NORTH)).getBlock() == this;
        boolean east = level.getBlockState(currentPos.relative(Direction.EAST)).getBlock() == this;
        boolean south = level.getBlockState(currentPos.relative(Direction.SOUTH)).getBlock() == this;
        boolean west = level.getBlockState(currentPos.relative(Direction.WEST)).getBlock() == this;
        return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = worldIn.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP);
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_MAP.computeIfAbsent((BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), state -> GoldenStringBlock.computeShape(state, level, pos, context));
    }

    private static VoxelShape computeShape(BlockState blockstate, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = SHAPE_CENTER;
        if (((Boolean)blockstate.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)SHAPE_NORTH, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)blockstate.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)SHAPE_EAST, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)blockstate.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)blockstate.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)SHAPE_WEST, (BooleanOp)BooleanOp.OR);
        }
        shape = shape.optimize();
        return shape;
    }

    public Item asItem() {
        return (Item)GFRegistry.ItemReg.GOLDEN_STRING.get();
    }
}

