/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import com.mojang.serialization.MapCodec;
import greekfantasy.util.MysteriousBoxManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MysteriousBoxBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<MysteriousBoxBlock> CODEC = MysteriousBoxBlock.simpleCodec(MysteriousBoxBlock::new);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE_CLOSED_Z = Shapes.joinUnoptimized((VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)13.0), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)2.0, (double)11.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    protected static final VoxelShape SHAPE_OPEN_Z = Shapes.joinUnoptimized((VoxelShape)SHAPE_CLOSED_Z, (VoxelShape)Block.box((double)2.0, (double)3.0, (double)4.0, (double)14.0, (double)8.0, (double)12.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    protected static final VoxelShape SHAPE_CLOSED_X = Shapes.joinUnoptimized((VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)2.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)2.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    protected static final VoxelShape SHAPE_OPEN_X = Shapes.joinUnoptimized((VoxelShape)SHAPE_CLOSED_X, (VoxelShape)Block.box((double)4.0, (double)3.0, (double)2.0, (double)12.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    protected static final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public MysteriousBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{OPEN}).add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.is(FluidTags.WATER)))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            this.addSmokeParticles(level, pos, level.random, 32);
            level.playSound(player, pos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.8f + level.getRandom().nextFloat() * 0.4f, 0.8f + level.getRandom().nextFloat() * 0.4f);
            if (!player.level().isClientSide() && MysteriousBoxManager.onBoxOpened(level, player, state, pos)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 2);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue() || willHarvest || null == player) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        this.playerWillDestroy(level, pos, state, player);
        this.addSmokeParticles(level, pos, level.random, 32);
        level.playSound(player, pos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.8f + level.getRandom().nextFloat() * 0.4f, 0.8f + level.getRandom().nextFloat() * 0.4f);
        if (!player.level().isClientSide() && MysteriousBoxManager.onBoxOpened(level, player, state, pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 2);
        }
        return false;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        Level actualLevel;
        ItemStack selected = player.getInventory().getSelected();
        boolean hasSilkTouch = level instanceof Level && selected.getEnchantmentLevel((Holder)(actualLevel = (Level)level).registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH)) > 0;
        return super.canHarvestBlock(state, level, pos, player) && ((Boolean)state.getValue((Property)OPEN) != false || hasSilkTouch);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.computeIfAbsent(blockState, state -> MysteriousBoxBlock.computeShape(state, level, pos, context));
    }

    private static VoxelShape computeShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean axisX = ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X;
        boolean open = (Boolean)state.getValue((Property)OPEN);
        if (axisX && open) {
            return SHAPE_OPEN_X;
        }
        if (axisX) {
            return SHAPE_CLOSED_X;
        }
        if (open) {
            return SHAPE_OPEN_Z;
        }
        return SHAPE_CLOSED_Z;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.getValue((Property)OPEN) != false ? 1 : 0;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)OPEN)).booleanValue()) {
            this.addSmokeParticles(level, pos, rand, 3);
        }
    }

    private void addSmokeParticles(Level world, BlockPos pos, RandomSource rand, int count) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.22;
        double z = (double)pos.getZ() + 0.5;
        double motion = 0.08;
        double radius = 0.25;
        for (int i = 0; i < count; ++i) {
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + (world.random.nextDouble() - 0.5) * 0.25, y, z + (world.random.nextDouble() - 0.5) * 0.25, (world.random.nextDouble() - 0.5) * 0.08, (world.random.nextDouble() - 0.5) * 0.08 * 0.5, (world.random.nextDouble() - 0.5) * 0.08);
        }
    }
}

