/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NestBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape AABB_OCTAL_NE = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape AABB_OCTAL_SE = Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_OCTAL_SW = Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_OCTAL_NW = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final Map<BlockState, VoxelShape> SHAPE_MAP = new HashMap<BlockState, VoxelShape>();

    public NestBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH}).add(new Property[]{EAST}).add(new Property[]{SOUTH}).add(new Property[]{WEST}).add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.is(FluidTags.WATER)));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        boolean north = worldIn.getBlockState(currentPos.relative(Direction.NORTH)).getBlock() != this;
        boolean east = worldIn.getBlockState(currentPos.relative(Direction.EAST)).getBlock() != this;
        boolean south = worldIn.getBlockState(currentPos.relative(Direction.SOUTH)).getBlock() != this;
        boolean west = worldIn.getBlockState(currentPos.relative(Direction.WEST)).getBlock() != this;
        return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_MAP.computeIfAbsent(blockstate, state -> NestBlock.computeShape(state, level, pos, context));
    }

    private static VoxelShape computeShape(BlockState blockstate, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = AABB_SLAB_BOTTOM;
        boolean north = (Boolean)blockstate.getValue((Property)NORTH);
        boolean east = (Boolean)blockstate.getValue((Property)EAST);
        boolean south = (Boolean)blockstate.getValue((Property)SOUTH);
        boolean west = (Boolean)blockstate.getValue((Property)WEST);
        if (north || east) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)AABB_OCTAL_NE, (BooleanOp)BooleanOp.OR);
        }
        if (north || west) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)AABB_OCTAL_NW, (BooleanOp)BooleanOp.OR);
        }
        if (south || east) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)AABB_OCTAL_SE, (BooleanOp)BooleanOp.OR);
        }
        if (south || west) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)AABB_OCTAL_SW, (BooleanOp)BooleanOp.OR);
        }
        shape = shape.optimize();
        return shape;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (face == Direction.UP) {
            return 0;
        }
        return 10;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (face == Direction.UP) {
            return 0;
        }
        return 10;
    }
}

