/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OilLampBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<OilLampBlock> CODEC = OilLampBlock.simpleCodec(OilLampBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    protected static final VoxelShape[] SHAPES;

    public OilLampBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, LIT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        boolean waterlogged = fluid.is(FluidTags.WATER);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(!waterlogged))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
            if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
                worldIn.setBlock(currentPos, (BlockState)stateIn.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
        return stateIn;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player playerIn, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            playerIn.playSound(SoundEvents.FIRE_EXTINGUISH, 0.4f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        if (stack.getItem() == Items.FLINT_AND_STEEL && !((Boolean)state.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            playerIn.playSound(SoundEvents.FLINTANDSTEEL_USE, 0.4f, 1.0f);
            stack.hurtAndBreak(1, (LivingEntity)playerIn, EquipmentSlot.MAINHAND);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext cxt) {
        int horizIndex = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        return horizIndex < 0 ? Shapes.block() : SHAPES[horizIndex];
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            Direction d = ((Direction)stateIn.getValue((Property)FACING)).getCounterClockWise();
            double addX = 0.32 * (double)d.getStepX();
            double addY = 0.4;
            double addZ = 0.32 * (double)d.getStepZ();
            Vec3 vec = Vec3.atBottomCenterOf((Vec3i)pos).add(addX, addY, addZ);
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, vec.x(), vec.y(), vec.z(), 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, vec.x(), vec.y(), vec.z(), 0.0, 0.0, 0.0);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level worldIn, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }

    static {
        VoxelShape bodyX = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        VoxelShape bodyZ = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        VoxelShape handleN = Shapes.joinUnoptimized((VoxelShape)Block.box((double)12.0, (double)0.0, (double)7.0, (double)14.0, (double)4.0, (double)9.0), (VoxelShape)Block.box((double)12.0, (double)1.0, (double)7.0, (double)13.0, (double)3.0, (double)9.0), (BooleanOp)BooleanOp.ONLY_FIRST);
        VoxelShape handleS = Shapes.joinUnoptimized((VoxelShape)Block.box((double)2.0, (double)0.0, (double)7.0, (double)4.0, (double)4.0, (double)9.0), (VoxelShape)Block.box((double)3.0, (double)1.0, (double)7.0, (double)4.0, (double)3.0, (double)9.0), (BooleanOp)BooleanOp.ONLY_FIRST);
        VoxelShape handleW = Shapes.joinUnoptimized((VoxelShape)Block.box((double)7.0, (double)0.0, (double)2.0, (double)9.0, (double)4.0, (double)4.0), (VoxelShape)Block.box((double)7.0, (double)1.0, (double)3.0, (double)9.0, (double)3.0, (double)4.0), (BooleanOp)BooleanOp.ONLY_FIRST);
        VoxelShape handleE = Shapes.joinUnoptimized((VoxelShape)Block.box((double)7.0, (double)0.0, (double)12.0, (double)9.0, (double)4.0, (double)14.0), (VoxelShape)Block.box((double)7.0, (double)1.0, (double)12.0, (double)9.0, (double)3.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST);
        VoxelShape shapeN = Shapes.or((VoxelShape)bodyX, (VoxelShape[])new VoxelShape[]{handleN, Block.box((double)1.0, (double)2.0, (double)6.0, (double)4.0, (double)4.0, (double)10.0)});
        VoxelShape shapeS = Shapes.or((VoxelShape)bodyX, (VoxelShape[])new VoxelShape[]{handleS, Block.box((double)12.0, (double)2.0, (double)6.0, (double)15.0, (double)4.0, (double)10.0)});
        VoxelShape shapeW = Shapes.or((VoxelShape)bodyZ, (VoxelShape[])new VoxelShape[]{handleW, Block.box((double)6.0, (double)2.0, (double)12.0, (double)10.0, (double)4.0, (double)15.0)});
        VoxelShape shapeE = Shapes.or((VoxelShape)bodyZ, (VoxelShape[])new VoxelShape[]{handleE, Block.box((double)6.0, (double)2.0, (double)1.0, (double)10.0, (double)4.0, (double)4.0)});
        SHAPES = new VoxelShape[]{shapeS, shapeW, shapeN, shapeE};
    }
}

