/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import greekfantasy.GFRegistry;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public class OliveOilBlock
extends Block
implements LiquidBlockContainer {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    protected final float fireDamage;
    protected static final VoxelShape shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape shapeWaterlogged = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public OliveOilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.fireDamage = 2.5f;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, WATERLOGGED});
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!(level.isClientSide() || ((Boolean)state.getValue((Property)LIT)).booleanValue() || heldItem.isEmpty())) {
            if (heldItem.getItem() == Items.GLASS_BOTTLE) {
                level.destroyBlock(pos, false);
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
                player.addItem(new ItemStack((ItemLike)GFRegistry.ItemReg.OLIVE_OIL.get()));
                return ItemInteractionResult.CONSUME;
            }
            if (heldItem.getItem() == Items.FLINT_AND_STEEL) {
                OliveOilBlock.setFire(level, state, pos);
                player.playSound(SoundEvents.FLINTANDSTEEL_USE, 0.4f, 1.0f);
                heldItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        boolean nextToFire;
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            if (level.getBlockState(pos.above()).getBlock() == Blocks.WATER) {
                level.setBlockAndUpdate(pos.above(), state);
                level.setBlock(pos, state.getFluidState().createLegacyBlock(), 2);
                level.scheduleTick(pos.above(), (Block)this, 40);
                return;
            }
            if (level.getBlockState(pos.above()).getBlock() == this) {
                level.setBlock(pos, state.getFluidState().createLegacyBlock(), 2);
                level.scheduleTick(pos.above(), (Block)this, 40);
                return;
            }
        }
        if (nextToFire = OliveOilBlock.nextToFire((LevelReader)level, pos)) {
            if (level.getRandom().nextInt(10) == 0) {
                OliveOilBlock.setFire((Level)level, state, pos);
            } else {
                level.scheduleTick(pos, (Block)this, 2 + rand.nextInt(5));
            }
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(stateIn, (LevelReader)level, currentPos)) {
            return stateIn.getFluidState().createLegacyBlock();
        }
        if (OliveOilBlock.isFire((LevelReader)level, facingState, facingPos)) {
            level.scheduleTick(currentPos, (Block)this, 5);
        }
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue() && level.getBlockState(currentPos.above()).getBlock() != Blocks.SOUL_FIRE) {
                level.destroyBlock(currentPos, false);
            } else {
                level.scheduleTick(currentPos, (Block)this, 2);
                level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
        }
        return stateIn;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        boolean waterlogged = fluid.is(FluidTags.WATER);
        if (waterlogged || OliveOilBlock.nextToFire((LevelReader)context.getLevel(), context.getClickedPos())) {
            context.getLevel().scheduleTick(context.getClickedPos(), (Block)this, 5);
        }
        return (BlockState)super.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false ? shape : shapeWaterlogged;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (!level.getFluidState(pos.above()).isEmpty()) {
            return false;
        }
        return (Boolean)state.getValue((Property)WATERLOGGED) != false || level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return fluid == Fluids.FLOWING_WATER || fluid == Fluids.WATER;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        level.setBlock(pos, fluidState.createLegacyBlock(), 3);
        level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
        return true;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !entityIn.fireImmune()) {
            entityIn.setRemainingFireTicks(level.getRandom().nextInt(5) + 5);
            entityIn.hurt(entityIn.damageSources().inFire(), this.fireDamage);
        }
        super.entityInside(state, level, pos, entityIn);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            if (((Boolean)state.getValue((Property)LIT)).booleanValue() && OliveOilBlock.inPortalDimension(level)) {
                Optional optional = PortalShape.findEmptyPortalShape((LevelAccessor)level, (BlockPos)pos, (Direction.Axis)Direction.Axis.X);
                if ((optional = EventHooks.onTrySpawnPortal((LevelAccessor)level, (BlockPos)pos, (Optional)optional)).isPresent()) {
                    ((PortalShape)optional.get()).createPortalBlocks();
                    return;
                }
            }
            if (!state.canSurvive((LevelReader)level, pos)) {
                level.removeBlock(pos, false);
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (!level.isClientSide()) {
                level.levelEvent(null, 1009, pos, 0);
            }
            return state;
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            if (rand.nextInt(24) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                double d0 = (double)pos.getX() + rand.nextDouble();
                double d1 = (double)pos.getY() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.getZ() + rand.nextDouble();
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    private static boolean inPortalDimension(Level world) {
        return world.dimension() == Level.OVERWORLD || world.dimension() == Level.NETHER;
    }

    private static boolean nextToFire(LevelReader world, BlockPos pos) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockPos p = pos.relative(d);
            BlockState s = world.getBlockState(p);
            if (!OliveOilBlock.isFire(world, s, p)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFire(LevelReader world, BlockState state, BlockPos pos) {
        return state.is(BlockTags.FIRE) || state.is((Block)GFRegistry.BlockReg.OLIVE_OIL.get()) && (Boolean)state.getValue((Property)LIT) != false;
    }

    public static void setFire(Level level, BlockState state, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            if (level.isEmptyBlock(pos.above())) {
                level.setBlock(pos.above(), Blocks.SOUL_FIRE.defaultBlockState(), 3);
            }
        } else if (OliveOilBlock.inPortalDimension(level)) {
            Optional optional = PortalShape.findEmptyPortalShape((LevelAccessor)level, (BlockPos)pos, (Direction.Axis)Direction.Axis.X);
            if ((optional = EventHooks.onTrySpawnPortal((LevelAccessor)level, (BlockPos)pos, (Optional)optional)).isPresent()) {
                ((PortalShape)optional.get()).createPortalBlocks();
                return;
            }
            if (!state.canSurvive((LevelReader)level, pos)) {
                level.removeBlock(pos, false);
            }
        }
    }
}

