/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PillarBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<PillarBlock> CODEC = PillarBlock.simpleCodec(PillarBlock::new);
    public static final BooleanProperty HIDDEN = BooleanProperty.create((String)"hidden");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape PILLAR_X = Block.box((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape PILLAR_Y = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape PILLAR_Z = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final EnumMap<Direction, VoxelShape> SLAB_SHAPES = Maps.newEnumMap(Direction.class);
    protected static final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public PillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HIDDEN, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction side = context.getClickedFace().getOpposite();
        if (context.getPlayer() != null && context.getPlayer().isCrouching() || this.isPillarBlock(context.getLevel().getBlockState(context.getClickedPos().relative(side)))) {
            side = side.getOpposite();
        }
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)side)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.is(FluidTags.WATER)));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction capDir;
        BlockState adjacent;
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        boolean hidden = this.isPillarBlock(adjacent = worldIn.getBlockState(currentPos.relative(capDir = (Direction)stateIn.getValue((Property)FACING)))) && adjacent.getValue((Property)FACING) == capDir;
        return (BlockState)stateIn.setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(hidden));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.computeIfAbsent(blockState, state -> PillarBlock.computeShape(state, level, pos, context));
    }

    private static VoxelShape computeShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext cxt) {
        boolean hidden = (Boolean)blockState.getValue((Property)HIDDEN);
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        if (!hidden) {
            return SLAB_SHAPES.get(facing);
        }
        if (facing.getAxis() == Direction.Axis.Y) {
            return PILLAR_Y;
        }
        if (facing.getAxis() == Direction.Axis.X) {
            return PILLAR_X;
        }
        return PILLAR_Z;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return this.rotate(state, mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    private boolean isPillarBlock(BlockState state) {
        return state.getBlock() instanceof PillarBlock;
    }

    static {
        SLAB_SHAPES.put(Direction.UP, Shapes.joinUnoptimized((VoxelShape)PILLAR_Y, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR));
        SLAB_SHAPES.put(Direction.DOWN, Shapes.joinUnoptimized((VoxelShape)PILLAR_Y, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.OR));
        SLAB_SHAPES.put(Direction.NORTH, Shapes.joinUnoptimized((VoxelShape)PILLAR_Z, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (BooleanOp)BooleanOp.OR));
        SLAB_SHAPES.put(Direction.SOUTH, Shapes.joinUnoptimized((VoxelShape)PILLAR_Z, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR));
        SLAB_SHAPES.put(Direction.EAST, Shapes.joinUnoptimized((VoxelShape)PILLAR_X, (VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR));
        SLAB_SHAPES.put(Direction.WEST, Shapes.joinUnoptimized((VoxelShape)PILLAR_X, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR));
    }
}

