/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import com.mojang.serialization.MapCodec;
import greekfantasy.GFRegistry;
import greekfantasy.blockentity.VaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VaseBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<VaseBlock> CODEC = VaseBlock.simpleCodec(VaseBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape BODY = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Shapes.joinUnoptimized((VoxelShape)Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape)Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), (BooleanOp)BooleanOp.ONLY_FIRST)});
    protected static final VoxelShape HANDLE_Z = Shapes.or((VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)12.0, (double)1.0, (double)7.0, (double)14.0, (double)7.0, (double)9.0), (VoxelShape)Block.box((double)12.0, (double)2.0, (double)7.0, (double)13.0, (double)6.0, (double)9.0), (BooleanOp)BooleanOp.ONLY_FIRST), (VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)2.0, (double)1.0, (double)7.0, (double)4.0, (double)7.0, (double)9.0), (VoxelShape)Block.box((double)3.0, (double)2.0, (double)7.0, (double)4.0, (double)6.0, (double)9.0), (BooleanOp)BooleanOp.ONLY_FIRST));
    protected static final VoxelShape HANDLE_X = Shapes.or((VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)7.0, (double)1.0, (double)2.0, (double)9.0, (double)7.0, (double)4.0), (VoxelShape)Block.box((double)7.0, (double)2.0, (double)3.0, (double)9.0, (double)6.0, (double)4.0), (BooleanOp)BooleanOp.ONLY_FIRST), (VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)7.0, (double)1.0, (double)12.0, (double)9.0, (double)7.0, (double)14.0), (VoxelShape)Block.box((double)7.0, (double)2.0, (double)12.0, (double)9.0, (double)6.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST));
    protected static final VoxelShape SHAPE_X = Shapes.joinUnoptimized((VoxelShape)BODY, (VoxelShape)HANDLE_X, (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape SHAPE_Z = Shapes.joinUnoptimized((VoxelShape)BODY, (VoxelShape)HANDLE_Z, (BooleanOp)BooleanOp.OR);

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public VaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.is(FluidTags.WATER)))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player playerIn, BlockHitResult hit) {
        VaseBlockEntity vaseBlockEntity;
        ItemStack teStack;
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof VaseBlockEntity && !(teStack = (vaseBlockEntity = (VaseBlockEntity)blockEntity).getItem(0)).isEmpty() && playerIn.isShiftKeyDown()) {
            ItemEntity dropItem = new ItemEntity(worldIn, playerIn.getX(), playerIn.getY(), playerIn.getZ(), vaseBlockEntity.removeItemNoUpdate(0));
            dropItem.setPickUpDelay(0);
            worldIn.addFreshEntity((Entity)dropItem);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof VaseBlockEntity) {
            VaseBlockEntity vaseBlockEntity = (VaseBlockEntity)blockEntity;
            ItemStack teStack = vaseBlockEntity.getItem(0);
            if (teStack.isEmpty() && !stack.isEmpty()) {
                vaseBlockEntity.setItem(0, stack.copy());
                playerIn.setItemInHand(handIn, ItemStack.EMPTY);
                return ItemInteractionResult.CONSUME;
            }
            if (!teStack.isEmpty()) {
                ItemEntity dropItem = new ItemEntity(worldIn, playerIn.getX(), playerIn.getY(), playerIn.getZ(), vaseBlockEntity.removeItemNoUpdate(0));
                dropItem.setPickUpDelay(0);
                worldIn.addFreshEntity((Entity)dropItem);
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (!level.isClientSide() && tileentity instanceof VaseBlockEntity) {
                VaseBlockEntity vaseBlockEntity = (VaseBlockEntity)tileentity;
                vaseBlockEntity.dropAllItems();
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
        }
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext cxt) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        VaseBlockEntity blockEntity = (VaseBlockEntity)((BlockEntityType)GFRegistry.BlockEntityReg.VASE.get()).create(pos, state);
        return blockEntity;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)container);
        }
        return 0;
    }
}

