/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WildRoseBlock
extends FlowerBlock {
    private final Holder<MobEffect> mobEffect;
    private final int duration;

    public WildRoseBlock(Holder<MobEffect> mobEffect, int duration, BlockBehaviour.Properties properties) {
        super(mobEffect, (float)duration, properties);
        this.mobEffect = mobEffect;
        this.duration = duration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level level, BlockPos blockpos, Random rand) {
        VoxelShape shape = this.getShape(blockstate, (BlockGetter)level, blockpos, CollisionContext.empty());
        Vec3 center = shape.bounds().getCenter();
        double posX = (double)blockpos.getX() + center.x;
        double posZ = (double)blockpos.getZ() + center.z;
        if (rand.nextInt(3) == 0) {
            level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)1.0f, (float)0.6f, (float)0.92f), posX + rand.nextDouble() / 5.0, (double)blockpos.getY() + 0.5 - rand.nextDouble(), posZ + rand.nextDouble() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        if (!world.isClientSide() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(this.mobEffect, this.duration * 8));
        }
    }
}

