/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.blockentity;

import greekfantasy.GFRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VaseBlockEntity
extends BlockEntity
implements Container,
Nameable {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    protected Component name;

    public VaseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GFRegistry.BlockEntityReg.VASE.get(), pos, state);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
        this.inventoryChanged();
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public void dropAllItems() {
        if (this.level != null && !this.level.isClientSide()) {
            Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), this.getInventory());
        }
        this.inventoryChanged();
    }

    public void inventoryChanged() {
        ItemStack itemStack;
        if (this.getLevel() != null && !this.getLevel().isClientSide()) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        this.name = (itemStack = this.getItem(0)).has(DataComponents.CUSTOM_NAME) ? itemStack.getHoverName() : null;
    }

    public void setChanged() {
        super.setChanged();
        this.inventoryChanged();
    }

    public void clearContent() {
        this.getInventory().clear();
        this.setChanged();
    }

    public int getContainerSize() {
        return this.getInventory().size();
    }

    public boolean isEmpty() {
        return this.getInventory().isEmpty();
    }

    public ItemStack getItem(int index) {
        return index >= 0 && index < this.getInventory().size() ? (ItemStack)this.getInventory().get(index) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemStack = ContainerHelper.removeItem(this.getInventory(), (int)index, (int)count);
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack itemStack = ContainerHelper.takeItem(this.getInventory(), (int)index);
        return itemStack;
    }

    public void setItem(int index, ItemStack stack) {
        if (index >= 0 && index < this.getInventory().size()) {
            this.getInventory().set(index, (Object)stack);
            this.inventoryChanged();
        }
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.getInventory().clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.getInventory(), (HolderLookup.Provider)registries);
        this.inventoryChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.getInventory(), (HolderLookup.Provider)registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.vase");
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }
}

