/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.armor;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class NemeanArmorModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation NEMEAN_ARMOR_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"nemean_armor"), "nemean_armor");

    public NemeanArmorModel(ModelPart root) {
        super(root);
        this.leftLeg.visible = false;
        this.rightLeg.visible = false;
    }

    public static LayerDefinition createBodyLayer() {
        CubeDeformation cubeDeformation = LayerDefinitions.INNER_ARMOR_DEFORMATION;
        CubeDeformation noDeformation = cubeDeformation.extend(-0.5f);
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lionHead = hat.addOrReplaceChild("lion_head", CubeListBuilder.create().texOffs(36, 0).addBox(-5.0f, -8.9f, -7.0f, 10.0f, 10.0f, 4.0f, cubeDeformation).texOffs(36, 14).addBox(-4.0f, -8.0f, -2.0f, 8.0f, 9.0f, 1.0f, cubeDeformation).texOffs(0, 0).addBox(-4.0f, -9.0f, -10.0f, 8.0f, 1.0f, 2.0f, cubeDeformation).texOffs(0, 4).addBox(-4.0f, -7.0f, -12.0f, 8.0f, 3.0f, 4.0f, cubeDeformation).texOffs(21, 0).addBox(-2.0f, -6.01f, -13.0f, 4.0f, 2.0f, 1.0f, cubeDeformation).texOffs(0, 11).addBox(-4.0f, -4.01f, -12.0f, 8.0f, 2.0f, 3.0f, noDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)5.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        lionHead.addOrReplaceChild("ears", CubeListBuilder.create().texOffs(21, 4).mirror().addBox(2.0f, -2.75f, 1.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).mirror(false).texOffs(21, 4).addBox(-4.0f, -2.75f, 1.0f, 2.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-9.5f, (float)-8.25f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 18.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("upper_tail", CubeListBuilder.create().texOffs(56, 35).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 5.0f, 1.0f, noDeformation).texOffs(56, 42).addBox(-1.0f, -5.5f, -1.0f, 2.0f, 2.0f, 1.0f, noDeformation), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)2.0f, (float)-2.7925f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_claws", CubeListBuilder.create().texOffs(56, 32).addBox(-1.0f, 0.5f, 0.5f, 3.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)-1.0f, (float)-1.5f, (float)-2.5f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_claws", CubeListBuilder.create().texOffs(56, 32).addBox(-1.0f, 0.5f, 0.5f, 3.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)-2.5f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void copyRotations(HumanoidModel<?> model) {
        this.head.copyFrom(model.head);
        this.hat.copyFrom(model.hat);
        this.body.copyFrom(model.body);
        this.leftArm.copyFrom(model.leftArm);
        this.rightArm.copyFrom(model.rightArm);
        this.leftLeg.copyFrom(model.leftLeg);
        this.rightLeg.copyFrom(model.rightLeg);
    }
}

