/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.armor;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class WingedSandalsModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation WINGED_SANDALS_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"winged_sandals"), "winged_sandals");
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public WingedSandalsModel(ModelPart root) {
        super(root);
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.leftWing = this.leftLeg.getChild("left_wing");
        this.rightWing = this.rightLeg.getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)2.0f, (float)12.0f, (float)2.0f));
        left_leg.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(16, 18).mirror().addBox(0.0f, -6.0f, -1.0f, 5.0f, 6.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)11.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(16, 18).addBox(-5.0f, -6.0f, -1.0f, 5.0f, 6.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)11.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.leftLeg, (Object)this.rightLeg);
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.setupWingsAnim(entity);
    }

    public void setupWingsAnim(LivingEntity entity) {
        float wingAngle;
        float ageInTicks = (float)entity.tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float wingSpeed = entity.onGround() ? 0.64f : 1.18f;
        float wingSpan = 0.76854f;
        this.rightWing.yRot = wingAngle = 0.76854f - Mth.cos((float)((ageInTicks + (float)entity.getId()) * wingSpeed)) * 0.76854f * 0.65f;
        this.leftWing.yRot = -wingAngle;
    }
}

